/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Geometry;

public class SumAreaVisitor
extends SumVisitor {
    static FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);

    public SumAreaVisitor(Expression expr) throws IllegalFilterException {
        super((Expression)factory.function("area2", new Expression[]{expr}));
    }

    @Override
    public void visit(SimpleFeature feature) {
        this.setStrategy(new SumAreaStrategy());
        super.visit(feature);
    }

    @Override
    public void visit(Feature feature) {
        this.setStrategy(new SumAreaStrategy());
        super.visit(feature);
    }

    public SumAreaVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        this((Expression)factory.property(type.getDescriptor(attributeTypeIndex).getLocalName()));
    }

    public SumAreaVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        this((Expression)factory.property(type.getDescriptor(attrName).getLocalName()));
    }

    @Override
    public Optional<List<Class>> getResultType(List<Class> inputTypes) {
        if (inputTypes == null || inputTypes.size() != 1) {
            throw new IllegalArgumentException("Expecting a single type in input, not " + String.valueOf(inputTypes));
        }
        Class type = inputTypes.get(0);
        if (Geometry.class.isAssignableFrom(type)) {
            return Optional.of(Collections.singletonList(Double.class));
        }
        throw new IllegalArgumentException("The input type for sum must be geometric, instead this was found: " + String.valueOf(type));
    }

    static class SumAreaStrategy
    implements SumVisitor.SumStrategy {
        Double number = null;

        SumAreaStrategy() {
        }

        @Override
        public void add(Object value) {
            Number num = (Number)value;
            if (num.doubleValue() >= 0.0) {
                if (this.number == null) {
                    this.number = 0.0;
                }
                this.number = this.number + num.doubleValue();
            }
        }

        @Override
        public Object getResult() {
            return this.number == null ? null : Double.valueOf(this.number);
        }
    }
}

