/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public enum Aggregate {
    AVERAGE{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new AverageVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            if (value == null) {
                return AbstractCalcResult.NULL_RESULT;
            }
            return new AverageVisitor.AverageResult(value);
        }

        @Override
        public Class getTargetType(Class inputType) {
            if (!Number.class.isAssignableFrom(inputType)) {
                throw new IllegalArgumentException("Average can be computed only on numeric types");
            }
            return Double.class;
        }
    }
    ,
    COUNT{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new CountVisitor();
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            int count = (Integer)Converters.convert((Object)value, Integer.class);
            return new CountVisitor.CountResult(count);
        }

        @Override
        public Class getTargetType(Class inputType) {
            return Long.class;
        }
    }
    ,
    MAX{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MaxVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new MaxVisitor.MaxResult((Comparable)value);
        }

        @Override
        public Class getTargetType(Class inputType) {
            if (!Comparable.class.isAssignableFrom(inputType)) {
                throw new IllegalArgumentException("Max can be computed only on comparable types");
            }
            return inputType;
        }
    }
    ,
    MEDIAN{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MedianVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new MedianVisitor.MedianResult(value);
        }

        @Override
        public Class getTargetType(Class inputType) {
            if (!Comparable.class.isAssignableFrom(inputType)) {
                throw new IllegalArgumentException("Median can be computed only on comparable types");
            }
            return inputType;
        }
    }
    ,
    MIN{

        @Override
        public FeatureCalc create(Expression aggregateAttribute) {
            return new MinVisitor(aggregateAttribute);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            return new MinVisitor.MinResult((Comparable)value);
        }

        @Override
        public Class getTargetType(Class inputType) {
            if (!Comparable.class.isAssignableFrom(inputType)) {
                throw new IllegalArgumentException("Min can be computed only on comparable types");
            }
            return inputType;
        }
    }
    ,
    STD_DEV{

        @Override
        public FeatureCalc create(Expression expr) {
            return new StandardDeviationVisitor(expr);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            if (value == null) {
                return AbstractCalcResult.NULL_RESULT;
            }
            Double deviation = (Double)Converters.convert((Object)value, Double.class);
            return new StandardDeviationVisitor.Result(deviation);
        }

        @Override
        public Class getTargetType(Class inputType) {
            if (!Number.class.isAssignableFrom(inputType)) {
                throw new IllegalArgumentException("Standard deviation can be computed only on numeric types");
            }
            return inputType;
        }
    }
    ,
    SUM{

        @Override
        public FeatureCalc create(Expression expr) {
            return new SumVisitor(expr);
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            if (value == null) {
                return AbstractCalcResult.NULL_RESULT;
            }
            return new SumVisitor.SumResult(value);
        }

        @Override
        public Class getTargetType(Class inputType) {
            if (!Number.class.isAssignableFrom(inputType)) {
                throw new IllegalArgumentException("Sum can be computed only on numeric types");
            }
            return Double.class;
        }
    }
    ,
    SUMAREA{

        @Override
        public FeatureCalc create(Expression expr) {
            if (expr instanceof FunctionExpression) {
                return new SumVisitor(expr);
            }
            FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
            return new SumVisitor((Expression)factory.function("area2", new Expression[]{expr}));
        }

        @Override
        public CalcResult wrap(Expression aggregateAttribute, Object value) {
            if (value == null) {
                return AbstractCalcResult.NULL_RESULT;
            }
            return new SumVisitor.SumResult(value);
        }

        @Override
        public Class getTargetType(Class inputType) {
            if (!Geometry.class.isAssignableFrom(inputType)) {
                throw new IllegalArgumentException("Sum area can be computed only on geometries");
            }
            return Double.class;
        }
    };


    public abstract FeatureCalc create(Expression var1);

    public abstract CalcResult wrap(Expression var1, Object var2);

    public abstract Class getTargetType(Class var1);

    public static Aggregate valueOfIgnoreCase(String visitorName) {
        if ("stddev".equalsIgnoreCase(visitorName) || "std-dev".equalsIgnoreCase(visitorName)) {
            return STD_DEV;
        }
        return Aggregate.valueOf(visitorName.toUpperCase());
    }
}

