/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LengthFunction;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FeatureTypes {
    static final Logger LOGGER;
    public static final URI DEFAULT_NAMESPACE;
    public static final SimpleFeatureType ABSTRACT_FEATURE_TYPE;
    public static final NameImpl DEFAULT_TYPENAME;
    public static final int ANY_LENGTH = -1;
    public static final SimpleFeatureType EMPTY;
    protected static FilterFactory FF;

    public static Filter createLengthRestriction(int length) {
        if (length < 0) {
            return null;
        }
        LengthFunction lengthFunction = (LengthFunction)FF.function("LengthFunction", new Expression[]{FF.property(".")});
        if (lengthFunction == null) {
            return null;
        }
        PropertyIsLessThanOrEqualTo cf = null;
        try {
            cf = FF.lessOrEqual((Expression)lengthFunction, (Expression)FF.literal(length));
        }
        catch (IllegalFilterException illegalFilterException) {
            // empty catch block
        }
        return cf == null ? Filter.EXCLUDE : cf;
    }

    public static int getFieldLength(PropertyDescriptor descriptor) {
        Integer length = null;
        for (PropertyType type = descriptor.getType(); type != null; type = type.getSuper()) {
            for (Filter f : type.getRestrictions()) {
                Integer filterLength = null;
                try {
                    BinaryComparisonOperator cf;
                    if (f == null) continue;
                    if (f instanceof PropertyIsLessThan) {
                        cf = (BinaryComparisonOperator)f;
                        if (cf.getExpression1() instanceof LengthFunction) {
                            filterLength = (Integer)cf.getExpression2().evaluate(null, Integer.class) - 1;
                        }
                    } else if (f instanceof PropertyIsLessThanOrEqualTo) {
                        cf = (BinaryComparisonOperator)f;
                        if (cf.getExpression1() instanceof LengthFunction) {
                            filterLength = (Integer)cf.getExpression2().evaluate(null, Integer.class);
                        }
                    } else if (f instanceof PropertyIsGreaterThan) {
                        cf = (BinaryComparisonOperator)f;
                        if (cf.getExpression2() instanceof LengthFunction) {
                            filterLength = (Integer)cf.getExpression1().evaluate(null, Integer.class) - 1;
                        }
                    } else if (f instanceof PropertyIsGreaterThanOrEqualTo && (cf = (BinaryComparisonOperator)f).getExpression2() instanceof LengthFunction) {
                        filterLength = (Integer)cf.getExpression1().evaluate(null, Integer.class);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (filterLength == null || length != null && filterLength >= length) continue;
                length = filterLength;
            }
        }
        return length != null ? length : -1;
    }

    public static List<?> getFieldOptions(PropertyDescriptor descriptor) {
        List<Object> options = null;
        for (PropertyType type = descriptor.getType(); type != null; type = type.getSuper()) {
            for (Filter f : type.getRestrictions()) {
                List<Object> currentOptions = null;
                boolean foundOptionsPattern = true;
                if (f == null) continue;
                if (f instanceof PropertyIsEqualTo) {
                    Object value = FeatureTypes.getOption((PropertyIsEqualTo)f);
                    if (value == null) continue;
                    currentOptions = Collections.singletonList(value);
                } else if (f instanceof Or) {
                    Or or = (Or)f;
                    currentOptions = new ArrayList<Object>();
                    for (Filter child : or.getChildren()) {
                        if (child instanceof PropertyIsEqualTo) {
                            Object value = FeatureTypes.getOption((PropertyIsEqualTo)child);
                            if (value != null) {
                                currentOptions.add(value);
                                continue;
                            }
                            foundOptionsPattern = false;
                            continue;
                        }
                        foundOptionsPattern = false;
                    }
                }
                if (!foundOptionsPattern) continue;
                if (options != null) {
                    options.retainAll(currentOptions);
                    continue;
                }
                options = currentOptions;
            }
        }
        return options != null && !options.isEmpty() ? options : null;
    }

    private static Object getOption(PropertyIsEqualTo f) {
        PropertyIsEqualTo equal = f;
        Expression x1 = equal.getExpression1();
        Expression x2 = equal.getExpression2();
        if (x1 instanceof PropertyName && ".".equals(((PropertyName)x1).getPropertyName()) && x2 instanceof Literal) {
            return x2.evaluate(null);
        }
        return null;
    }

    public static Filter createFieldOptions(Collection<?> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        PropertyName thisProperty = FF.property(".");
        List filters = options.stream().map(o -> FF.equal((Expression)thisProperty, (Expression)FF.literal(o), false)).collect(Collectors.toList());
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return FF.or(filters);
    }

    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs) throws SchemaException {
        return FeatureTypes.transform(schema, crs, false);
    }

    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs, boolean forceOnlyMissing) throws SchemaException {
        return FeatureTypes.transform(schema, crs, forceOnlyMissing, false);
    }

    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs, boolean forceOnlyMissing, boolean onlyIfCompatible) throws SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(schema.getTypeName());
        tb.setNamespaceURI(schema.getName().getNamespaceURI());
        tb.setAbstract(schema.isAbstract());
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = schema.getDescriptor(i);
            if (attributeType instanceof GeometryDescriptor) {
                GeometryDescriptor geometryType = (GeometryDescriptor)attributeType;
                tb.descriptor((AttributeDescriptor)geometryType);
                if (forceOnlyMissing ? geometryType.getCoordinateReferenceSystem() == null : !onlyIfCompatible || CRS.isCompatible((CoordinateReferenceSystem)geometryType.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs, (boolean)false)) {
                    tb.crs(crs);
                }
                tb.add(geometryType.getLocalName(), geometryType.getType().getBinding());
                continue;
            }
            tb.add(attributeType);
        }
        if (schema.getGeometryDescriptor() != null) {
            tb.setDefaultGeometry(schema.getGeometryDescriptor().getLocalName());
        }
        tb.setSuperType((SimpleFeatureType)schema.getSuper());
        return tb.buildFeatureType();
    }

    public static SimpleFeature transform(SimpleFeature feature, SimpleFeatureType schema, MathTransform transform) throws MismatchedDimensionException, TransformException, IllegalAttributeException {
        feature = SimpleFeatureBuilder.copy(feature);
        GeometryDescriptor geomType = schema.getGeometryDescriptor();
        Geometry geom = (Geometry)feature.getAttribute(geomType.getLocalName());
        geom = JTS.transform(geom, transform);
        feature.setAttribute(geomType.getLocalName(), (Object)geom);
        return feature;
    }

    public static boolean shouldReproject(SimpleFeatureType schema, CoordinateReferenceSystem crs) {
        for (int i = 0; i < schema.getDescriptors().size(); ++i) {
            GeometryDescriptor descr;
            if (!(schema.getDescriptor(i) instanceof GeometryDescriptor) || CRS.equalsIgnoreMetadata((Object)crs, (Object)(descr = (GeometryDescriptor)schema.getDescriptor(i)).getCoordinateReferenceSystem()) || !CRS.isCompatible((CoordinateReferenceSystem)descr.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, null);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes, AttributeDescriptor defaultGeometry) throws FactoryRegistryException, SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(name);
        tb.setNamespaceURI(ns);
        tb.setAbstract(isAbstract);
        if (types != null) {
            tb.addAll(types);
        }
        if (defaultGeometry != null) {
            boolean add = true;
            for (AttributeDescriptor type : types) {
                if (type != defaultGeometry) continue;
                add = false;
                break;
            }
            if (add) {
                tb.add(defaultGeometry);
            }
            tb.setDefaultGeometry(defaultGeometry.getLocalName());
        }
        if (superTypes != null && superTypes.length > 0) {
            if (superTypes.length > 1) {
                throw new SchemaException("Can only specify a single super type");
            }
            tb.setSuperType(superTypes[0]);
        } else {
            tb.setSuperType(ABSTRACT_FEATURE_TYPE);
        }
        return tb.buildFeatureType();
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes, GeometryDescriptor defaultGeometry) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, (AttributeDescriptor)defaultGeometry);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, false);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, DEFAULT_NAMESPACE, false);
    }

    public static List<FeatureType> getAncestors(FeatureType featureType) {
        ArrayList<FeatureType> ancestors = new ArrayList<FeatureType>();
        while (featureType.getSuper() instanceof FeatureType) {
            FeatureType superType = (FeatureType)featureType.getSuper();
            ancestors.add(superType);
            featureType = superType;
        }
        return ancestors;
    }

    public static boolean matches(FeatureType featureType, Name name) {
        if (featureType.getName().equals((Object)name) || name.getNamespaceURI() == null && featureType.getName().getLocalPart().equalsIgnoreCase(name.getLocalPart())) {
            return true;
        }
        try {
            return FeatureTypes.isDecendedFrom(featureType, name.getNamespaceURI() != null ? new URI(name.getNamespaceURI()) : null, name.getLocalPart());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.FINE, "Unexpected failure while feature type", e);
            return false;
        }
    }

    public static boolean isDecendedFrom(FeatureType featureType, URI namespace, String typeName) {
        if (featureType == null) {
            return false;
        }
        List<FeatureType> ancestors = FeatureTypes.getAncestors(featureType);
        for (FeatureType superType : ancestors) {
            if (!(namespace == null ? Utilities.equals((Object)superType.getName().getLocalPart(), (Object)typeName) : Utilities.equals((Object)superType.getName().getNamespaceURI(), (Object)namespace.toString()) && Utilities.equals((Object)superType.getName().getLocalPart(), (Object)typeName))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecendedFrom(FeatureType featureType, FeatureType isParentType) {
        try {
            return FeatureTypes.isDecendedFrom(featureType, new URI(isParentType.getName().getNamespaceURI()), isParentType.getName().getLocalPart());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return FeatureTypes.equals(typeA, typeB, false);
    }

    public static boolean equalsExact(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return FeatureTypes.equals(typeA, typeB, true);
    }

    static boolean equals(SimpleFeatureType typeA, SimpleFeatureType typeB, boolean compareUserMaps) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        if (!typeA.equals(typeB)) {
            return false;
        }
        if (compareUserMaps && !FeatureTypes.equals(typeA.getUserData(), typeB.getUserData())) {
            return false;
        }
        return FeatureTypes.equalsId(typeA, typeB) && FeatureTypes.equals(typeA.getAttributeDescriptors(), typeB.getAttributeDescriptors(), compareUserMaps) && FeatureTypes.equalsAncestors(typeA, typeB);
    }

    static boolean equals(List<AttributeDescriptor> attributesA, List<AttributeDescriptor> attributesB, boolean compareUserMaps) {
        return FeatureTypes.equals(attributesA.toArray(new AttributeDescriptor[attributesA.size()]), attributesB.toArray(new AttributeDescriptor[attributesB.size()]), compareUserMaps);
    }

    public static boolean equals(List<AttributeDescriptor> attributesA, List<AttributeDescriptor> attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, false);
    }

    public static boolean equalsExact(List<AttributeDescriptor> attributesA, List<AttributeDescriptor> attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, true);
    }

    public static boolean equals(AttributeDescriptor[] attributesA, AttributeDescriptor[] attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, false);
    }

    public static boolean equalsExact(AttributeDescriptor[] attributesA, AttributeDescriptor[] attributesB) {
        return FeatureTypes.equals(attributesA, attributesB, true);
    }

    static boolean equals(AttributeDescriptor[] attributesA, AttributeDescriptor[] attributesB, boolean compareUserMaps) {
        if (attributesA.length != attributesB.length) {
            return false;
        }
        int length = attributesA.length;
        for (int i = 0; i < length; ++i) {
            if (FeatureTypes.equals(attributesA[i], attributesB[i], compareUserMaps)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAncestors(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return FeatureTypes.ancestors(typeA).equals(FeatureTypes.ancestors(typeB));
    }

    public static Set<FeatureType> ancestors(SimpleFeatureType featureType) {
        if (featureType == null || FeatureTypes.getAncestors((FeatureType)featureType).isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<FeatureType>(FeatureTypes.getAncestors((FeatureType)featureType));
    }

    public static boolean equals(AttributeDescriptor a, AttributeDescriptor b) {
        return FeatureTypes.equals(a, b, false);
    }

    public static boolean equalsExact(AttributeDescriptor a, AttributeDescriptor b) {
        return FeatureTypes.equals(a, b, true);
    }

    static boolean equals(AttributeDescriptor a, AttributeDescriptor b, boolean compareUserMaps) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return true;
        }
        if (!a.equals(b)) {
            return false;
        }
        if (compareUserMaps) {
            if (!FeatureTypes.equals(a.getUserData(), b.getUserData())) {
                return false;
            }
            if (!FeatureTypes.equals(a.getType().getUserData(), b.getType().getUserData())) {
                return false;
            }
        }
        return true;
    }

    static boolean equals(Map<?, ?> a, Map<?, ?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equalsId(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        String typeNameB;
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        String typeNameA = typeA.getTypeName();
        if (!Objects.equals(typeNameA, typeNameB = typeB.getTypeName())) {
            return false;
        }
        String namespaceA = typeA.getName().getNamespaceURI();
        String namespaceB = typeB.getName().getNamespaceURI();
        return Objects.equals(namespaceA, namespaceB);
    }

    static {
        URI uri;
        LOGGER = Logging.getLogger(FeatureTypes.class);
        try {
            uri = new URI("http://www.opengis.net/gml");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected URI syntax exception", e);
        }
        DEFAULT_NAMESPACE = uri;
        SimpleFeatureType featureType = null;
        try {
            featureType = FeatureTypes.newFeatureType(null, "Feature", new URI("http://www.opengis.net/gml"), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABSTRACT_FEATURE_TYPE = featureType;
        DEFAULT_TYPENAME = new NameImpl("AbstractFeatureCollectionType", DEFAULT_NAMESPACE.toString());
        EMPTY = new SimpleFeatureTypeImpl((Name)new NameImpl("Empty"), Collections.emptyList(), null, false, Collections.emptyList(), null, null);
        FF = CommonFactoryFinder.getFilterFactory(null);
    }
}

