/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryEntry;
import org.geotools.data.memory.MemoryFeatureStore;
import org.geotools.data.memory.MemoryState;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

@SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
public class MemoryDataStore
extends ContentDataStore {
    public MemoryDataStore() {
    }

    @Override
    protected MemoryState createContentState(ContentEntry entry) {
        return new MemoryState((MemoryEntry)entry);
    }

    public MemoryDataStore(SimpleFeatureType featureType) {
        try {
            this.entry(featureType);
        }
        catch (IOException e) {
            this.LOGGER.log(Level.FINER, e.getMessage(), e);
        }
    }

    public MemoryDataStore(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this.addFeatures(collection);
    }

    public MemoryDataStore(SimpleFeatureCollection collection) {
        this.addFeatures(collection);
    }

    public MemoryDataStore(SimpleFeature ... array) {
        this.addFeatures(array);
    }

    public MemoryDataStore(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.addFeatures(reader);
    }

    public MemoryDataStore(SimpleFeatureIterator reader) throws IOException {
        this.addFeatures(reader);
    }

    public void addFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        try {
            SimpleFeature feature = reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            this.addFeatureInternal(feature);
            while (reader.hasNext()) {
                feature = reader.next();
                this.addFeatureInternal(feature);
            }
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Problem using reader", e);
        }
        finally {
            reader.close();
        }
    }

    public void addFeatures(SimpleFeatureIterator reader) throws IOException {
        try {
            SimpleFeature feature = (SimpleFeature)reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            this.addFeatureInternal(feature);
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                this.addFeatureInternal(feature);
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Provided Collection is empty");
        }
        Map map = this.entries;
        synchronized (map) {
            for (Object item : collection) {
                this.addFeatureInternal((SimpleFeature)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Provided FeatureCollection is empty");
        }
        Map map = this.entries;
        synchronized (map) {
            try (FeatureIterator<SimpleFeature> iterator = collection.features();){
                while (iterator.hasNext()) {
                    this.addFeatureInternal(iterator.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(SimpleFeature ... features) {
        if (features == null || features.length == 0) {
            throw new IllegalArgumentException("Provided features are empty");
        }
        Map map = this.entries;
        synchronized (map) {
            for (SimpleFeature feature : features) {
                this.addFeatureInternal(feature);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(SimpleFeature feature) {
        Map map = this.entries;
        synchronized (map) {
            this.addFeatureInternal(feature);
        }
    }

    private void addFeatureInternal(SimpleFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Provided Feature is empty");
        }
        SimpleFeatureType featureType = feature.getFeatureType();
        try {
            MemoryEntry entry = this.entry(featureType);
            entry.addFeature(feature);
        }
        catch (IOException e) {
            this.LOGGER.log(Level.FINER, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryEntry entry(String typeName) throws IOException {
        Map map = this.entries;
        synchronized (map) {
            for (ContentEntry entry : this.entries.values()) {
                if (!entry.getName().getLocalPart().equals(typeName)) continue;
                return (MemoryEntry)entry;
            }
        }
        throw new IOException("Type name " + typeName + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryEntry entry(SimpleFeatureType schema) throws IOException {
        Name typeName = schema.getName();
        Map map = this.entries;
        synchronized (map) {
            if (this.entries.containsKey(typeName)) {
                MemoryEntry entry = (MemoryEntry)this.entries.get(typeName);
                if (FeatureTypes.equals(entry.schema, schema)) {
                    return entry;
                }
                throw new IOException("Entry " + String.valueOf(typeName) + " schema " + String.valueOf(entry.schema) + " incompatible with provided " + String.valueOf(schema));
            }
            MemoryEntry entry = new MemoryEntry(this, schema);
            this.entries.put(typeName, entry);
            return entry;
        }
    }

    @Override
    protected List<Name> createTypeNames() {
        ArrayList<Name> names = new ArrayList<Name>(this.entries.keySet());
        Collections.sort(names, (n1, n2) -> n1.toString().compareTo(n2.toString()));
        return names;
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) {
        return this.createFeatureSource(entry, Query.ALL);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry, Query query) {
        return new MemoryFeatureStore(entry, query);
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        Name typeName = featureType.getName();
        if (this.entries.containsKey(typeName)) {
            throw new IOException(String.valueOf(typeName) + " already exists");
        }
        MemoryEntry entry = new MemoryEntry(this, featureType);
        this.entries.put(typeName, entry);
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        for (Name name : this.entries.keySet()) {
            if (!name.getLocalPart().equals(typeName)) continue;
            this.removeSchema(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSchema(Name typeName) throws IOException {
        if (typeName != null) {
            Map map = this.entries;
            synchronized (map) {
                this.entries.remove(typeName);
            }
        }
    }
}

