/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DelegatingFeatureWriter;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Transaction;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class InProcessLockingManager
implements LockingManager {
    protected Map<String, Map<String, Lock>> lockTables = new HashMap<String, Map<String, Lock>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"})
    public synchronized void lockFeatureID(String typeName, String featureID, Transaction transaction, FeatureLock featureLock) throws FeatureLockException {
        Lock lock = this.getLock(typeName, featureID);
        while (lock != null) {
            if (lock instanceof TransactionLock) {
                TransactionLock tlock = (TransactionLock)lock;
                if (transaction == tlock.transaction) {
                    throw new FeatureLockException("Transaction Lock is already held by this Transaction", featureID);
                }
                try {
                    TransactionLock transactionLock = tlock;
                    synchronized (transactionLock) {
                        tlock.wait();
                    }
                    lock = this.getLock(typeName, featureID);
                    continue;
                }
                catch (InterruptedException interupted) {
                    throw new FeatureLockException("Interupted while waiting for Transaction Lock", featureID, interupted);
                }
            }
            if (lock instanceof MemoryLock) {
                MemoryLock mlock = (MemoryLock)lock;
                throw new FeatureLockException("Feature Lock is held by Authorization " + mlock.authID, featureID);
            }
            throw new FeatureLockException("Lock is already held " + String.valueOf(lock), featureID);
        }
        lock = this.createLock(transaction, featureLock);
        this.locks(typeName).put(featureID, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock getLock(String typeName, String featureID) {
        Map<String, Lock> locks;
        Map<String, Lock> map = locks = this.locks(typeName);
        synchronized (map) {
            if (locks.containsKey(featureID)) {
                Lock lock = locks.get(featureID);
                if (lock.isExpired()) {
                    locks.remove(featureID);
                    return null;
                }
                return lock;
            }
            return null;
        }
    }

    protected synchronized Lock createLock(Transaction transaction, FeatureLock featureLock) throws FeatureLockException {
        if (featureLock == FeatureLock.TRANSACTION) {
            if (transaction == Transaction.AUTO_COMMIT) {
                throw new FeatureLockException("We cannot issue a Transaction lock against AUTO_COMMIT");
            }
            TransactionLock lock = (TransactionLock)transaction.getState(this);
            if (lock == null) {
                lock = new TransactionLock();
                transaction.putState(this, lock);
                return lock;
            }
            return lock;
        }
        return new MemoryLock(featureLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Lock> locks(String typeName) {
        Map<String, Map<String, Lock>> map = this.lockTables;
        synchronized (map) {
            if (this.lockTables.containsKey(typeName)) {
                return this.lockTables.get(typeName);
            }
            HashMap<String, Lock> locks = new HashMap<String, Lock>();
            this.lockTables.put(typeName, locks);
            return locks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Lock> allLocks() {
        Map<String, Map<String, Lock>> map = this.lockTables;
        synchronized (map) {
            HashSet<Lock> set = new HashSet<Lock>();
            Iterator<Map<String, Lock>> iterator = this.lockTables.values().iterator();
            while (iterator.hasNext()) {
                Map<String, Lock> stringLockMap;
                Map<String, Lock> fidLocks = stringLockMap = iterator.next();
                set.addAll(fidLocks.values());
            }
            return set;
        }
    }

    public void assertAccess(String typeName, String featureID, Transaction transaction) throws FeatureLockException {
        Lock lock = this.getLock(typeName, featureID);
        if (lock != null && !lock.isAuthorized(transaction)) {
            throw new FeatureLockException("Transaction does not have authorization for " + typeName + ":" + featureID);
        }
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> checkedWriter(final FeatureWriter<SimpleFeatureType, SimpleFeature> writer, final Transaction transaction) {
        SimpleFeatureType featureType = writer.getFeatureType();
        final String typeName = featureType.getTypeName();
        return new DelegatingFeatureWriter<SimpleFeatureType, SimpleFeature>(){
            SimpleFeature live = null;

            @Override
            public FeatureWriter<SimpleFeatureType, SimpleFeature> getDelegate() {
                return writer;
            }

            @Override
            public SimpleFeatureType getFeatureType() {
                return (SimpleFeatureType)writer.getFeatureType();
            }

            @Override
            public SimpleFeature next() throws IOException {
                this.live = (SimpleFeature)writer.next();
                return this.live;
            }

            @Override
            public void remove() throws IOException {
                if (this.live != null) {
                    InProcessLockingManager.this.assertAccess(typeName, this.live.getID(), transaction);
                }
                writer.remove();
                this.live = null;
            }

            @Override
            public void write() throws IOException {
                if (this.live != null) {
                    InProcessLockingManager.this.assertAccess(typeName, this.live.getID(), transaction);
                }
                writer.write();
                this.live = null;
            }

            @Override
            public boolean hasNext() throws IOException {
                this.live = null;
                return writer.hasNext();
            }

            @Override
            public void close() throws IOException {
                this.live = null;
                if (writer != null) {
                    writer.close();
                }
            }
        };
    }

    @Override
    public synchronized void unLockFeatureID(String typeName, String featureID, Transaction transaction, FeatureLock featureLock) throws IOException {
        this.assertAccess(typeName, featureID, transaction);
        this.locks(typeName).remove(featureID);
    }

    @Override
    public synchronized boolean refresh(String authID, Transaction transaction) throws IOException {
        if (authID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + authID + ")");
        }
        boolean refresh = false;
        Iterator<Lock> i = this.allLocks().iterator();
        while (i.hasNext()) {
            Lock lock = i.next();
            if (lock.isExpired()) {
                i.remove();
                continue;
            }
            if (!lock.isMatch(authID)) continue;
            if (lock.isAuthorized(transaction)) {
                lock.refresh();
                refresh = true;
                continue;
            }
            throw new IOException("Not authorized to refresh " + String.valueOf(lock));
        }
        return refresh;
    }

    @Override
    public boolean release(String authID, Transaction transaction) throws IOException {
        if (authID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + authID + ")");
        }
        boolean release = false;
        for (Map<String, Lock> fidMap : this.lockTables.values()) {
            HashSet<String> unLockedFids = new HashSet<String>();
            for (String fid : fidMap.keySet()) {
                Lock lock = fidMap.get(fid);
                if (lock.isExpired()) {
                    unLockedFids.add(fid);
                    continue;
                }
                if (!lock.isMatch(authID)) continue;
                if (lock.isAuthorized(transaction)) {
                    unLockedFids.add(fid);
                    release = true;
                    continue;
                }
                throw new IOException("Not authorized to release " + String.valueOf(lock));
            }
            for (String unLockedFid : unLockedFids) {
                fidMap.remove(unLockedFid);
            }
        }
        return release;
    }

    @Override
    public boolean exists(String authID) {
        if (authID == null) {
            return false;
        }
        Iterator<Lock> i = this.allLocks().iterator();
        while (i.hasNext()) {
            Lock lock = i.next();
            if (lock.isExpired()) {
                i.remove();
                continue;
            }
            if (!lock.isMatch(authID)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocked(String typeName, String featureID) {
        return this.getLock(typeName, featureID) != null;
    }

    class MemoryLock
    implements Lock {
        String authID;
        long duration;
        long expiry;

        MemoryLock(FeatureLock lock) {
            this(lock.getAuthorization(), lock.getDuration());
        }

        MemoryLock(String id, long length) {
            this.authID = id;
            this.duration = length;
            this.expiry = System.currentTimeMillis() + length;
        }

        @Override
        public boolean isMatch(String id) {
            return this.authID.equals(id);
        }

        @Override
        public void refresh() {
            this.expiry = System.currentTimeMillis() + this.duration;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isExpired() {
            if (this.duration == 0L) {
                return false;
            }
            long now = System.currentTimeMillis();
            return now >= this.expiry;
        }

        @Override
        public boolean isAuthorized(Transaction transaction) {
            return transaction != Transaction.AUTO_COMMIT && transaction.getAuthorizations().contains(this.authID);
        }

        public String toString() {
            if (this.duration == 0L) {
                return "MemoryLock(" + this.authID + "|PermaLock)";
            }
            long now = System.currentTimeMillis();
            long delta = this.expiry - now;
            long dur = this.duration;
            return "MemoryLock(" + this.authID + "|" + delta + "ms|" + dur + "ms)";
        }
    }

    class TransactionLock
    implements Lock,
    Transaction.State {
        Transaction transaction;

        TransactionLock() {
        }

        @Override
        public boolean isMatch(String authID) {
            return false;
        }

        @Override
        public boolean isExpired() {
            return this.transaction != null;
        }

        @Override
        public void release() {
            this.transaction = null;
            this.notifyAll();
        }

        @Override
        public void refresh() {
        }

        @Override
        public boolean isAuthorized(Transaction transaction) {
            return this.transaction == transaction;
        }

        @Override
        public void addAuthorization(String AuthID) throws IOException {
        }

        @Override
        public void commit() throws IOException {
            this.release();
        }

        @Override
        public void rollback() throws IOException {
            this.release();
        }

        @Override
        public void setTransaction(Transaction transaction) {
            if (transaction == null) {
                this.release();
            }
            this.transaction = transaction;
        }

        public String toString() {
            return "TranasctionLock(" + !this.isExpired() + ")";
        }
    }

    public static interface Lock {
        public boolean isExpired();

        public boolean isMatch(String var1);

        public boolean isAuthorized(Transaction var1);

        public void refresh();

        public void release();
    }
}

