/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Calendar;
import java.util.Date;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultTemporalCoordinate;
import org.geotools.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalCoordinateSystem;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultTemporalCoordinateSystemTest {
    private TemporalCoordinateSystem temporalCoordinateSystem1;
    private TemporalCoordinateSystem temporalCoordinateSystem2;
    private DefaultTemporalCoordinate temporalCoordinate1;
    private DefaultTemporalCoordinate temporalCoordinate2;

    @Before
    public void setUp() {
        NamedIdentifier name1 = new NamedIdentifier(Citations.CRS, "Coordinate1");
        NamedIdentifier name2 = new NamedIdentifier(Citations.CRS, "Coordinate2");
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 1, 1);
        this.temporalCoordinateSystem1 = new DefaultTemporalCoordinateSystem((ReferenceIdentifier)name1, null, cal.getTime(), (InternationalString)new SimpleInternationalString("day"));
        this.temporalCoordinate1 = new DefaultTemporalCoordinate((TemporalReferenceSystem)this.temporalCoordinateSystem1, null, (Number)50785.48);
        cal.set(1981, 6, 25);
        this.temporalCoordinateSystem2 = new DefaultTemporalCoordinateSystem((ReferenceIdentifier)name2, null, cal.getTime(), (InternationalString)new SimpleInternationalString("month"));
        this.temporalCoordinate2 = new DefaultTemporalCoordinate((TemporalReferenceSystem)this.temporalCoordinateSystem2, null, (Number)285);
    }

    @After
    public void tearDown() {
        this.temporalCoordinateSystem1 = null;
        this.temporalCoordinateSystem2 = null;
        this.temporalCoordinate1 = null;
        this.temporalCoordinate2 = null;
    }

    @Test
    public void testSetOrigin() {
        Date result = this.temporalCoordinateSystem1.getOrigin();
        ((DefaultTemporalCoordinateSystem)this.temporalCoordinateSystem1).setOrigin(new Date());
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem1.getOrigin(), (Object)result);
    }

    @Test
    public void testSetInterval() {
        InternationalString result = this.temporalCoordinateSystem1.getInterval();
        ((DefaultTemporalCoordinateSystem)this.temporalCoordinateSystem1).setInterval((InternationalString)new SimpleInternationalString("hour"));
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem1.getInterval(), (Object)result);
    }

    @Test
    public void testGetOrigin() {
        Date result = this.temporalCoordinateSystem1.getOrigin();
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem2.getOrigin(), (Object)result);
    }

    @Test
    public void testGetInterval() {
        InternationalString result = this.temporalCoordinateSystem1.getInterval();
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem2.getInterval(), (Object)result);
    }

    @Test
    public void testTransformCoord() {
        Date result = this.temporalCoordinateSystem1.transformCoord((TemporalCoordinate)this.temporalCoordinate1);
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem2.transformCoord((TemporalCoordinate)this.temporalCoordinate2), (Object)result);
    }

    @Test
    public void testTransformDateTime() {
        TemporalCoordinate result = this.temporalCoordinateSystem1.transformDateTime(new Date());
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem2.transformDateTime(new Date()), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.temporalCoordinateSystem1);
        Assert.assertEquals((Object)this.temporalCoordinateSystem1, (Object)this.temporalCoordinateSystem1);
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem1, (Object)this.temporalCoordinateSystem2);
    }

    @Test
    public void testHashCode() {
        int result = this.temporalCoordinateSystem1.hashCode();
        Assert.assertNotEquals((long)this.temporalCoordinateSystem2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.temporalCoordinateSystem1.toString();
        Assert.assertNotEquals((Object)this.temporalCoordinateSystem2.toString(), (Object)result);
    }
}

