/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultCalendarDate;
import org.geotools.temporal.object.DefaultClockTime;
import org.geotools.temporal.object.DefaultDateAndTime;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultJulianDate;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.temporal.reference.DefaultCalendar;
import org.geotools.temporal.reference.DefaultCalendarEra;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.Calendar;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.Clock;
import org.opengis.temporal.ClockTime;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.Instant;
import org.opengis.temporal.JulianDate;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;
import org.opengis.temporal.TemporalPosition;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultCalendarTest {
    private Calendar calendar1;
    private Calendar calendar2;

    @Before
    public void setUp() {
        NamedIdentifier name1 = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        NamedIdentifier name2 = new NamedIdentifier(Citations.CRS, "Julian calendar");
        this.calendar1 = new DefaultCalendar((ReferenceIdentifier)name1, null);
        this.calendar2 = new DefaultCalendar((ReferenceIdentifier)name2, null);
    }

    @After
    public void tearDown() {
        this.calendar1 = null;
        this.calendar2 = null;
    }

    @Test
    public void testDateTrans_CalendarDate_ClockTime() {
        int[] cal = new int[]{2012, 9, 10};
        DefaultCalendarDate calendarDate = new DefaultCalendarDate((TemporalReferenceSystem)this.calendar1, IndeterminateValue.NOW, (InternationalString)new SimpleInternationalString("new Era"), cal);
        Number[] clock = new Number[]{12, 10, 5.488};
        DefaultClockTime clockTime = new DefaultClockTime((TemporalReferenceSystem)this.calendar1, IndeterminateValue.NOW, clock);
        JulianDate result = this.calendar1.dateTrans((CalendarDate)calendarDate, (ClockTime)clockTime);
        Assert.assertEquals((Object)this.calendar2.dateTrans((CalendarDate)calendarDate, (ClockTime)clockTime), (Object)result);
    }

    @Test
    public void testDateTrans_DateAndTime() {
        int[] cal = new int[]{2012, 9, 10};
        Number[] clock = new Number[]{12, 10, 5.488};
        DefaultDateAndTime dateAndTime = new DefaultDateAndTime((TemporalReferenceSystem)this.calendar1, null, null, cal, clock);
        JulianDate result = ((DefaultCalendar)this.calendar1).dateTrans((DateAndTime)dateAndTime);
        Assert.assertEquals((Object)((DefaultCalendar)this.calendar1).dateTrans((DateAndTime)dateAndTime), (Object)result);
    }

    @Test
    public void testJulTrans() {
    }

    @Test
    public void testGetBasis() {
        Collection result = this.calendar1.getBasis();
        Assert.assertEquals((Object)this.calendar2.getBasis(), (Object)result);
    }

    @Test
    public void testGetClock() {
        Clock result = this.calendar1.getClock();
        Assert.assertEquals((Object)this.calendar2.getClock(), (Object)result);
    }

    @Test
    public void testSetBasis() throws ParseException {
        Collection result = this.calendar1.getBasis();
        int[] calendarDate = new int[]{1, 1, 1};
        DefaultCalendarEra calendarEra = new DefaultCalendarEra((InternationalString)new SimpleInternationalString("Babylonian calendar"), (InternationalString)new SimpleInternationalString("Ascension of Nebuchadnezzar II to the throne of Babylon"), (CalendarDate)new DefaultCalendarDate((TemporalReferenceSystem)this.calendar1, null, null, calendarDate), (JulianDate)new DefaultJulianDate((TemporalReferenceSystem)this.calendar1, null, (Number)1721423.25), (Period)new DefaultPeriod((Instant)new DefaultInstant((Position)new DefaultPosition((TemporalPosition)new DefaultJulianDate((TemporalReferenceSystem)this.calendar1, null, (Number)2087769))), (Instant)new DefaultInstant((Position)new DefaultPosition((TemporalPosition)new DefaultJulianDate((TemporalReferenceSystem)this.calendar1, null, (Number)2299160)))));
        ArrayList<DefaultCalendarEra> collection = new ArrayList<DefaultCalendarEra>();
        collection.add(calendarEra);
        ((DefaultCalendar)this.calendar1).setBasis(collection);
        Assert.assertNotEquals((Object)this.calendar1.getBasis(), (Object)result);
    }

    @Test
    public void testSetClock() {
        Clock result = this.calendar1.getClock();
        ((DefaultCalendar)this.calendar1).setClock(null);
        Assert.assertEquals((Object)this.calendar1.getClock(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.calendar1);
        Assert.assertEquals((Object)this.calendar1, (Object)this.calendar1);
        Assert.assertNotEquals((Object)this.calendar1, (Object)this.calendar2);
    }

    @Test
    public void testHashCode() {
        int result = this.calendar1.hashCode();
        Assert.assertNotEquals((long)this.calendar2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.calendar1.toString();
        Assert.assertNotEquals((Object)this.calendar2.toString(), (Object)result);
    }
}

