/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Calendar;
import java.util.Date;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultOrdinalPosition;
import org.geotools.temporal.reference.DefaultOrdinalEra;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.OrdinalEra;
import org.opengis.temporal.OrdinalPosition;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultOrdinalPositionTest {
    private OrdinalPosition ordinalPosition1;
    private OrdinalPosition ordinalPosition2;
    private Calendar cal = Calendar.getInstance();

    @Before
    public void setUp() {
        NamedIdentifier name = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        DefaultTemporalReferenceSystem frame = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name, null);
        this.cal.set(500, 0, 1);
        Date beginning1 = this.cal.getTime();
        this.cal.set(1000, 0, 1);
        Date end1 = this.cal.getTime();
        DefaultOrdinalEra ordinalEra1 = new DefaultOrdinalEra((InternationalString)new SimpleInternationalString("Mesozoic"), beginning1, end1);
        this.cal.set(1000, 1, 1);
        Date beginning2 = this.cal.getTime();
        this.cal.set(2000, 0, 1);
        Date end2 = this.cal.getTime();
        DefaultOrdinalEra ordinalEra2 = new DefaultOrdinalEra((InternationalString)new SimpleInternationalString("Cenozoic"), beginning2, end2);
        this.ordinalPosition1 = new DefaultOrdinalPosition((TemporalReferenceSystem)frame, IndeterminateValue.UNKNOWN, (OrdinalEra)ordinalEra1);
        this.ordinalPosition2 = new DefaultOrdinalPosition((TemporalReferenceSystem)frame, IndeterminateValue.AFTER, (OrdinalEra)ordinalEra2);
    }

    @After
    public void tearDown() {
        this.ordinalPosition1 = null;
        this.ordinalPosition2 = null;
    }

    @Test
    public void testGetOrdinalPosition() {
        OrdinalEra result = this.ordinalPosition1.getOrdinalPosition();
        Assert.assertNotEquals((Object)this.ordinalPosition2.getOrdinalPosition(), (Object)result);
    }

    @Test
    public void testSetOrdinalPosition() {
        OrdinalEra result = this.ordinalPosition1.getOrdinalPosition();
        this.cal.set(10, 0, 0);
        Date beginning = this.cal.getTime();
        this.cal.set(2012, 12, 23);
        Date end = this.cal.getTime();
        DefaultOrdinalEra ordinalEra = new DefaultOrdinalEra((InternationalString)new SimpleInternationalString("Era"), beginning, end);
        ((DefaultOrdinalPosition)this.ordinalPosition1).setOrdinalPosition((OrdinalEra)ordinalEra);
        Assert.assertNotEquals((Object)this.ordinalPosition1.getOrdinalPosition(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.ordinalPosition1);
        Assert.assertEquals((Object)this.ordinalPosition1, (Object)this.ordinalPosition1);
        Assert.assertNotEquals((Object)this.ordinalPosition1, (Object)this.ordinalPosition2);
    }

    @Test
    public void testHashCode() {
        int result = this.ordinalPosition1.hashCode();
        Assert.assertNotEquals((long)this.ordinalPosition2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.ordinalPosition1.toString();
        Assert.assertNotEquals((Object)this.ordinalPosition2.toString(), (Object)result);
    }
}

