/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeosProjectionHandlerFactoryTest {
    @Test
    public void testValidAreaFarAway() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode((String)"AUTO:97004,9001,0,1000000000");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(Polygon.class));
        Polygon validPolygon = (Polygon)validArea;
        Envelope envelope = validPolygon.getEnvelopeInternal();
        Assert.assertEquals((double)-90.0, (double)envelope.getMinX(), (double)0.5);
        Assert.assertEquals((double)90.0, (double)envelope.getMaxX(), (double)0.5);
        Assert.assertEquals((double)-90.0, (double)envelope.getMinY(), (double)0.5);
        Assert.assertEquals((double)90.0, (double)envelope.getMaxY(), (double)0.5);
    }

    @Test
    public void testValidAreaEarth() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode((String)"AUTO:97004,9001,0,5000");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(Polygon.class));
        Polygon validPolygon = (Polygon)validArea;
        Envelope envelope = validPolygon.getEnvelopeInternal();
        Assert.assertEquals((double)-2.3, (double)envelope.getMinX(), (double)0.1);
        Assert.assertEquals((double)2.3, (double)envelope.getMaxX(), (double)0.1);
        Assert.assertEquals((double)-2.3, (double)envelope.getMinY(), (double)0.1);
        Assert.assertEquals((double)2.3, (double)envelope.getMaxY(), (double)0.1);
    }

    @Test
    public void testValidAreaMiddle() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode((String)"AUTO:97004,9001,0,0");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(Polygon.class));
        Polygon validPolygon = (Polygon)validArea;
        Envelope envelope = validPolygon.getEnvelopeInternal();
        Assert.assertEquals((double)-81.3, (double)envelope.getMinX(), (double)0.5);
        Assert.assertEquals((double)81.3, (double)envelope.getMaxX(), (double)0.5);
        Assert.assertEquals((double)-81.3, (double)envelope.getMinY(), (double)0.5);
        Assert.assertEquals((double)81.3, (double)envelope.getMaxY(), (double)0.5);
    }

    @Test
    public void testValidAreaWest() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode((String)"AUTO:97004,9001,-135,0");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(MultiPolygon.class));
        Assert.assertEquals((long)2L, (long)validArea.getNumGeometries());
        List<Envelope> envelopes = this.getInternalEnvelopes(validArea);
        Envelope e1 = envelopes.get(0);
        Assert.assertEquals((double)-180.0, (double)e1.getMinX(), (double)0.1);
        Assert.assertEquals((double)-53.7, (double)e1.getMaxX(), (double)0.1);
        Assert.assertEquals((double)-81.3, (double)e1.getMinY(), (double)0.1);
        Assert.assertEquals((double)81.3, (double)e1.getMaxY(), (double)0.1);
        Envelope e2 = envelopes.get(1);
        Assert.assertEquals((double)143.7, (double)e2.getMinX(), (double)0.1);
        Assert.assertEquals((double)180.0, (double)e2.getMaxX(), (double)0.1);
        Assert.assertEquals((double)-77.6, (double)e2.getMinY(), (double)0.1);
        Assert.assertEquals((double)77.6, (double)e2.getMaxY(), (double)0.1);
    }

    List<Envelope> getInternalEnvelopes(Geometry g) {
        return IntStream.range(0, g.getNumGeometries()).mapToObj(arg_0 -> ((Geometry)g).getGeometryN(arg_0)).map(Geometry::getEnvelopeInternal).sorted().collect(Collectors.toList());
    }

    @Test
    public void testValidAreaEast() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode((String)"AUTO:97004,9001,135,0");
        ReferencedEnvelope re = new ReferencedEnvelope(-6000000.0, 6000000.0, -6000000.0, 6000000.0, geos);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)false);
        Geometry validArea = handler.getValidArea();
        MatcherAssert.assertThat((Object)validArea, (Matcher)Matchers.instanceOf(MultiPolygon.class));
        Assert.assertEquals((long)2L, (long)validArea.getNumGeometries());
        List<Envelope> envelopes = this.getInternalEnvelopes(validArea);
        Envelope e1 = envelopes.get(0);
        Assert.assertEquals((double)-180.0, (double)e1.getMinX(), (double)0.1);
        Assert.assertEquals((double)-143.7, (double)e1.getMaxX(), (double)0.1);
        Assert.assertEquals((double)-77.6, (double)e1.getMinY(), (double)0.1);
        Assert.assertEquals((double)77.6, (double)e1.getMaxY(), (double)0.1);
        Envelope e2 = envelopes.get(1);
        Assert.assertEquals((double)53.7, (double)e2.getMinX(), (double)0.1);
        Assert.assertEquals((double)180.0, (double)e2.getMaxX(), (double)0.1);
        Assert.assertEquals((double)-81.3, (double)e2.getMinY(), (double)0.1);
        Assert.assertEquals((double)81.3, (double)e2.getMaxY(), (double)0.1);
    }
}

