/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.JTSTestBase;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.referencing.wkt.Parser;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class JTSTest
extends JTSTestBase {
    private static final double EPS = 1.0E-6;
    static final String UTM_ZONE_10N = "PROJCS[\"NAD_1983_UTM_Zone_10N\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n      TOWGS84[0,0,0,0,0,0,0],\n      SPHEROID[\"GRS_1980\",6378137,298.257222101]],\n    PRIMEM[\"Greenwich\",0],\n    UNIT[\"Degree\",0.017453292519943295]],\n  PROJECTION[\"Transverse_Mercator\"],\n    PARAMETER[\"False_Easting\",500000],\n    PARAMETER[\"False_Northing\",0],\n    PARAMETER[\"Central_Meridian\",-123],\n    PARAMETER[\"Scale_Factor\",0.9996],\n    PARAMETER[\"Latitude_Of_Origin\",0],\n  UNIT[\"Meter\",1]]";
    static final String NAD83_BC = "PROJCS[\"NAD83 / BC Albers\",\n  GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",\n    SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],\n    TOWGS84[0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],\n    PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],\n    UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],\n    AUTHORITY[\"EPSG\",\"4269\"]],\n  PROJECTION[\"Albers_Conic_Equal_Area\"],\n  PARAMETER[\"standard_parallel_1\",50],\n  PARAMETER[\"standard_parallel_2\",58.5],\n  PARAMETER[\"latitude_of_center\",45],\n  PARAMETER[\"longitude_of_center\",-126],\n  PARAMETER[\"false_easting\",1000000],\n  PARAMETER[\"false_northing\",0],\n  UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],\n  AUTHORITY[\"EPSG\",\"3005\"]]";

    @Test
    public void testJTSFactory() {
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
        Assert.assertNotNull((Object)gf);
    }

    @Test
    public void testTransformCoordinate() throws FactoryException, TransformException {
        Coordinate coord = new Coordinate(10.0, 10.0);
        AffineTransform at = AffineTransform.getScaleInstance(0.5, 1.0);
        MathTransform2D t = (MathTransform2D)ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)new GeneralMatrix(at));
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t);
        Assert.assertEquals((Object)new Coordinate(5.0, 10.0), (Object)coord);
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t.inverse());
        Assert.assertEquals((Object)new Coordinate(10.0, 10.0), (Object)coord);
        CoordinateReferenceSystem crs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(UTM_ZONE_10N);
        t = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, crs).getMathTransform();
        coord = new Coordinate(-123.0, 55.0);
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t);
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t.inverse());
        Assert.assertEquals((double)-123.0, (double)coord.x, (double)1.0E-6);
        Assert.assertEquals((double)55.0, (double)coord.y, (double)1.0E-6);
    }

    @Test
    public void testTransformEnvelopeMathTransform() throws FactoryException, TransformException {
        Envelope envelope = new Envelope(0.0, 10.0, 0.0, 10.0);
        AffineTransform at = AffineTransform.getScaleInstance(0.5, 1.0);
        MathTransform2D t = (MathTransform2D)ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)new GeneralMatrix(at));
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t);
        Assert.assertEquals((Object)new Envelope(0.0, 5.0, 0.0, 10.0), (Object)envelope);
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t.inverse());
        Assert.assertEquals((Object)new Envelope(0.0, 10.0, 0.0, 10.0), (Object)envelope);
        envelope = JTS.transform((Envelope)envelope, null, (MathTransform)t, (int)10);
        Assert.assertEquals((Object)new Envelope(0.0, 5.0, 0.0, 10.0), (Object)envelope);
        envelope = JTS.transform((Envelope)envelope, null, (MathTransform)t.inverse(), (int)10);
        Assert.assertEquals((Object)new Envelope(0.0, 10.0, 0.0, 10.0), (Object)envelope);
        CoordinateReferenceSystem crs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(UTM_ZONE_10N);
        t = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, crs).getMathTransform();
        envelope = new Envelope(-123.0, -133.0, 55.0, 60.0);
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t);
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t.inverse());
        Assert.assertEquals((double)-133.0, (double)envelope.getMinX(), (double)1.5);
        Assert.assertEquals((double)-123.0, (double)envelope.getMaxX(), (double)1.0E-6);
        Assert.assertEquals((double)55.0, (double)envelope.getMinY(), (double)0.5);
        Assert.assertEquals((double)60.0, (double)envelope.getMaxY(), (double)0.5);
    }

    @Test
    public void testOrthodromicDistance() throws Exception {
        Parser parser = new Parser();
        DefaultProjectedCRS crs = (DefaultProjectedCRS)parser.parseObject(NAD83_BC);
        double d = JTS.orthodromicDistance((Coordinate)new Coordinate(1402848.193853467, 651571.1729878788), (Coordinate)new Coordinate(1389481.3104009738, 641990.9430108378), (CoordinateReferenceSystem)crs);
        double realValue = 16451.33114;
        Assert.assertEquals((double)realValue, (double)d, (double)0.1);
    }

    @Test
    public void testCheckCoordinateRange() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        JTS.checkCoordinatesRange((Geometry)JTS.toGeometry((Envelope)new Envelope(-10.0, 10.0, -10.0, 10.0)), (CoordinateReferenceSystem)crs);
        try {
            JTS.checkCoordinatesRange((Geometry)JTS.toGeometry((Envelope)new Envelope(-10.0, 10.0, -100.0, 10.0)), (CoordinateReferenceSystem)crs);
            Assert.fail((String)"Provided invalid coordinates, yet check did not throw an exception");
        }
        catch (PointOutsideEnvelopeException pointOutsideEnvelopeException) {
            // empty catch block
        }
        try {
            JTS.checkCoordinatesRange((Geometry)JTS.toGeometry((Envelope)new Envelope(-190.0, 10.0, -10.0, 10.0)), (CoordinateReferenceSystem)crs);
            Assert.fail((String)"Provided invalid coordinates, yet check did not throw an exception");
        }
        catch (PointOutsideEnvelopeException pointOutsideEnvelopeException) {
            // empty catch block
        }
    }

    @Test
    public void testToGeoemtry() {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        Polygon polygon = JTS.toGeometry((Envelope)new Envelope(-10.0, 10.0, -10.0, 10.0));
        Assert.assertEquals((long)5L, (long)polygon.getExteriorRing().getCoordinateSequence().size());
        polygon = JTS.toGeometry((BoundingBox)new ReferencedEnvelope(-10.0, 10.0, -10.0, 10.0, (CoordinateReferenceSystem)crs));
        Assert.assertEquals((long)5L, (long)polygon.getExteriorRing().getCoordinateSequence().size());
    }

    @Test
    public void toGeometry_Shape_Poly() {
        java.awt.Polygon shape = new java.awt.Polygon(XPOINTS, YPOINTS, NPOINTS);
        Geometry geom = JTS.toGeometry((Shape)shape);
        Assert.assertTrue((boolean)(geom instanceof LinearRing));
        Coordinate[] coords = geom.getCoordinates();
        Assert.assertEquals((long)(NPOINTS + 1), (long)coords.length);
        JTSTestBase.CoordList list = new JTSTestBase.CoordList(coords);
        Coordinate c = new Coordinate();
        for (int i = 0; i < NPOINTS; ++i) {
            c.x = XPOINTS[i];
            c.y = YPOINTS[i];
            Assert.assertTrue((boolean)list.contains(c));
        }
    }

    @Test
    public void toGeometry_Shape_Line() {
        GeneralPath path = new GeneralPath();
        path.moveTo(XPOINTS[0], YPOINTS[0]);
        for (int i = 1; i < NPOINTS; ++i) {
            path.lineTo(XPOINTS[i], YPOINTS[i]);
        }
        Geometry geom = JTS.toGeometry((Shape)path);
        Assert.assertTrue((boolean)(geom instanceof LineString));
        Coordinate[] coords = geom.getCoordinates();
        Assert.assertEquals((long)NPOINTS, (long)coords.length);
        JTSTestBase.CoordList list = new JTSTestBase.CoordList(coords);
        Coordinate c = new Coordinate();
        for (int i = 0; i < NPOINTS; ++i) {
            c.x = XPOINTS[i];
            c.y = YPOINTS[i];
            Assert.assertTrue((boolean)list.contains(c));
        }
    }

    @Test
    public void getEnvelope2D() {
        ReferencedEnvelope refEnv = new ReferencedEnvelope(-10.0, 10.0, -5.0, 5.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Envelope2D env2D = JTS.getEnvelope2D((Envelope)refEnv, (CoordinateReferenceSystem)refEnv.getCoordinateReferenceSystem());
        CRS.equalsIgnoreMetadata((Object)refEnv.getCoordinateReferenceSystem(), (Object)env2D.getCoordinateReferenceSystem());
        Assert.assertTrue((boolean)env2D.boundsEquals((org.opengis.geometry.Envelope)refEnv, 0, 1, 1.0E-6));
    }

    @Test
    public void toGeometry_Envelope() {
        Envelope refEnv = new Envelope(-10.0, 10.0, -5.0, 5.0);
        Polygon geom = JTS.toGeometry((Envelope)refEnv);
        Assert.assertTrue((boolean)(geom instanceof Polygon));
        Envelope geomEnv = geom.getEnvelopeInternal();
        Assert.assertEquals((double)-10.0, (double)geomEnv.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)10.0, (double)geomEnv.getMaxX(), (double)1.0E-6);
        Assert.assertEquals((double)-5.0, (double)geomEnv.getMinY(), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)geomEnv.getMaxY(), (double)1.0E-6);
    }

    @Test
    public void toGeometry_ReferencedEnvelope() {
        ReferencedEnvelope refEnv = new ReferencedEnvelope(-10.0, 10.0, -5.0, 5.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Polygon geom = JTS.toGeometry((ReferencedEnvelope)refEnv);
        Assert.assertTrue((boolean)(geom instanceof Polygon));
        Envelope geomEnv = geom.getEnvelopeInternal();
        Assert.assertEquals((double)-10.0, (double)geomEnv.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)10.0, (double)geomEnv.getMaxX(), (double)1.0E-6);
        Assert.assertEquals((double)-5.0, (double)geomEnv.getMinY(), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)geomEnv.getMaxY(), (double)1.0E-6);
    }

    @Test
    public void toEnvelope() {
        Coordinate[] coords = this.getPolyCoords();
        GeometryFactory gf = new GeometryFactory();
        Polygon geom = gf.createPolygon(gf.createLinearRing(coords), null);
        ReferencedEnvelope refEnv = JTS.toEnvelope((Geometry)geom);
        Assert.assertEquals((Object)geom.getEnvelopeInternal(), (Object)refEnv);
    }

    @Test
    public void toDirectPosition() {
        Coordinate c = new Coordinate(40.0, 40.0);
        DirectPosition wrapper = JTS.toDirectPosition((Coordinate)c, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GeneralDirectPosition expected = new GeneralDirectPosition((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        expected.setOrdinate(0, 40.0);
        expected.setOrdinate(1, 40.0);
        Assert.assertEquals((Object)expected, (Object)wrapper);
    }

    @Test
    public void toGeometry_BoundingBox() {
        ReferencedEnvelope bbox = new ReferencedEnvelope(-10.0, 10.0, -5.0, 5.0, null);
        Polygon geom = JTS.toGeometry((BoundingBox)bbox);
        Assert.assertTrue((boolean)(geom instanceof Polygon));
        Envelope geomEnv = geom.getEnvelopeInternal();
        Assert.assertEquals((double)-10.0, (double)geomEnv.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)10.0, (double)geomEnv.getMaxX(), (double)1.0E-6);
        Assert.assertEquals((double)-5.0, (double)geomEnv.getMinY(), (double)1.0E-6);
        Assert.assertEquals((double)5.0, (double)geomEnv.getMaxY(), (double)1.0E-6);
    }

    @Test
    public void transformCoordinate2DCRSTo3D() throws Exception {
        DefaultGeographicCRS srcCRS = DefaultGeographicCRS.WGS84;
        DefaultGeocentricCRS targetCRS = DefaultGeocentricCRS.CARTESIAN;
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)srcCRS, (CoordinateReferenceSystem)targetCRS);
        Coordinate srcCoord = new Coordinate(0.0, 0.0);
        Coordinate dest0 = JTS.transform((Coordinate)srcCoord, null, (MathTransform)transform);
        srcCoord.x = 180.0;
        Coordinate dest180 = JTS.transform((Coordinate)srcCoord, null, (MathTransform)transform);
        Assert.assertEquals((double)dest0.x, (double)(-dest180.x), (double)1.0E-6);
        Assert.assertEquals((double)dest0.y, (double)dest180.y, (double)1.0E-6);
        Assert.assertEquals((double)dest0.getZ(), (double)dest180.getZ(), (double)1.0E-6);
    }

    @Test
    public void testTransformToWGS84() throws Exception {
        String wkt = "GEOGCS[\"GDA94\", DATUM[\"Geocentric Datum of Australia 1994\",  SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]],  TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],  AUTHORITY[\"EPSG\",\"6283\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AXIS[\"Ellipsoidal height\", UP],  AUTHORITY[\"EPSG\",\"4939\"]]";
        CoordinateReferenceSystem gda94 = CRS.parseWKT((String)wkt);
        ReferencedEnvelope3D bounds = new ReferencedEnvelope3D(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628, 0.0, 0.0, gda94);
        ReferencedEnvelope worldBounds = JTS.toGeographic((ReferencedEnvelope)bounds);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)worldBounds.getCoordinateReferenceSystem());
        Envelope envelope = new Envelope(130.875825803896, 130.898939990319, -16.4491956225999, -16.4338185791628);
        Envelope worldBounds2 = JTS.toGeographic((Envelope)envelope, (CoordinateReferenceSystem)gda94);
        if (worldBounds2 instanceof BoundingBox) {
            Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)((BoundingBox)worldBounds2).getCoordinateReferenceSystem());
        }
    }

    @Test
    public void testToGeographic() throws Exception {
        String wkt = "GEOGCS[\"GDA94\", DATUM[\"Geocentric Datum of Australia 1994\",  SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]],  TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],  AUTHORITY[\"EPSG\",\"6283\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AXIS[\"Ellipsoidal height\", UP],  AUTHORITY[\"EPSG\",\"4939\"]]";
        CoordinateReferenceSystem gda94 = CRS.parseWKT((String)wkt);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(130.875825803896, -16.4491956225999, 0.0));
        Geometry worldPoint = JTS.toGeographic((Geometry)point, (CoordinateReferenceSystem)gda94);
        Assert.assertTrue((boolean)(worldPoint instanceof Point));
        Assert.assertEquals((double)point.getX(), (double)worldPoint.getCoordinate().x, (double)1.0E-8);
    }

    @Test
    public void testToGeographicGeometry() throws Exception {
        String wkt = "GEOGCS[\"GDA94\", DATUM[\"Geocentric Datum of Australia 1994\",  SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]],  TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],  AUTHORITY[\"EPSG\",\"6283\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic latitude\", NORTH],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Ellipsoidal height\", UP],  AUTHORITY[\"EPSG\",\"4939\"]]";
        CoordinateReferenceSystem gda94 = CRS.parseWKT((String)wkt);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(-16.4463909341494, 130.882672103999, 97.009018073082));
        Point world = (Point)JTS.toGeographic((Geometry)point, (CoordinateReferenceSystem)gda94);
        Assert.assertEquals((double)point.getX(), (double)world.getY(), (double)5.0E-8);
        Assert.assertEquals((double)point.getY(), (double)world.getX(), (double)5.0E-8);
    }

    @Test
    public void testRemoveCollinear() throws Exception {
        int[] xPoints = new int[]{0, 1, 2, 3, 4, 5, 5, 2, 0};
        int[] yPoints = new int[]{0, 0, 0, 0, 0, 0, 2, 2, 2};
        int nPoints = xPoints.length;
        java.awt.Polygon shape = new java.awt.Polygon(xPoints, yPoints, nPoints);
        Geometry original = JTS.toGeometry((Shape)shape);
        Geometry reduced = JTS.removeCollinearVertices((Geometry)original);
        Assert.assertEquals((long)10L, (long)original.getNumPoints());
        Assert.assertEquals((long)5L, (long)reduced.getNumPoints());
        double DELTA = 1.0E-9;
        Coordinate[] coords = reduced.getCoordinates();
        Assert.assertEquals((double)0.0, (double)coords[0].x, (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)coords[0].y, (double)1.0E-9);
        Assert.assertEquals((double)5.0, (double)coords[1].x, (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)coords[1].y, (double)1.0E-9);
        Assert.assertEquals((double)5.0, (double)coords[2].x, (double)1.0E-9);
        Assert.assertEquals((double)2.0, (double)coords[2].y, (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)coords[3].x, (double)1.0E-9);
        Assert.assertEquals((double)2.0, (double)coords[3].y, (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)coords[4].x, (double)1.0E-9);
        Assert.assertEquals((double)0.0, (double)coords[4].y, (double)1.0E-9);
    }

    @Test
    public void testMakeValid() throws Exception {
        int[] xPoints = new int[]{0, 5, 5, 5, 10, 10, 5, 0};
        int[] yPoints = new int[]{0, 0, 5, 10, 10, 5, 5, 5};
        int nPoints = xPoints.length;
        java.awt.Polygon shape = new java.awt.Polygon(xPoints, yPoints, nPoints);
        LinearRing geom = (LinearRing)JTS.toGeometry((Shape)shape);
        GeometryFactory factory = new GeometryFactory();
        Polygon polygon = factory.createPolygon(geom);
        Assert.assertFalse((boolean)polygon.isValid());
        List validPols = JTS.makeValid((Polygon)polygon, (boolean)false);
        Assert.assertEquals((long)2L, (long)validPols.size());
        Polygon polygon1 = (Polygon)validPols.get(0);
        Polygon polygon2 = (Polygon)validPols.get(1);
        Assert.assertEquals((long)5L, (long)polygon1.getNumPoints());
        Assert.assertEquals((long)5L, (long)polygon2.getNumPoints());
    }
}

