/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import org.geotools.geometry.jts.Circle;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.MultiSurface;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class CurvedGeometryTest {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    @Test
    public void testCircularStringEmpty() {
        CircularString cs = new CircularString(new double[0], GEOMETRY_FACTORY, Double.MAX_VALUE);
        Assert.assertTrue((boolean)cs.isEmpty());
        Assert.assertEquals((Object)"CIRCULARSTRING EMPTY", (Object)cs.toCurvedText());
        Assert.assertEquals((long)0L, (long)cs.getNumArcs());
        Assert.assertEquals((long)0L, (long)cs.getNumPoints());
    }

    @Test
    public void testCircularStringSingleCurve() {
        double[] controlPoints = new Circle(10.0).samplePoints(1.5707963267948966, 0.7853981633974483, 0.0);
        CircularString cs = new CircularString(controlPoints, GEOMETRY_FACTORY, Double.MAX_VALUE);
        Envelope env = cs.getEnvelopeInternal();
        this.assertEnvelopeEquals(new Envelope(0.0, 10.0, 0.0, 10.0), env);
        Assert.assertEquals((long)(CircularArc.BASE_SEGMENTS_QUADRANT + 1), (long)cs.getNumPoints());
        CircularString cloned = (CircularString)cs.copy();
        Assert.assertEquals((Object)cs, (Object)cloned);
        Assert.assertEquals((double)(Math.PI * 5), (double)cs.getLength(), (double)0.1);
        Assert.assertEquals((double)(Math.PI * 5), (double)cs.linearize(1.0E-6).getLength(), (double)1.0E-6);
        Assert.assertTrue((boolean)cs.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(4.0, 8.0, 4.0, 8.0))));
        double[] controlPoints2 = new Circle(9.9).samplePoints(1.8849555921538759, 0.7853981633974483, 0.3141592653589793);
        CircularString cs2 = new CircularString(controlPoints2, GEOMETRY_FACTORY, Double.MAX_VALUE);
        Assert.assertFalse((boolean)cs.intersects((Geometry)cs2));
        String wkt = cs.toCurvedText();
        Assert.assertEquals((Object)"CIRCULARSTRING (6.123233995736766E-16 10.0, 7.0710678118654755 7.071067811865475, 10.0 0.0)", (Object)wkt);
        CircularString reversed = cs.reverse();
        Assert.assertEquals((double)reversed.controlPoints[0], (double)cs.controlPoints[4], (double)0.0);
        Assert.assertEquals((double)reversed.controlPoints[1], (double)cs.controlPoints[5], (double)0.0);
        Assert.assertEquals((double)reversed.controlPoints[2], (double)cs.controlPoints[2], (double)0.0);
        Assert.assertEquals((double)reversed.controlPoints[3], (double)cs.controlPoints[3], (double)0.0);
        Assert.assertEquals((double)reversed.controlPoints[4], (double)cs.controlPoints[0], (double)0.0);
        Assert.assertEquals((double)reversed.controlPoints[5], (double)cs.controlPoints[1], (double)0.0);
    }

    @Test
    public void testCircularStringWings() {
        double[] sp1 = new Circle(10.0).samplePoints(1.5707963267948966, 0.7853981633974483, 0.0);
        double[] sp2 = new Circle(10.0, 20.0, 0.0).samplePoints(Math.PI, 2.356194490192345, 1.5707963267948966);
        GrowableOrdinateArray data = new GrowableOrdinateArray();
        data.addAll(sp1);
        data.add(sp2[2], sp2[3]);
        data.add(sp2[4], sp2[5]);
        CircularString cs = new CircularString(data.getData(), GEOMETRY_FACTORY, Double.MAX_VALUE);
        Envelope env = cs.getEnvelopeInternal();
        this.assertEnvelopeEquals(new Envelope(0.0, 20.0, 0.0, 10.0), env);
        Assert.assertEquals((long)(CircularArc.BASE_SEGMENTS_QUADRANT * 2 + 1), (long)cs.getNumPoints());
        CircularString cloned = (CircularString)cs.copy();
        Assert.assertEquals((Object)cs, (Object)cloned);
        Assert.assertEquals((double)(Math.PI * 10), (double)cs.getLength(), (double)0.1);
        Assert.assertEquals((double)(Math.PI * 10), (double)cs.linearize(1.0E-6).getLength(), (double)1.0E-6);
        Assert.assertTrue((boolean)cs.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(4.0, 8.0, 4.0, 8.0))));
        double[] controlPoints2 = new Circle(9.9).samplePoints(1.8849555921538759, 0.7853981633974483, 0.3141592653589793);
        CircularString cs2 = new CircularString(controlPoints2, GEOMETRY_FACTORY, Double.MAX_VALUE);
        Assert.assertFalse((boolean)cs.intersects((Geometry)cs2));
        String wkt = cs.toCurvedText();
        Assert.assertEquals((Object)"CIRCULARSTRING (6.123233995736766E-16 10.0, 7.0710678118654755 7.071067811865475, 10.0 0.0, 12.928932188134524 7.0710678118654755, 20.0 10.0)", (Object)wkt);
        CircularString reversed = cs.reverse();
        double[] controlPoints = cs.controlPoints;
        double[] controlPointsReverse = reversed.controlPoints;
        Assert.assertEquals((double)controlPointsReverse[0], (double)controlPoints[8], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[1], (double)controlPoints[9], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[2], (double)controlPoints[6], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[3], (double)controlPoints[7], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[4], (double)controlPoints[4], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[5], (double)controlPoints[5], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[6], (double)controlPoints[2], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[7], (double)controlPoints[3], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[8], (double)controlPoints[0], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[9], (double)controlPoints[1], (double)0.0);
    }

    @Test
    public void testSimpleCircle() {
        Circle circle = new Circle(10.0);
        double[] circleControlPoints = circle.samplePoints(0.0, 1.5707963267948966, Math.PI, 4.71238898038469, 0.0);
        CircularRing cr = new CircularRing(circleControlPoints, GEOMETRY_FACTORY, Double.MAX_VALUE);
        Envelope env = cr.getEnvelopeInternal();
        this.assertEnvelopeEquals(new Envelope(-10.0, 10.0, -10.0, 10.0), env);
        Assert.assertEquals((long)(CircularArc.BASE_SEGMENTS_QUADRANT * 4 + 1), (long)cr.getNumPoints());
        CoordinateSequence coordinates = cr.linearize().getCoordinateSequence();
        circle.assertTolerance(coordinates, 0.1);
        CircularRing cloned = (CircularRing)cr.copy();
        Assert.assertEquals((Object)cr, (Object)cloned);
        Assert.assertEquals((double)62.83185307179586, (double)cr.getLength(), (double)0.1);
        Assert.assertTrue((boolean)cr.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(4.0, 8.0, 4.0, 8.0))));
        double[] controlPoints2 = new Circle(9.9).samplePoints(1.8849555921538759, 0.7853981633974483, 0.3141592653589793);
        CircularString cs2 = new CircularString(controlPoints2, GEOMETRY_FACTORY, Double.MAX_VALUE);
        Assert.assertFalse((boolean)cr.intersects((Geometry)cs2));
        String wkt = cr.toCurvedText();
        Assert.assertEquals((Object)"CIRCULARSTRING (10.0 0.0, 6.123233995736766E-16 10.0, -10.0 1.2246467991473533E-15, -1.8369701987210296E-15 -10.0, 10.0 0.0)", (Object)wkt);
        CircularRing reversed = cr.reverse();
        double[] controlPoints = cr.delegate.controlPoints;
        double[] controlPointsReverse = reversed.delegate.controlPoints;
        Assert.assertEquals((double)controlPointsReverse[0], (double)controlPoints[8], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[1], (double)controlPoints[9], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[2], (double)controlPoints[6], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[3], (double)controlPoints[7], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[4], (double)controlPoints[4], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[5], (double)controlPoints[5], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[6], (double)controlPoints[2], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[7], (double)controlPoints[3], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[8], (double)controlPoints[0], (double)0.0);
        Assert.assertEquals((double)controlPointsReverse[9], (double)controlPoints[1], (double)0.0);
    }

    @Test
    public void testCompoundCurve() {
        double[] halfCircle = new double[]{10.0, 10.0, 0.0, 20.0, -10.0, 10.0};
        CircularString cs = new CircularString(halfCircle, GEOMETRY_FACTORY, Double.MAX_VALUE);
        LineString ls = new LineString((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(-10.0, 10.0), new Coordinate(-10.0, 0.0), new Coordinate(10.0, 0.0), new Coordinate(10.0, 10.0)}), GEOMETRY_FACTORY);
        CompoundCurve curve = new CompoundCurve(Arrays.asList(cs, ls), GEOMETRY_FACTORY, Double.MAX_VALUE);
        Assert.assertFalse((String)"Check that this should not be a rectangle.", (boolean)curve.isRectangle());
        Envelope env = curve.getEnvelopeInternal();
        this.assertEnvelopeEquals(new Envelope(-10.0, 10.0, 0.0, 20.0), env);
        Assert.assertEquals((long)(CircularArc.BASE_SEGMENTS_QUADRANT * 2 + 4), (long)curve.getNumPoints());
        CompoundCurve cloned = (CompoundCurve)curve.copy();
        Assert.assertEquals((Object)curve, (Object)cloned);
        Assert.assertEquals((double)71.41592653589794, (double)curve.getLength(), (double)0.1);
        Assert.assertTrue((boolean)curve.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(0.0, 10.0, 12.0, 15.0))));
        Assert.assertTrue((boolean)curve.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(8.0, 12.0, -2.0, 2.0))));
        String wkt = curve.toCurvedText();
        Assert.assertEquals((Object)"COMPOUNDCURVE (CIRCULARSTRING (10.0 10.0, 0.0 20.0, -10.0 10.0), (-10.0 10.0, -10.0 0.0, 10.0 0.0, 10.0 10.0))", (Object)wkt);
    }

    @Test
    public void testCompoundRing() {
        double[] halfCircle = new double[]{10.0, 10.0, 0.0, 20.0, -10.0, 10.0};
        CircularString cs = new CircularString(halfCircle, GEOMETRY_FACTORY, Double.MAX_VALUE);
        LineString ls = new LineString((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(-10.0, 10.0), new Coordinate(-10.0, 0.0), new Coordinate(10.0, 0.0), new Coordinate(10.0, 10.0)}), GEOMETRY_FACTORY);
        CompoundRing ring = new CompoundRing(Arrays.asList(cs, ls), GEOMETRY_FACTORY, Double.MAX_VALUE);
        Envelope env = ring.getEnvelopeInternal();
        this.assertEnvelopeEquals(new Envelope(-10.0, 10.0, 0.0, 20.0), env);
        Assert.assertEquals((long)(CircularArc.BASE_SEGMENTS_QUADRANT * 2 + 4), (long)ring.getNumPoints());
        CompoundRing cloned = (CompoundRing)ring.copy();
        Assert.assertEquals((Object)ring, (Object)cloned);
        Assert.assertEquals((double)71.41592653589794, (double)ring.getLength(), (double)0.1);
        Assert.assertTrue((boolean)ring.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(0.0, 10.0, 12.0, 15.0))));
        Assert.assertTrue((boolean)ring.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(8.0, 12.0, -2.0, 2.0))));
        String wkt = ring.toCurvedText();
        Assert.assertEquals((Object)"COMPOUNDCURVE (CIRCULARSTRING (10.0 10.0, 0.0 20.0, -10.0 10.0), (-10.0 10.0, -10.0 0.0, 10.0 0.0, 10.0 10.0))", (Object)wkt);
    }

    @Test
    public void testCurvePolygons() {
        CurvePolygon curved = this.buildCurvePolygon();
        Envelope env = curved.getEnvelopeInternal();
        this.assertEnvelopeEquals(new Envelope(-10.0, 10.0, -10.0, 10.0), env);
        Assert.assertEquals((long)(CircularArc.BASE_SEGMENTS_QUADRANT * 4 + 1 + 5), (long)curved.getNumPoints());
        CurvePolygon cloned = (CurvePolygon)curved.copy();
        Assert.assertEquals((Object)curved, (Object)cloned);
        Assert.assertEquals((double)70.83185307179586, (double)curved.getLength(), (double)0.1);
        Assert.assertTrue((boolean)curved.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(0.0, 10.0, 5.0, 15.0))));
        Assert.assertTrue((boolean)curved.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(8.0, 12.0, -2.0, 2.0))));
        String wkt = curved.toCurvedText();
        Assert.assertEquals((Object)"CURVEPOLYGON (CIRCULARSTRING (-10.0 0.0, 0.0 10.0, 10.0 0.0, 0.0 -10.0, -10.0 0.0), (-1.0 -1.0, -1.0 1.0, 1.0 1.0, 1.0 -1.0, -1.0 -1.0))", (Object)wkt);
    }

    @Test
    public void testMultiSurface() {
        CurvePolygon p1 = this.buildCurvePolygon();
        LinearRing shell = new LinearRing((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(24.0, 20.0), new Coordinate(24.0, 24.0), new Coordinate(20.0, 24.0), new Coordinate(20.0, 20.0)}), GEOMETRY_FACTORY);
        LinearRing hole = new LinearRing((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(22.0, 22.0), new Coordinate(23.0, 22.0), new Coordinate(23.0, 23.0), new Coordinate(23.0, 22.0), new Coordinate(22.0, 22.0)}), GEOMETRY_FACTORY);
        Polygon p2 = new Polygon(shell, new LinearRing[]{hole}, GEOMETRY_FACTORY);
        MultiSurface ms = new MultiSurface(new Polygon[]{p1, p2}, GEOMETRY_FACTORY, Double.MAX_VALUE);
        Envelope env = ms.getEnvelopeInternal();
        this.assertEnvelopeEquals(new Envelope(-10.0, 24.0, -10.0, 24.0), env);
        Assert.assertEquals((long)(CircularArc.BASE_SEGMENTS_QUADRANT * 4 + 1 + 5 + 10), (long)ms.getNumPoints());
        MultiSurface cloned = (MultiSurface)ms.copy();
        Assert.assertEquals((Object)ms, (Object)cloned);
        Assert.assertEquals((double)90.83185307179586, (double)ms.getLength(), (double)0.1);
        Assert.assertTrue((boolean)ms.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(0.0, 10.0, 5.0, 15.0))));
        Assert.assertTrue((boolean)ms.intersects((Geometry)JTS.toGeometry((Envelope)new Envelope(8.0, 12.0, -2.0, 2.0))));
        String wkt = ms.toCurvedText();
        Assert.assertEquals((Object)"MULTISURFACE (CURVEPOLYGON (CIRCULARSTRING (-10.0 0.0, 0.0 10.0, 10.0 0.0, 0.0 -10.0, -10.0 0.0), (-1.0 -1.0, -1.0 1.0, 1.0 1.0, 1.0 -1.0, -1.0 -1.0)), ((20.0 20.0, 24.0 20.0, 24.0 24.0, 20.0 24.0, 20.0 20.0), (22.0 22.0, 23.0 22.0, 23.0 23.0, 23.0 22.0, 22.0 22.0)))", (Object)wkt);
    }

    @Test
    public void testNormalize() {
        double[] circleControlPoints = new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 0.0};
        CircularRing circle = new CircularRing(circleControlPoints, GEOMETRY_FACTORY, 1.0E-6);
        CircularRing normalized = circle.normalizeRing();
        Assert.assertEquals((long)2L, (long)normalized.getNumArcs());
        CircularArc a1 = normalized.getArcN(0);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 5.0, 5.0, 0.0, 10.0}, (double[])a1.getControlPoints(), (double)1.0E-6);
        CircularArc a2 = normalized.getArcN(1);
        Assert.assertArrayEquals((double[])new double[]{0.0, 10.0, -5.0, 5.0, 0.0, 0.0}, (double[])a2.getControlPoints(), (double)1.0E-6);
    }

    private CurvePolygon buildCurvePolygon() {
        double[] circleControlPoints = new double[]{-10.0, 0.0, 0.0, 10.0, 10.0, 0.0, 0.0, -10.0, -10.0, 0.0};
        CircularRing shell = new CircularRing(circleControlPoints, GEOMETRY_FACTORY, Double.MAX_VALUE);
        LinearRing hole = new LinearRing((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(-1.0, -1.0), new Coordinate(-1.0, 1.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, -1.0), new Coordinate(-1.0, -1.0)}), GEOMETRY_FACTORY);
        CurvePolygon curved = new CurvePolygon((LinearRing)shell, new LinearRing[]{hole}, GEOMETRY_FACTORY, Double.MAX_VALUE);
        return curved;
    }

    private void assertEnvelopeEquals(Envelope envelope, Envelope env) {
        Assert.assertEquals((double)envelope.getMinX(), (double)env.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)envelope.getMinY(), (double)env.getMinY(), (double)1.0E-6);
        Assert.assertEquals((double)envelope.getMinX(), (double)env.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)envelope.getMaxY(), (double)env.getMaxY(), (double)1.0E-6);
    }
}

