/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Random;
import org.geotools.geometry.jts.DefaultCoordinateSequenceTransformer;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class CoordinateSequenceTransformerTest {
    private final CoordinateSequenceFactory csFactory = CoordinateArraySequenceFactory.instance();

    @Test
    public void testTransform() throws FactoryException, TransformException {
        int[] size;
        CoordinateReferenceSystem crs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT("PROJCS[\"NAD_1983_UTM_Zone_10N\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n      TOWGS84[0,0,0,0,0,0,0],\n      SPHEROID[\"GRS_1980\",6378137,298.257222101]],\n    PRIMEM[\"Greenwich\",0],\n    UNIT[\"Degree\",0.017453292519943295]],\n  PROJECTION[\"Transverse_Mercator\"],\n    PARAMETER[\"False_Easting\",500000],\n    PARAMETER[\"False_Northing\",0],\n    PARAMETER[\"Central_Meridian\",-123],\n    PARAMETER[\"Scale_Factor\",0.9996],\n    PARAMETER[\"Latitude_Of_Origin\",0],\n  UNIT[\"Meter\",1]]");
        MathTransform2D t = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, crs).getMathTransform();
        Random random = new Random(546757437746704345L);
        for (int k : size = new int[]{12, 1000}) {
            Coordinate[] source = new Coordinate[k];
            for (int i = 0; i < source.length; ++i) {
                source[i] = new Coordinate(-121.0 - 4.0 * random.nextDouble(), -45.0 + 90.0 * random.nextDouble(), 500.0 * random.nextDouble());
            }
            CoordinateSequence sourceCS = this.csFactory.create(source);
            CoordinateSequence targetCS = this.transform(sourceCS, (MathTransform)t);
            Assert.assertNotSame((Object)sourceCS, (Object)targetCS);
            Assert.assertEquals((long)sourceCS.size(), (long)targetCS.size());
            int i = sourceCS.size();
            while (--i >= 0) {
                Assert.assertNotEquals((Object)sourceCS.getCoordinate(i), (Object)targetCS.getCoordinate(i));
            }
            DefaultCoordinateSequenceTransformer transformer = new DefaultCoordinateSequenceTransformer();
            CoordinateSequence testCS = transformer.transform(sourceCS, (MathTransform)t);
            Assert.assertNotSame((Object)sourceCS, (Object)testCS);
            Assert.assertNotSame((Object)targetCS, (Object)testCS);
            Assert.assertEquals((long)sourceCS.size(), (long)testCS.size());
            int i2 = targetCS.size();
            while (--i2 >= 0) {
                Assert.assertEquals((Object)targetCS.getCoordinate(i2), (Object)testCS.getCoordinate(i2));
            }
        }
    }

    @Test
    public void testTransformExtraMZ() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(1, 4);
        cs.setArray(new double[]{1000000.0, 4000000.0, 25.0, 48.0});
        CoordinateReferenceSystem sourceCrs = CRS.parseWKT((String)"PROJCS[\"NAD_1983_UTM_Zone_10N\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n      TOWGS84[0,0,0,0,0,0,0],\n      SPHEROID[\"GRS_1980\",6378137,298.257222101]],\n    PRIMEM[\"Greenwich\",0],\n    UNIT[\"Degree\",0.017453292519943295]],\n  PROJECTION[\"Transverse_Mercator\"],\n    PARAMETER[\"False_Easting\",500000],\n    PARAMETER[\"False_Northing\",0],\n    PARAMETER[\"Central_Meridian\",-123],\n    PARAMETER[\"Scale_Factor\",0.9996],\n    PARAMETER[\"Latitude_Of_Origin\",0],\n  UNIT[\"Meter\",1]]");
        DefaultGeographicCRS destCrs = DefaultGeographicCRS.WGS84;
        DefaultCoordinateSequenceTransformer cst = new DefaultCoordinateSequenceTransformer((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)destCrs, (boolean)true);
        LiteCoordinateSequence transformed = (LiteCoordinateSequence)cst.transform((CoordinateSequence)cs, tx);
        Assert.assertEquals((double)25.0, (double)transformed.getOrdinate(0, 2), (double)0.0);
        Assert.assertEquals((double)48.0, (double)transformed.getOrdinate(0, 3), (double)0.0);
    }

    @Test
    public void testLiteToStandard() throws Exception {
        LiteCoordinateSequence cs = new LiteCoordinateSequence(1, 2);
        cs.setArray(new double[]{1000000.0, 4000000.0});
        CoordinateReferenceSystem sourceCrs = CRS.parseWKT((String)"PROJCS[\"NAD_1983_UTM_Zone_10N\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n      TOWGS84[0,0,0,0,0,0,0],\n      SPHEROID[\"GRS_1980\",6378137,298.257222101]],\n    PRIMEM[\"Greenwich\",0],\n    UNIT[\"Degree\",0.017453292519943295]],\n  PROJECTION[\"Transverse_Mercator\"],\n    PARAMETER[\"False_Easting\",500000],\n    PARAMETER[\"False_Northing\",0],\n    PARAMETER[\"Central_Meridian\",-123],\n    PARAMETER[\"Scale_Factor\",0.9996],\n    PARAMETER[\"Latitude_Of_Origin\",0],\n  UNIT[\"Meter\",1]]");
        DefaultGeographicCRS destCrs = DefaultGeographicCRS.WGS84;
        DefaultCoordinateSequenceTransformer cst = new DefaultCoordinateSequenceTransformer();
        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)destCrs, (boolean)true);
        CoordinateSequence transformed = cst.transform((CoordinateSequence)cs, tx);
        CoordinateSequence reference = this.transform((CoordinateSequence)cs, tx);
        Assert.assertEquals((double)reference.getOrdinate(0, 0), (double)transformed.getOrdinate(0, 0), (double)0.0);
        Assert.assertEquals((double)reference.getOrdinate(0, 1), (double)transformed.getOrdinate(0, 1), (double)0.0);
    }

    private CoordinateSequence transform(CoordinateSequence cs, MathTransform transform) throws TransformException {
        int i;
        double[] coords = new double[100];
        Coordinate[] scs = cs.toCoordinateArray();
        Coordinate[] tcs = new Coordinate[scs.length];
        if (coords.length < scs.length * 2) {
            coords = new double[scs.length * 2];
        }
        for (i = 0; i < scs.length; ++i) {
            coords[i * 2] = scs[i].x;
            coords[i * 2 + 1] = scs[i].y;
        }
        transform.transform(coords, 0, coords, 0, scs.length);
        for (i = 0; i < tcs.length; ++i) {
            tcs[i] = new Coordinate(coords[i * 2], coords[i * 2 + 1]);
        }
        return this.csFactory.create(tcs);
    }
}

