/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.string;

import java.util.Arrays;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.string.URLEncodeFunction;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class URLEncodeFunctionTest {
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testArgCount() {
        URLEncodeFunction f = new URLEncodeFunction();
        Assert.assertEquals((long)-1L, (long)f.getFunctionName().getArgumentCount());
    }

    @Test
    public void testName() {
        URLEncodeFunction f = new URLEncodeFunction();
        Assert.assertEquals((Object)"strURLEncode", (Object)f.getName());
    }

    @Test
    public void testURLEncodeWithDefault() throws Exception {
        URLEncodeFunction f = new URLEncodeFunction();
        List<Expression> params = Arrays.asList(this.filterFactory.literal((Object)"Value With Spaces"));
        f.setParameters(params);
        Assert.assertEquals((Object)"Value%20With%20Spaces", (Object)f.evaluate(null));
    }

    @Test
    public void testURLEncode() throws Exception {
        URLEncodeFunction f = new URLEncodeFunction();
        List<Expression> params = Arrays.asList(this.filterFactory.literal((Object)"Value With Spaces"), this.filterFactory.literal(false));
        f.setParameters(params);
        Assert.assertEquals((Object)"Value%20With%20Spaces", (Object)f.evaluate(null));
    }

    @Test
    public void testFormURLEncode() throws Exception {
        URLEncodeFunction f = new URLEncodeFunction();
        List<Expression> params = Arrays.asList(this.filterFactory.literal((Object)"Value With Spaces"), this.filterFactory.literal(true));
        f.setParameters(params);
        Assert.assertEquals((Object)"Value+With+Spaces", (Object)f.evaluate(null));
    }
}

