/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.color;

import java.awt.Color;
import org.geotools.filter.function.color.HSLColor;
import org.junit.Assert;
import org.junit.Test;

public class HSLColorTest {
    @Test
    public void testBlack() {
        this.testComponents(Color.BLACK, 0.0f, 0.0f, 0.0f);
        this.testRoundTrip(Color.BLACK);
    }

    @Test
    public void testWhite() {
        this.testComponents(Color.WHITE, 0.0f, 0.0f, 1.0f);
        this.testRoundTrip(Color.WHITE);
    }

    @Test
    public void testRed() {
        this.testComponents(Color.RED, 0.0f, 1.0f, 0.5f);
        this.testRoundTrip(Color.RED);
    }

    @Test
    public void testGreen() {
        this.testComponents(Color.GREEN, 120.0f, 1.0f, 0.5f);
        this.testRoundTrip(Color.GREEN);
    }

    @Test
    public void testBlue() {
        this.testComponents(Color.BLUE, 240.0f, 1.0f, 0.5f);
        this.testRoundTrip(Color.BLUE);
    }

    @Test
    public void testYellow() {
        this.testComponents(Color.YELLOW, 60.0f, 1.0f, 0.5f);
        this.testRoundTrip(Color.YELLOW);
    }

    @Test
    public void testCyan() {
        this.testComponents(Color.CYAN, 180.0f, 1.0f, 0.5f);
        this.testRoundTrip(Color.CYAN);
    }

    @Test
    public void testLightGray() {
        this.testComponents(Color.LIGHT_GRAY, 0.0f, 0.0f, 0.75f);
        this.testRoundTrip(Color.LIGHT_GRAY);
    }

    @Test
    public void testDarkGray() {
        this.testComponents(Color.DARK_GRAY, 0.0f, 0.0f, 0.25f);
        this.testRoundTrip(Color.DARK_GRAY);
    }

    private void testComponents(Color color, float h, float s, float l) {
        HSLColor hsl = new HSLColor(color);
        Assert.assertEquals((double)h, (double)hsl.getHue(), (double)0.01f);
        Assert.assertEquals((double)s, (double)hsl.getSaturation(), (double)0.01f);
        Assert.assertEquals((double)l, (double)hsl.getLightness(), (double)0.01f);
    }

    private void testRoundTrip(Color color) {
        HSLColor hsl = new HSLColor(color);
        Color rgb = hsl.toRGB();
        Assert.assertEquals((Object)color, (Object)rgb);
    }
}

