/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Collections;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.PropertyExistsFunction;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class PropertyExistsFunctionTest {
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    PropertyExistsFunction f;

    @Before
    public void setUp() {
        this.f = new PropertyExistsFunction();
    }

    @After
    public void tearDown() {
        this.f = null;
    }

    @Test
    public void testName() {
        Assert.assertEquals((Object)"propertyexists", (Object)this.f.getName().toLowerCase());
    }

    @Test
    public void testFind() {
        Function function = ff.function("propertyexists", new Expression[]{ff.property("testPropName")});
        Assert.assertNotNull((Object)function);
    }

    @Test
    public void testEvaluateFeature() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"ns", (String)"name:string,geom:Geometry");
        SimpleFeatureBuilder build = new SimpleFeatureBuilder(type);
        build.add((Object)"testName");
        build.add(null);
        SimpleFeature feature = build.buildFeature(null);
        this.f.setParameters(this.list((Expression)ff.property("nonExistant")));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.f.evaluate(feature));
        this.f.setParameters(this.list((Expression)ff.property("name")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.f.evaluate(feature));
        this.f.setParameters(this.list((Expression)ff.property("geom")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.f.evaluate(feature));
    }

    private List<Expression> list(Expression expr) {
        return Collections.singletonList(expr);
    }

    @Test
    public void testEvaluatePojo() {
        CitationImpl pojo = new CitationImpl();
        this.f.setParameters(this.list((Expression)ff.property("edition")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.f.evaluate((Object)pojo));
        this.f.setParameters(this.list((Expression)ff.property("alternateTitles")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.f.evaluate((Object)pojo));
        this.f.setParameters(this.list((Expression)ff.property("AlternateTitles")));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.f.evaluate((Object)pojo));
        this.f.setParameters(this.list((Expression)ff.property("nonExistentProperty")));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.f.evaluate((Object)pojo));
    }

    @Test
    public void testEquals() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyExistsFunction actual = new PropertyExistsFunction();
        this.f.setParameters(this.list((Expression)ff.property("testPropName")));
        actual.setParameters(this.list((Expression)ff.property("testPropName")));
        Assert.assertEquals((Object)this.f, (Object)actual);
    }
}

