/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionFinder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class PointOnLineFunctionTest {
    public static final double EPS = 1.0E-6;
    public static final String NAME = "pointOnLine";
    public static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Test
    public void testLookup() {
        Function f = new FunctionFinder(null).findFunction(NAME);
        Assert.assertNotNull((Object)f);
    }

    @Test
    public void testNotLine() {
        FilterFactory FF = CommonFactoryFinder.getFilterFactory();
        Function pointOnLine = FF.function(NAME, new Expression[]{FF.literal((Object)"POINT(0 0)")});
        Assert.assertThrows(IllegalArgumentException.class, () -> pointOnLine.evaluate(null));
    }

    @Test
    public void testInvalidPercentageAbove() {
        Function pointOnLine = FF.function(NAME, new Expression[]{FF.literal((Object)"LINESTRING(0 0, 0 1, 1 1)"), FF.literal(1.5)});
        Assert.assertThrows(IllegalArgumentException.class, () -> pointOnLine.evaluate(null));
    }

    @Test
    public void testInvalidPercentageBelow() {
        Function pointOnLine = FF.function(NAME, new Expression[]{FF.literal((Object)"LINESTRING(0 0, 0 1, 1 1)"), FF.literal(-0.1)});
        Assert.assertThrows(IllegalArgumentException.class, () -> pointOnLine.evaluate(null));
    }

    @Test
    public void testInvalidMultiLineString() {
        Function pointOnLine = FF.function(NAME, new Expression[]{FF.literal((Object)"MULTILINESTRING((0 0, 1 1), (2 2, 3 3))")});
        Assert.assertThrows(IllegalArgumentException.class, () -> pointOnLine.evaluate(null));
    }

    @Test
    public void testMidPoint() {
        Function pointOnLine = FF.function(NAME, new Expression[]{FF.literal((Object)"LINESTRING(0 0, 0 1, 1 1)")});
        Point mid = (Point)pointOnLine.evaluate(null);
        Assert.assertNotNull((Object)mid);
        Assert.assertEquals((double)0.0, (double)mid.getX(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)mid.getY(), (double)1.0E-6);
    }

    @Test
    public void testValidMultiLineString() {
        Function pointOnLine = FF.function(NAME, new Expression[]{FF.literal((Object)"MULTILINESTRING((0 0, 1 1))")});
        Point mid = (Point)pointOnLine.evaluate(null);
        Assert.assertNotNull((Object)mid);
        Assert.assertEquals((double)0.5, (double)mid.getX(), (double)1.0E-6);
        Assert.assertEquals((double)0.5, (double)mid.getY(), (double)1.0E-6);
    }

    @Test
    public void testOtherPositions() {
        double[] percentages;
        for (double percentage : percentages = new double[]{0.0, 0.25, 0.5, 0.75, 1.0}) {
            Function pointOnLine = FF.function(NAME, new Expression[]{FF.literal((Object)"LINESTRING(0 0, 3 3)"), FF.literal(percentage)});
            Point point = (Point)pointOnLine.evaluate(null);
            Assert.assertNotNull((Object)point);
            double expectedX = 3.0 * percentage;
            double expectedY = 3.0 * percentage;
            Assert.assertEquals((double)expectedX, (double)point.getX(), (double)1.0E-6);
            Assert.assertEquals((double)expectedY, (double)point.getY(), (double)1.0E-6);
        }
    }
}

