/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.JenksNaturalBreaksFunction;
import org.geotools.filter.function.RangedClassifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class JenksFunctionTest
extends FunctionTestSupport {
    @Test
    public void testInstance() {
        Function equInt = this.ff.function("Jenks", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        Assert.assertNotNull((Object)equInt);
    }

    @Test
    public void testGetName() {
        Function qInt = this.ff.function("Jenks", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        Assert.assertEquals((Object)"Jenks", (Object)qInt.getName());
    }

    @Test
    public void testSetParameters() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName expr = this.ff.property("foo");
        JenksNaturalBreaksFunction func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        Assert.assertEquals((long)3L, (long)func.getClasses());
        classes = this.ff.literal(12);
        func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        Assert.assertEquals((long)12L, (long)func.getClasses());
        classes = this.ff.literal(5);
        func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        Assert.assertEquals((long)5L, (long)func.getClasses());
    }

    @Test
    public void testEvaluateRealData() throws Exception {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("jenks71");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.jenksCollection);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        Assert.assertEquals((long)5L, (long)ranged.getSize());
        Assert.assertEquals((Object)"15.57..41.2", (Object)ranged.getTitle(0));
        Assert.assertEquals((Object)"41.2..60.66", (Object)ranged.getTitle(1));
        Assert.assertEquals((Object)"60.66..77.29", (Object)ranged.getTitle(2));
        Assert.assertEquals((Object)"77.29..100.1", (Object)ranged.getTitle(3));
        Assert.assertEquals((Object)"100.1..155.3", (Object)ranged.getTitle(4));
    }

    @Test
    public void testEvaluateWithExpressions() throws Exception {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.featureCollection);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        Assert.assertEquals((long)2L, (long)ranged.getSize());
        Assert.assertEquals((Object)"4..29", (Object)ranged.getTitle(0));
        Assert.assertEquals((Object)"29..90", (Object)ranged.getTitle(1));
    }

    @Test
    public void testSingleBin() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i]}, (String)("classification.test1" + (i + 1)));
        }
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])myfeatures);
        SimpleFeatureCollection myFeatureCollection = source.getFeatures();
        Function function = this.ff.function("Jenks", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals(classifier.getClass(), RangedClassifier.class);
        RangedClassifier range = (RangedClassifier)classifier;
        Assert.assertEquals((long)5L, (long)range.getSize());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((double)((double)i + 1.0), (double)((Number)range.getMin(i)).doubleValue(), (double)0.0);
            if (i != 4) {
                Assert.assertEquals((String)"wrong value for max", (long)(i + 2), (long)((Number)range.getMax(i)).intValue());
                Assert.assertEquals((String)"bad title", (Object)(i + 1 + ".." + (i + 2)), (Object)range.getTitle(i));
                continue;
            }
            Assert.assertEquals((String)"wrong value for max", (long)(i + 1), (long)((Number)range.getMax(i)).intValue());
            Assert.assertEquals((String)"bad title", (Object)(i + 1 + ".." + (i + 1)), (Object)range.getTitle(i));
        }
    }

    @Test
    public void test2() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5, 6};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i]}, (String)("classification.t" + (i + 1)));
        }
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])myfeatures);
        SimpleFeatureCollection myFeatureCollection = source.getFeatures();
        Function function = this.ff.function("Jenks", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        MatcherAssert.assertThat((Object)classifier, (Matcher)CoreMatchers.instanceOf(RangedClassifier.class));
    }

    @Test
    public void testNullNaNHandling() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"classification.nullnan", (String)"id:0,foo:int,bar:double");
        Integer[] iVal = new Integer[]{0, 0, 0, 13, 13, 13, null, null, null};
        Double[] dVal = new Double[]{0.0, 50.01, null, 0.0, 50.01, null, 0.0, 50.01, null};
        SimpleFeature[] testFeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            testFeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{i + 1, iVal[i], dVal[i]}, (String)("nantest.t" + (i + 1)));
        }
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])testFeatures);
        SimpleFeatureCollection thisFC = source.getFeatures();
        Divide divide = this.ff.divide((Expression)this.ff.property("foo"), (Expression)this.ff.property("bar"));
        JenksNaturalBreaksFunction qf = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{divide, this.ff.literal(3)});
        RangedClassifier range = (RangedClassifier)qf.evaluate((Object)thisFC);
        Assert.assertEquals((long)3L, (long)range.getSize());
        Assert.assertEquals((Object)"0..0", (Object)range.getTitle(0));
        Assert.assertEquals((Object)"0..0", (Object)range.getTitle(1));
    }

    @Test
    public void testConstantValuesNumeric() {
        Function function = this.ff.function("jenks", new Expression[]{this.ff.property("v"), this.ff.literal(12)});
        RangedClassifier classifier = (RangedClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMin(0)), (double)0.0);
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMax(0)), (double)0.0);
    }

    @Test
    public void testEvaluateNumericalWithPercentages() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes, this.ff.literal(true)});
        Object value = func.evaluate((Object)this.featureCollection);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        double[] percentages = ranged.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)3L);
        Assert.assertEquals((double)percentages[0], (double)37.5, (double)0.0);
        Assert.assertEquals((double)percentages[1], (double)25.0, (double)0.0);
        Assert.assertEquals((double)percentages[2], (double)37.5, (double)0.0);
    }
}

