/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class DateDifferenceTest {
    @Test
    public void testDifference() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Date d1 = new Date();
        Date d2 = new Date(d1.getTime() + 10L);
        Function function = ff.function("dateDifference", new Expression[]{ff.literal((Object)d2), ff.literal((Object)d1)});
        Assert.assertEquals((double)10.0, (double)((Integer)function.evaluate(null, Integer.class)).intValue(), (double)0.0);
    }

    @Test
    public void testDifferenceWithUnit() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Date d1 = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTime(d1);
        calendar.add(10, 1);
        Date d2 = calendar.getTime();
        Function function = ff.function("dateDifference", new Expression[]{ff.literal((Object)d2), ff.literal((Object)d1), ff.literal((Object)"m")});
        Assert.assertEquals((double)60.0, (double)((Integer)function.evaluate(null, Integer.class)).intValue(), (double)0.0);
        calendar.add(5, 5);
        Date d3 = calendar.getTime();
        function = ff.function("dateDifference", new Expression[]{ff.literal((Object)d3), ff.literal((Object)d2), ff.literal((Object)"d")});
        Assert.assertEquals((double)5.0, (double)((Integer)function.evaluate(null, Integer.class)).intValue(), (double)0.0);
        calendar.add(13, 1);
        Date d4 = calendar.getTime();
        function = ff.function("dateDifference", new Expression[]{ff.literal((Object)d4), ff.literal((Object)d3)});
        Assert.assertEquals((double)1000.0, (double)((Integer)function.evaluate(null, Integer.class)).intValue(), (double)0.0);
    }

    @Test
    public void testDifferenceWithNow() throws InterruptedException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Function function = ff.function("now", new Expression[0]);
        long now = (Long)function.evaluate(null, Long.class);
        Date d1 = new Date();
        d1.setTime(now);
        Thread.sleep(1000L);
        function = ff.function("dateDifference", new Expression[]{ff.function("now", new Expression[0]), ff.literal((Object)d1), ff.literal((Object)"s")});
        Assert.assertTrue(((Integer)function.evaluate(null, Integer.class) >= 1 ? 1 : 0) != 0);
    }
}

