/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.logging.Logger;
import org.geotools.filter.function.EqualIntervalFunction;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.QuantileFunction;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.Expression;

public class ClassificationFunctionTest
extends FunctionTestSupport {
    protected static final Logger LOGGER = Logging.getLogger(ClassificationFunctionTest.class);

    @Test
    public void testDecimalPlaces() throws Exception {
        EqualIntervalFunction eif = (EqualIntervalFunction)this.ff.function("EqualInterval", new Expression[]{Expression.NIL});
        Assert.assertEquals((long)0L, (long)eif.decimalPlaces(100.0));
        Assert.assertEquals((long)3L, (long)eif.decimalPlaces(25.99312));
        Assert.assertEquals((long)1L, (long)eif.decimalPlaces(1.1));
        Assert.assertEquals((long)1L, (long)eif.decimalPlaces(0.9));
        Assert.assertEquals((long)1L, (long)eif.decimalPlaces(0.1));
        Assert.assertEquals((long)2L, (long)eif.decimalPlaces(0.01));
        Assert.assertEquals((long)3L, (long)eif.decimalPlaces(0.001));
    }

    @Test
    public void testRound() throws Exception {
        QuantileFunction classifier = (QuantileFunction)this.ff.function("Quantile", new Expression[]{Expression.NIL});
        Assert.assertEquals((double)100.0, (double)classifier.round(100.0, 0), (double)0.0);
        Assert.assertEquals((double)1.1, (double)classifier.round(1.12, 1), (double)0.0);
        Assert.assertEquals((double)0.35, (double)classifier.round(0.34523, 2), (double)0.0);
    }

    @Test
    public void testRoundOverflow() throws Exception {
        EqualIntervalFunction eif = (EqualIntervalFunction)this.ff.function("EqualInterval", new Expression[]{Expression.NIL});
        Assert.assertEquals((double)1.4779463384953E12, (double)eif.round(1.47794633849525E12, 1), (double)0.0);
    }
}

