/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class IsNotEqualToImpltest {
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testOperandsSameType() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal(2);
        PropertyIsNotEqualTo notEqual = this.filterFactory.notEqual((Expression)e1, (Expression)e2, true);
        Assert.assertTrue((boolean)notEqual.evaluate(null));
    }

    @Test
    public void testOperandsDifferentType() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal((Object)"2");
        PropertyIsNotEqualTo notEqual = this.filterFactory.notEqual((Expression)e1, (Expression)e2, true);
        Assert.assertTrue((boolean)notEqual.evaluate(null));
    }

    @Test
    public void testOperandsIntDouble() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal((Object)"1.0");
        PropertyIsNotEqualTo notEqual = this.filterFactory.notEqual((Expression)e1, (Expression)e2, true);
        Assert.assertFalse((boolean)notEqual.evaluate(null));
    }

    @Test
    public void testCaseSensitivity() {
        Literal e1 = this.filterFactory.literal((Object)"foo");
        Literal e2 = this.filterFactory.literal((Object)"FoO");
        PropertyIsNotEqualTo caseSensitive = this.filterFactory.notEqual((Expression)e1, (Expression)e2, true);
        Assert.assertTrue((boolean)caseSensitive.evaluate(null));
        PropertyIsNotEqualTo caseInsensitive = this.filterFactory.notEqual((Expression)e1, (Expression)e2, false);
        Assert.assertFalse((boolean)caseInsensitive.evaluate(null));
    }
}

