/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;

public class FilterCapabilitiesTest {
    private static final Logger LOGGER = Logging.getLogger(FilterCapabilitiesTest.class);
    private Filter gFilter;
    private Filter compFilter;
    private Filter logFilter;
    private FilterCapabilities capabilities;
    private FilterFactory2 fact = CommonFactoryFinder.getFilterFactory2();
    boolean setup = false;

    @Before
    public void setUp() {
        LOGGER.finer("Setting up FilterCapabilitiesTest");
        if (this.setup) {
            return;
        }
        this.setup = true;
        this.capabilities = new FilterCapabilities();
        try {
            this.gFilter = this.fact.within((Expression)this.fact.property("geom"), (Expression)this.fact.literal(null));
            this.compFilter = this.fact.less((Expression)this.fact.property("size"), (Expression)this.fact.literal(3));
        }
        catch (IllegalFilterException ife) {
            LOGGER.fine("Bad filter " + String.valueOf((Object)ife));
        }
        this.capabilities.addType(Or.class);
        this.capabilities.addType(And.class);
        this.capabilities.addType(Not.class);
        this.capabilities.addType(PropertyIsEqualTo.class);
        this.capabilities.addType(PropertyIsLessThan.class);
        this.capabilities.addType(PropertyIsBetween.class);
    }

    @Test
    public void testAdd() {
        this.capabilities.addType(PropertyIsGreaterThan.class);
        this.capabilities.addType(PropertyIsLessThan.class);
        this.capabilities.addType(PropertyIsNull.class);
        Assert.assertTrue((boolean)this.capabilities.supports(PropertyIsNull.class));
    }

    @Test
    public void testShortSupports() {
        Assert.assertTrue((boolean)this.capabilities.supports(And.class));
        Assert.assertFalse((boolean)this.capabilities.supports(PropertyIsLike.class));
    }

    @Test
    public void testFilterSupports() {
        Assert.assertTrue((boolean)this.capabilities.supports(this.compFilter));
        Assert.assertFalse((boolean)this.capabilities.supports(this.gFilter));
    }

    @Test
    public void testFullySupports() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        try {
            this.logFilter = ff.and(this.gFilter, this.compFilter);
            Assert.assertTrue((boolean)this.capabilities.fullySupports(this.compFilter));
            Assert.assertFalse((boolean)this.capabilities.fullySupports(this.gFilter));
            Assert.assertFalse((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.and(this.compFilter, (Filter)ff.between((Expression)ff.property("sample"), (Expression)ff.literal(1), (Expression)ff.literal(2)));
            Assert.assertTrue((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.or(this.logFilter, (Filter)ff.between((Expression)ff.property("sample"), (Expression)ff.literal(1), (Expression)ff.literal(2)));
            Assert.assertTrue((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.and(this.logFilter, this.gFilter);
            Assert.assertFalse((boolean)this.capabilities.fullySupports(this.logFilter));
        }
        catch (IllegalFilterException e) {
            LOGGER.fine("Bad filter " + String.valueOf((Object)e));
        }
    }
}

