/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Capabilities;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;

public class CapabilitiesTest {
    @Test
    public void testCapablities() {
        Capabilities capabilities = new Capabilities();
        capabilities.addType(Beyond.class);
        capabilities.addType(After.class);
        capabilities.addType(PropertyIsEqualTo.class);
        capabilities.addName("NullCheck");
        capabilities.addName("Mul");
        capabilities.addName("random");
        capabilities.addName("Length", 1);
        capabilities.addName("toDegrees", new String[]{"radians"});
        capabilities.addName("length", new String[]{"expression"});
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsBetween filter = ff.between((Expression)ff.literal(0), (Expression)ff.property("x"), (Expression)ff.literal(2));
        Assert.assertFalse((String)"supports", (boolean)capabilities.supports((Filter)filter));
        filter = ff.equals((Expression)ff.property("x"), (Expression)ff.literal(2));
        Assert.assertTrue((String)"supports", (boolean)capabilities.supports((Filter)filter));
        filter = ff.after((Expression)ff.property("x"), (Expression)ff.literal((Object)"1970-01-01 00:00:00"));
        Assert.assertTrue((String)"supports", (boolean)capabilities.supports((Filter)filter));
        Assert.assertTrue((String)"fullySupports", (boolean)capabilities.fullySupports((Filter)filter));
        Capabilities capabilities2 = new Capabilities();
        capabilities2.addAll(capabilities);
        capabilities2.addType(And.class);
        Assert.assertTrue((boolean)capabilities2.getContents().getScalarCapabilities().hasLogicalOperators());
        Assert.assertFalse((boolean)capabilities.getContents().getScalarCapabilities().hasLogicalOperators());
    }

    @Test
    public void testCapablities_PropertyIsLessThanOrEqualTo() {
        Capabilities capabilities = new Capabilities();
        capabilities.addAll(Capabilities.SIMPLE_COMPARISONS);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsLessThanOrEqualTo filter = ff.lessOrEqual((Expression)ff.property("x"), (Expression)ff.literal(2));
        Assert.assertTrue((String)"supports", (boolean)capabilities.supports((Filter)filter));
    }

    @Test
    public void testCapabilities_ComparisonsByName() {
        Capabilities capabilities = new Capabilities();
        capabilities.addType(And.class);
        capabilities.addName("GreaterThan");
        capabilities.addName("GreaterThanEqualTo");
        capabilities.addName("LessThan");
        capabilities.addName("LessThanEqualTo");
        capabilities.addName("EqualTo");
        capabilities.addName("NotEqualTo");
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        And filter = ff.and(Arrays.asList(ff.greater((Expression)ff.property("a"), (Expression)ff.literal(2)), ff.greaterOrEqual((Expression)ff.property("a"), (Expression)ff.literal(2)), ff.less((Expression)ff.property("a"), (Expression)ff.literal(2)), ff.lessOrEqual((Expression)ff.property("a"), (Expression)ff.literal(2)), ff.equals((Expression)ff.property("a"), (Expression)ff.literal(2)), ff.notEqual((Expression)ff.property("a"), (Expression)ff.literal(2))));
        Assert.assertTrue((String)"supports", (boolean)capabilities.fullySupports((Filter)filter));
    }

    @Test
    public void testCapabilities_BegunBy() throws ParseException {
        Capabilities capabilities = new Capabilities();
        capabilities.addType(BegunBy.class);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date1 = dateFormat.parse("1970-07-19T01:02:03.456Z");
        DefaultInstant temporalInstant = new DefaultInstant((Position)new DefaultPosition(date1));
        Date date2 = dateFormat.parse("1970-07-19T07:08:09.101Z");
        DefaultInstant temporalInstant2 = new DefaultInstant((Position)new DefaultPosition(date2));
        DefaultPeriod period = new DefaultPeriod((Instant)temporalInstant, (Instant)temporalInstant2);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        BegunBy filter = ff.begunBy((Expression)ff.literal((Object)period), (Expression)ff.property("dateAttr"));
        Assert.assertTrue((String)"supports", (boolean)capabilities.supports((Filter)filter));
        Assert.assertTrue((String)"fullySupports", (boolean)capabilities.fullySupports((Filter)filter));
    }
}

