/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.IllegalFilterException;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class AndFunctionTest {
    @Test
    public void testAndFunction1() throws IllegalFilterException {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function equalsTo = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string1"));
        Function andFunction = ff.function("and", (Expression)equalsTo, (Expression)equalsTo);
        Assert.assertTrue((boolean)((Boolean)andFunction.evaluate(new Object())));
    }

    @Test
    public void testAndFunction2() throws IllegalFilterException {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function equalsTo_left = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string1"));
        Function equalsTo_right = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string2"));
        Function andFunction = ff.function("and", (Expression)equalsTo_left, (Expression)equalsTo_right);
        Assert.assertFalse((boolean)((Boolean)andFunction.evaluate(new Object())));
    }

    @Test
    public void testAndFunction3() throws IllegalFilterException {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            FilterFactoryImpl ff = new FilterFactoryImpl();
            Function abs_left = ff.function("abs", (Expression)ff.literal(-12));
            Function equalsTo_right = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string2"));
            Function andFunction = ff.function("and", (Expression)abs_left, (Expression)equalsTo_right);
            andFunction.evaluate(new Object());
        });
    }

    @Test
    public void testAndFunction4() throws IllegalFilterException {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function geom = ff.function("geomFromWKT", (Expression)ff.literal((Object)"POLYGON ((150 330, 220 330, 220 230, 150 230, 150 330))"));
        Function geom_area = ff.function("area", (Expression)geom);
        Function equalsTo_left = ff.function("greaterThan", (Expression)geom_area, (Expression)ff.literal(0));
        Function equalsTo_right = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string1"));
        Function andFunction = ff.function("and", (Expression)equalsTo_left, (Expression)equalsTo_right);
        Assert.assertTrue((boolean)((Boolean)andFunction.evaluate(new Object())));
    }

    @Test
    public void testAndFunction5() throws IllegalFilterException {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function geom = ff.function("geomFromWKT", (Expression)ff.literal((Object)"POLYGON ((150 330, 220 330, 220 230, 150 230, 150 330))"));
        Function geom_area = ff.function("area", (Expression)geom);
        Function equalsTo_left = ff.function("greaterThan", (Expression)geom_area, (Expression)ff.literal(0));
        Function equalsTo_right = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string1"));
        Function andFunction = ff.function("and", (Expression)equalsTo_left, (Expression)equalsTo_right);
        Function if_then_elseFunction = ff.function("if_then_else", (Expression)andFunction, (Expression)ff.literal(10), (Expression)ff.literal(-1));
        Assert.assertEquals((Object)10, (Object)if_then_elseFunction.evaluate(new Object()));
    }
}

