/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.GroupByVisitorBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.util.ProgressListener;

public class GroupByVisitorTest {
    private static WKTReader wktParser = new WKTReader();
    private static SimpleFeatureType buildingType;
    private static FeatureCollection featureCollection;

    @BeforeClass
    public static void setup() throws Exception {
        buildingType = DataUtilities.createType((String)"buildings", (String)"id:Integer,building_id:String,building_type:String,energy_type:String,energy_consumption:Double,geo:Geometry");
        SimpleFeature[] buildingFeatures = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{1, "SCHOOL_A", "SCHOOL", "FLOWING_WATER", 50.0, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "SCHOOL_A", "SCHOOL", "NUCLEAR", 10.0, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{3, "SCHOOL_A", "SCHOOL", "WIND", 20.0, wktParser.read("POINT(-5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{4, "SCHOOL_B", "SCHOOL", "SOLAR", 30.0, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{5, "SCHOOL_B", "SCHOOL", "FUEL", 60.0, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{6, "SCHOOL_B", "SCHOOL", "NUCLEAR", 10.0, wktParser.read("POINT(5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{7, "FABRIC_A", "FABRIC", "FLOWING_WATER", 500.0, wktParser.read("POINT(-5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{8, "FABRIC_A", "FABRIC", "NUCLEAR", 150.0, wktParser.read("POINT(-5 5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{9, "FABRIC_B", "FABRIC", "WIND", 20.0, wktParser.read("POINT(5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{10, "FABRIC_B", "FABRIC", "SOLAR", 30.0, wktParser.read("POINT(5 -5)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{11, "HOUSE_A", "HOUSE", "FUEL", 6.0, wktParser.read("POINT(0 0)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{12, "HOUSE_B", "HOUSE", "NUCLEAR", 4.0, wktParser.read("POINT(0 0)")}, null)};
        featureCollection = DataUtilities.collection((SimpleFeature[])buildingFeatures);
    }

    @Test
    public void testGroupByWithAverageAndSingleAttribute() throws Exception {
        this.testVisitor("energy_consumption", "Average", "building_type", (Object[][])new Object[][]{{"SCHOOL", 30.0}, {"FABRIC", 175.0}, {"HOUSE", 5.0}});
    }

    @Test
    public void testGroupByWithAverageAndTwoAttributes() throws Exception {
        this.testVisitor("energy_consumption", "Average", "building_type", "energy_type", new Object[][]{{"FABRIC", "FLOWING_WATER", 500.0}, {"FABRIC", "NUCLEAR", 150.0}, {"FABRIC", "SOLAR", 30.0}, {"FABRIC", "WIND", 20.0}, {"HOUSE", "FUEL", 6.0}, {"HOUSE", "NUCLEAR", 4.0}, {"SCHOOL", "FLOWING_WATER", 50.0}, {"SCHOOL", "FUEL", 60.0}, {"SCHOOL", "NUCLEAR", 10.0}, {"SCHOOL", "SOLAR", 30.0}, {"SCHOOL", "WIND", 20.0}});
    }

    @Test
    public void testGroupByWithCountAndSingleAttribute() throws Exception {
        this.testVisitor("energy_consumption", "Count", "building_type", (Object[][])new Object[][]{{"SCHOOL", 6}, {"FABRIC", 4}, {"HOUSE", 2}});
    }

    @Test
    public void testGroupByWithCountAndTwoAttributes() throws Exception {
        this.testVisitor("energy_consumption", "Count", "building_type", "energy_type", new Object[][]{{"FABRIC", "FLOWING_WATER", 1}, {"FABRIC", "NUCLEAR", 1}, {"FABRIC", "SOLAR", 1}, {"FABRIC", "WIND", 1}, {"HOUSE", "FUEL", 1}, {"HOUSE", "NUCLEAR", 1}, {"SCHOOL", "FLOWING_WATER", 1}, {"SCHOOL", "FUEL", 1}, {"SCHOOL", "NUCLEAR", 2}, {"SCHOOL", "SOLAR", 1}, {"SCHOOL", "WIND", 1}});
    }

    @Test
    public void testGroupByWithMaxAndSingleAttribute() throws Exception {
        this.testVisitor("energy_consumption", "Max", "building_type", (Object[][])new Object[][]{{"SCHOOL", 60.0}, {"FABRIC", 500.0}, {"HOUSE", 6.0}});
    }

    @Test
    public void testGroupByWithMaxAndTwoAttributes() throws Exception {
        this.testVisitor("energy_consumption", "Max", "building_type", "energy_type", new Object[][]{{"FABRIC", "FLOWING_WATER", 500.0}, {"FABRIC", "NUCLEAR", 150.0}, {"FABRIC", "SOLAR", 30.0}, {"FABRIC", "WIND", 20.0}, {"HOUSE", "FUEL", 6.0}, {"HOUSE", "NUCLEAR", 4.0}, {"SCHOOL", "FLOWING_WATER", 50.0}, {"SCHOOL", "FUEL", 60.0}, {"SCHOOL", "NUCLEAR", 10.0}, {"SCHOOL", "SOLAR", 30.0}, {"SCHOOL", "WIND", 20.0}});
    }

    @Test
    public void testGroupByWithMedianAndSingleAttribute() throws Exception {
        this.testVisitor("energy_consumption", "Median", "building_type", (Object[][])new Object[][]{{"SCHOOL", 25.0}, {"FABRIC", 90.0}, {"HOUSE", 5.0}});
    }

    @Test
    public void testGroupByWithMedianAndTwoAttributes() throws Exception {
        this.testVisitor("energy_consumption", "Median", "building_type", "energy_type", new Object[][]{{"FABRIC", "FLOWING_WATER", 500.0}, {"FABRIC", "NUCLEAR", 150.0}, {"FABRIC", "SOLAR", 30.0}, {"FABRIC", "WIND", 20.0}, {"HOUSE", "FUEL", 6.0}, {"HOUSE", "NUCLEAR", 4.0}, {"SCHOOL", "FLOWING_WATER", 50.0}, {"SCHOOL", "FUEL", 60.0}, {"SCHOOL", "NUCLEAR", 10.0}, {"SCHOOL", "SOLAR", 30.0}, {"SCHOOL", "WIND", 20.0}});
    }

    @Test
    public void testGroupByWithMinAndSingleAttribute() throws Exception {
        this.testVisitor("energy_consumption", "Min", "building_type", (Object[][])new Object[][]{{"SCHOOL", 10.0}, {"FABRIC", 20.0}, {"HOUSE", 4.0}});
    }

    @Test
    public void testGroupByWithMinAndTwoAttributes() throws Exception {
        this.testVisitor("energy_consumption", "Min", "building_type", "energy_type", new Object[][]{{"FABRIC", "FLOWING_WATER", 500.0}, {"FABRIC", "NUCLEAR", 150.0}, {"FABRIC", "SOLAR", 30.0}, {"FABRIC", "WIND", 20.0}, {"HOUSE", "FUEL", 6.0}, {"HOUSE", "NUCLEAR", 4.0}, {"SCHOOL", "FLOWING_WATER", 50.0}, {"SCHOOL", "FUEL", 60.0}, {"SCHOOL", "NUCLEAR", 10.0}, {"SCHOOL", "SOLAR", 30.0}, {"SCHOOL", "WIND", 20.0}});
    }

    @Test
    public void testGroupByWithStdDevAndSingleAttribute() throws Exception {
        this.testVisitor("energy_consumption", "StdDev", "building_type", (Object[][])new Object[][]{{"SCHOOL", 19.149}, {"FABRIC", 194.487}, {"HOUSE", 1.0}});
    }

    @Test
    public void testGroupByWithStdDevAndTwoAttributes() throws Exception {
        this.testVisitor("energy_consumption", "StdDev", "building_type", "energy_type", new Object[][]{{"FABRIC", "FLOWING_WATER", 0.0}, {"FABRIC", "NUCLEAR", 0.0}, {"FABRIC", "SOLAR", 0.0}, {"FABRIC", "WIND", 0.0}, {"HOUSE", "FUEL", 0.0}, {"HOUSE", "NUCLEAR", 0.0}, {"SCHOOL", "FLOWING_WATER", 0.0}, {"SCHOOL", "FUEL", 0.0}, {"SCHOOL", "NUCLEAR", 0.0}, {"SCHOOL", "SOLAR", 0.0}, {"SCHOOL", "WIND", 0.0}});
    }

    @Test
    public void testGroupByWithSumDevAndSingleAttribute() throws Exception {
        this.testVisitor("energy_consumption", "Sum", "building_type", (Object[][])new Object[][]{{"SCHOOL", 180.0}, {"FABRIC", 700.0}, {"HOUSE", 10.0}});
    }

    @Test
    public void testGroupByWithSumDevAndTwoAttributes() throws Exception {
        this.testVisitor("energy_consumption", "Sum", "building_type", "energy_type", new Object[][]{{"FABRIC", "FLOWING_WATER", 500.0}, {"FABRIC", "NUCLEAR", 150.0}, {"FABRIC", "SOLAR", 30.0}, {"FABRIC", "WIND", 20.0}, {"HOUSE", "FUEL", 6.0}, {"HOUSE", "NUCLEAR", 4.0}, {"SCHOOL", "FLOWING_WATER", 50.0}, {"SCHOOL", "FUEL", 60.0}, {"SCHOOL", "NUCLEAR", 20.0}, {"SCHOOL", "SOLAR", 30.0}, {"SCHOOL", "WIND", 20.0}});
    }

    @Test
    public void testMergingGroupByResults() throws Exception {
        FeatureCollection featureCollectionA = featureCollection;
        SimpleFeatureCollection featureCollectionB = DataUtilities.collection((SimpleFeature[])new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{1, "SCHOOL_C", "SCHOOL", "NUCLEAR", 100.0, wktParser.read("POINT(-15 -15)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{1, "SCHOOL_C", "SCHOOL", "FUEL", 15.0, wktParser.read("POINT(-15 -15)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "FABRIC_C", "FABRIC", "NUCLEAR", 250.0, wktParser.read("POINT(-25 -25)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "FABRIC_C", "FABRIC", "WIND", 75.0, wktParser.read("POINT(-25 -25)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "HOUSE_C", "HOUSE", "WIND", 10.0, wktParser.read("POINT(-35 -35)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "HOUSE_C", "HOUSE", "DARK_MATTER", 850.0, wktParser.read("POINT(-35 -35)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "THEATER_A", "THEATER", "WIND", 200.0, wktParser.read("POINT(-45 -45)")}, null)});
        GroupByVisitor visitorA = this.executeVisitor(featureCollectionA, "energy_consumption", "Average", "building_type");
        this.checkResults(visitorA.getResult(), new Object[][]{{"SCHOOL", 30.0}, {"FABRIC", 175.0}, {"HOUSE", 5.0}});
        GroupByVisitor visitorB = this.executeVisitor((FeatureCollection)featureCollectionB, "energy_consumption", "Average", "building_type");
        this.checkResults(visitorB.getResult(), new Object[][]{{"SCHOOL", 57.5}, {"FABRIC", 162.5}, {"HOUSE", 430.0}, {"THEATER", 200.0}});
        this.checkResults(visitorA.getResult().merge(visitorB.getResult()), new Object[][]{{"SCHOOL", 36.875}, {"FABRIC", 170.833}, {"HOUSE", 217.5}, {"THEATER", 200.0}});
    }

    @Test
    public void testMergingGroupByResultsWithNull() throws Exception {
        FeatureCollection featureCollectionA = featureCollection;
        SimpleFeatureCollection featureCollectionB = DataUtilities.collection((SimpleFeature[])new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{1, "SCHOOL_C", "SCHOOL", "NUCLEAR", 100.0, wktParser.read("POINT(-15 -15)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{1, "SCHOOL_C", "SCHOOL", "FUEL", 15.0, wktParser.read("POINT(-15 -15)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "FABRIC_C", "FABRIC", "NUCLEAR", 250.0, wktParser.read("POINT(-25 -25)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "FABRIC_C", "FABRIC", "WIND", 75.0, wktParser.read("POINT(-25 -25)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "HOUSE_C", "HOUSE", "WIND", 10.0, wktParser.read("POINT(-35 -35)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "HOUSE_C", "HOUSE", "DARK_MATTER", 850.0, wktParser.read("POINT(-35 -35)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{2, "THEATER_A", "THEATER", "WIND", 200.0, wktParser.read("POINT(-45 -45)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{13, "MALL_A", "MALL", "GRAVITY", null, wktParser.read("POINT(-45 -45)")}, null), SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{13, "MALL_B", "MALL", "GRAVITY", null, wktParser.read("POINT(-45 -45)")}, null)});
        GroupByVisitor visitorA = this.executeVisitor(featureCollectionA, "energy_consumption", "Average", "building_type");
        this.checkResults(visitorA.getResult(), new Object[][]{{"SCHOOL", 30.0}, {"FABRIC", 175.0}, {"HOUSE", 5.0}});
        GroupByVisitor visitorB = this.executeVisitor((FeatureCollection)featureCollectionB, "energy_consumption", "Average", "building_type");
        this.checkResults(visitorB.getResult(), new Object[][]{{"SCHOOL", 57.5}, {"FABRIC", 162.5}, {"HOUSE", 430.0}, {"THEATER", 200.0}, {"MALL", null}});
        this.checkResults(visitorA.getResult().merge(visitorB.getResult()), new Object[][]{{"SCHOOL", 36.875}, {"FABRIC", 170.833}, {"HOUSE", 217.5}, {"THEATER", 200.0}, {"MALL", null}});
    }

    @Test
    public void testFeatureAttributeVisitor() {
        GroupByVisitor visitor = this.buildVisitor("energy_consumption", "Average", "building_type");
        List expressions = visitor.getExpressions();
        HashSet<String> names = new HashSet<String>();
        for (Expression expression : expressions) {
            PropertyName pn = (PropertyName)expression;
            names.add(pn.getPropertyName());
        }
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("energy_consumption"));
        Assert.assertTrue((boolean)names.contains("building_type"));
    }

    private void testVisitor(String aggregateAttribute, String aggregateVisitor, String groupByAttribute, Object[][] expectedResults) throws Exception {
        this.testVisitor(aggregateAttribute, aggregateVisitor, new String[]{groupByAttribute}, expectedResults);
    }

    private void testVisitor(String aggregateAttribute, String aggregateVisitor, String firstGroupByAttribute, String secondGroupByAttribute, Object[][] expectedResults) throws Exception {
        this.testVisitor(aggregateAttribute, aggregateVisitor, new String[]{firstGroupByAttribute, secondGroupByAttribute}, expectedResults);
    }

    private void testVisitor(String aggregateAttribute, String aggregateVisitor, String[] groupByAttributes, Object[][] expectedResults) throws Exception {
        GroupByVisitor visitor = this.executeVisitor(featureCollection, aggregateAttribute, aggregateVisitor, groupByAttributes);
        this.checkResults(visitor.getResult(), expectedResults);
    }

    private GroupByVisitor executeVisitor(FeatureCollection featureCollection, String aggregateAttribute, String aggregateVisitor, String ... groupByAttributes) throws Exception {
        GroupByVisitor visitor = this.buildVisitor(aggregateAttribute, aggregateVisitor, groupByAttributes);
        featureCollection.accepts((FeatureVisitor)visitor, (ProgressListener)new NullProgressListener());
        return visitor;
    }

    private GroupByVisitor buildVisitor(String aggregateAttribute, String aggregateVisitor, String ... groupByAttributes) {
        GroupByVisitorBuilder visitorBuilder = new GroupByVisitorBuilder().withAggregateAttribute(aggregateAttribute, buildingType).withAggregateVisitor(aggregateVisitor);
        for (String groupByAttribute : groupByAttributes) {
            visitorBuilder.withGroupByAttribute(groupByAttribute, buildingType);
        }
        return visitorBuilder.build();
    }

    private void checkResults(CalcResult calcResult, Object[][] expectedResults) {
        MatcherAssert.assertThat((Object)calcResult, (Matcher)CoreMatchers.notNullValue());
        Object[] results = calcResult.toArray();
        MatcherAssert.assertThat((Object)results.length, (Matcher)CoreMatchers.is((Object)expectedResults.length));
        Map resultMap = calcResult.toMap();
        MatcherAssert.assertThat((Object)resultMap.entrySet().size(), (Matcher)CoreMatchers.is((Object)expectedResults.length));
        for (Object[] expectedResult : expectedResults) {
            MatcherAssert.assertThat((Object)this.contains(results, expectedResult), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private boolean contains(Object[] results, Object[] expectedResult) {
        for (Object result : results) {
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Object[].class));
            if (!this.checkArraysAreEqual((Object[])result, expectedResult)) continue;
            return true;
        }
        return false;
    }

    private boolean checkArraysAreEqual(Object[] arrayA, Object[] arrayB) {
        MatcherAssert.assertThat((Object)arrayA, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)arrayB, (Matcher)CoreMatchers.notNullValue());
        if (arrayA.length != arrayB.length) {
            return false;
        }
        for (int i = 0; i < arrayA.length; ++i) {
            double difference;
            if (arrayA[i] == null && arrayB[i] == null) continue;
            MatcherAssert.assertThat((Object)arrayA[i], (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)arrayB[i], (Matcher)CoreMatchers.notNullValue());
            if (!arrayA[i].getClass().equals(arrayB[i].getClass())) {
                return false;
            }
            if (!(arrayA[i] instanceof Double ? (difference = Math.abs((Double)arrayA[i] - (Double)arrayB[i])) > 0.001 : !arrayA[i].equals(arrayB[i]))) continue;
            return false;
        }
        return true;
    }
}

