/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;

public class MaxSimpleFeatureCollectionTest {
    DefaultFeatureCollection delegate;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("foo");
        tb.add("geom", Point.class);
        tb.add("name", String.class);
        SimpleFeatureType featureType = tb.buildFeatureType();
        this.delegate = new DefaultFeatureCollection(null, featureType);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        for (int i = 0; i < 10; ++i) {
            b.add((Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            b.add((Object)String.valueOf(i));
            this.delegate.add(b.buildFeature("fid." + i));
        }
    }

    @Test
    public void testSize() {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 5L);
        Assert.assertEquals((long)5L, (long)max.size());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 7L, 5L);
        Assert.assertEquals((long)3L, (long)max.size());
    }

    @Test
    public void testIsEmpty() {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 5L);
        Assert.assertFalse((boolean)max.isEmpty());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 9L, 5L);
        Assert.assertFalse((boolean)max.isEmpty());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 10L, 5L);
        Assert.assertTrue((boolean)max.isEmpty());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 0L, 0L);
        Assert.assertTrue((boolean)max.isEmpty());
    }

    @Test
    public void testIterator() {
        int i;
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 5L);
        try (SimpleFeatureIterator it = max.features();){
            for (i = 0; i < 5; ++i) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertNotNull((Object)it.next());
            }
            Assert.assertFalse((boolean)it.hasNext());
        }
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 7L, 5L);
        it = max.features();
        try {
            for (i = 0; i < 3; ++i) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertNotNull((Object)it.next());
            }
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }
}

