/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.view;

import java.io.IOException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.IllegalFilterException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;

public class DefaultViewTest {
    String typeName = "type1";
    private SimpleFeatureSource fs;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)this.typeName, (String)"geom:Point,name:String,id:int");
        ListFeatureCollection collection = new ListFeatureCollection(ft);
        collection.add(this.createFeatures(ft, 1));
        collection.add(this.createFeatures(ft, 2));
        collection.add(this.createFeatures(ft, 3));
        collection.add(this.createFeatures(ft, 4));
        this.fs = DataUtilities.source((FeatureCollection)collection);
    }

    private SimpleFeature createFeatures(SimpleFeatureType ft, int i) throws IllegalAttributeException {
        GeometryFactory fac = new GeometryFactory();
        return SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{fac.createPoint(new Coordinate((double)i, (double)i)), "name" + i, i}, null);
    }

    @Test
    public void testGetFeatures() throws Exception {
        SimpleFeatureSource view = this.getView();
        try (SimpleFeatureIterator features = view.getFeatures().features();){
            int count = 0;
            while (features.hasNext()) {
                ++count;
                features.next();
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testGetFeaturesQuery() throws Exception {
        SimpleFeatureSource view = this.getView();
        try (SimpleFeatureIterator features = view.getFeatures(this.getQuery()).features();){
            int count = 0;
            while (features.hasNext()) {
                ++count;
                features.next();
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void testGetFeaturesFilter() throws Exception {
        SimpleFeatureSource view = this.getView();
        Filter f = this.getFilter();
        try (SimpleFeatureIterator features = view.getFeatures(f).features();){
            int count = 0;
            while (features.hasNext()) {
                ++count;
                features.next();
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void testGetCount() throws Exception {
        SimpleFeatureSource view = this.getView();
        Query query = this.getQuery();
        int count = view.getCount(query);
        Assert.assertEquals((long)1L, (long)count);
    }

    private Query getQuery() throws IllegalFilterException {
        Filter f = this.getFilter();
        Query query = new Query(this.typeName, f, new String[0]);
        return query;
    }

    private Filter getFilter() throws IllegalFilterException {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = fac.equals((Expression)fac.property("name"), (Expression)fac.literal((Object)"name2"));
        return f;
    }

    private SimpleFeatureSource getView() throws IllegalFilterException, IOException, SchemaException {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsLessThan f = fac.less((Expression)fac.property("id"), (Expression)fac.literal(3));
        SimpleFeatureSource view = DataUtilities.createView((SimpleFeatureSource)this.fs, (Query)new Query(this.typeName, (Filter)f));
        return view;
    }
}

