/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.geotools.data.util.URConverterFactory;
import org.geotools.util.Converter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class URConverterFactoryTest {
    URConverterFactory f;

    @Before
    public void setUp() throws Exception {
        this.f = new URConverterFactory();
    }

    @Test
    public void testStringToURL() throws Exception {
        Converter c = this.f.createConverter(String.class, URL.class, null);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)new URL("http://foo.com"), (Object)c.convert((Object)"http://foo.com", URL.class));
        Assert.assertEquals((Object)new File("/foo/bar").toURI().toURL(), (Object)c.convert((Object)"/foo/bar", URL.class));
    }

    @Test
    public void testStringToURI() throws Exception {
        Converter c = this.f.createConverter(String.class, URI.class, null);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)new URI("http://foo.com"), (Object)c.convert((Object)"http://foo.com", URI.class));
    }

    @Test
    public void testURIToURL() throws Exception {
        Converter c = this.f.createConverter(URL.class, URI.class, null);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)new URI("http://foo.com"), (Object)c.convert((Object)new URL("http://foo.com"), URI.class));
    }

    @Test
    public void testURLToURI() throws Exception {
        Converter c = this.f.createConverter(URI.class, URL.class, null);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)new URL("http://foo.com"), (Object)c.convert((Object)new URI("http://foo.com"), URL.class));
    }
}

