/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.geotools.data.util.NumericConverterFactory;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumericConverterFactoryTest {
    NumericConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new NumericConverterFactory();
    }

    @Test
    public void testIntegral() throws Exception {
        Assert.assertEquals((Object)127, (Object)this.convert((byte)127, Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert((short)127, Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127, Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127L, Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert(BigInteger.valueOf(127L), Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert((byte)127, Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert((short)127, Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127, Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127L, Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert(BigInteger.valueOf(127L), Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert((byte)127, Integer.class));
        Assert.assertEquals((Object)127, (Object)this.convert((short)127, Integer.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127, Integer.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127L, Integer.class));
        Assert.assertEquals((Object)127, (Object)this.convert(BigInteger.valueOf(127L), Integer.class));
        Assert.assertEquals((Object)127L, (Object)this.convert((byte)127, Long.class));
        Assert.assertEquals((Object)127L, (Object)this.convert((short)127, Long.class));
        Assert.assertEquals((Object)127L, (Object)this.convert(127, Long.class));
        Assert.assertEquals((Object)127L, (Object)this.convert(127L, Long.class));
        Assert.assertEquals((Object)127L, (Object)this.convert(BigInteger.valueOf(127L), Long.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert((byte)127, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert((short)127, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(127, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(127L, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(BigInteger.valueOf(127L), BigInteger.class));
    }

    @Test
    public void testFloat() throws Exception {
        Assert.assertEquals((Object)Float.valueOf(127.127f), (Object)this.convert(Float.valueOf(127.127f), Float.class));
        Assert.assertEquals((Object)Float.valueOf(127.127f), (Object)this.convert(127.127, Float.class));
        Assert.assertEquals((Object)Float.valueOf(127.127f), (Object)this.convert(BigDecimal.valueOf(127.127), Float.class));
        Assert.assertEquals((double)127.127, (double)((Double)this.convert(Float.valueOf(127.127f), Double.class)), (double)1.0E-10);
        Assert.assertEquals((Object)127.127, (Object)this.convert(127.127, Double.class));
        Assert.assertEquals((Object)127.127, (Object)this.convert(BigDecimal.valueOf(127.127), Double.class));
        Assert.assertEquals((double)BigDecimal.valueOf(127.127).doubleValue(), (double)((BigDecimal)this.convert(Float.valueOf(127.127f), BigDecimal.class)).doubleValue(), (double)1.0E-10);
        Assert.assertEquals((Object)BigDecimal.valueOf(127.127), (Object)this.convert(127.127, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127.127), (Object)this.convert(BigDecimal.valueOf(127.127), BigDecimal.class));
    }

    @Test
    public void testIntegralToFloat() throws Exception {
        Assert.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert((byte)127, Float.class));
        Assert.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert((short)127, Float.class));
        Assert.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert(127, Float.class));
        Assert.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert(127L, Float.class));
        Assert.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert(BigInteger.valueOf(127L), Float.class));
        Assert.assertEquals((Object)127.0, (Object)this.convert((byte)127, Double.class));
        Assert.assertEquals((Object)127.0, (Object)this.convert((short)127, Double.class));
        Assert.assertEquals((Object)127.0, (Object)this.convert(127, Double.class));
        Assert.assertEquals((Object)127.0, (Object)this.convert(127L, Double.class));
        Assert.assertEquals((Object)127.0, (Object)this.convert(BigInteger.valueOf(127L), Double.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)this.convert((byte)127, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)this.convert((short)127, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)this.convert(127, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)this.convert(127L, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)this.convert(BigInteger.valueOf(127L), BigDecimal.class));
    }

    @Test
    public void testFloatToIntegral() throws Exception {
        Assert.assertEquals((Object)127, (Object)this.convert(Float.valueOf(127.127f), Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127.127, Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert(BigDecimal.valueOf(127.127), Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convert(Float.valueOf(127.127f), Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127.127, Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert(BigDecimal.valueOf(127.127), Short.class));
        Assert.assertEquals((Object)127, (Object)this.convert(Float.valueOf(127.127f), Integer.class));
        Assert.assertEquals((Object)127, (Object)this.convert(127.127, Integer.class));
        Assert.assertEquals((Object)127, (Object)this.convert(BigDecimal.valueOf(127.127), Integer.class));
        Assert.assertEquals((Object)127L, (Object)this.convert(Float.valueOf(127.127f), Long.class));
        Assert.assertEquals((Object)127L, (Object)this.convert(127.127, Long.class));
        Assert.assertEquals((Object)127L, (Object)this.convert(BigDecimal.valueOf(127.127), Long.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(Float.valueOf(127.127f), BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(127.127, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(BigDecimal.valueOf(127.127), BigInteger.class));
    }

    @Test
    public void testStringToInteger() throws Exception {
        Assert.assertEquals((Object)127, (Object)this.convert("127", Integer.class));
        Assert.assertEquals((Object)127, (Object)this.convert(" 127 ", Integer.class));
        Assert.assertEquals((Object)3, (Object)this.convert(" 3.0 ", Integer.class));
        Assert.assertEquals((Object)-3, (Object)this.convert("-3.0 ", Integer.class));
        Assert.assertEquals((Object)3000, (Object)this.convert("3000.0 ", Integer.class));
        Assert.assertEquals((Object)3000, (Object)this.convert("3000,0 ", Integer.class));
    }

    @Test
    public void testStringToDouble() throws Exception {
        Assert.assertEquals((Object)4.4, (Object)this.convert("4.4", Double.class));
        Assert.assertEquals((Object)127.0, (Object)this.convert("127", Double.class));
        Assert.assertEquals((Object)127.0, (Object)this.convert(" 127 ", Double.class));
        Assert.assertEquals((Object)3.0, (Object)this.convert(" 3.0 ", Double.class));
        Assert.assertEquals((Object)-3.0, (Object)this.convert("-3.0 ", Double.class));
        Assert.assertEquals((Object)3000.0, (Object)this.convert("3000.0 ", Double.class));
    }

    @Test
    public void testStringToNumber() throws Exception {
        Assert.assertEquals((Object)4.4, (Object)this.convert("4.4", Number.class));
    }

    Object convert(Object source, Class<?> target) throws Exception {
        return this.factory.createConverter(source.getClass(), target, null).convert(source, target);
    }

    @Test
    public void testIntegralHandling() {
        Assert.assertEquals((Object)"3", (Object)NumericConverterFactory.toIntegral((String)"3"));
        Assert.assertEquals((Object)"3", (Object)NumericConverterFactory.toIntegral((String)"3.0"));
        Assert.assertEquals((Object)"-3", (Object)NumericConverterFactory.toIntegral((String)"-3"));
        Assert.assertEquals((Object)"-3", (Object)NumericConverterFactory.toIntegral((String)"-3.0"));
        Assert.assertEquals((Object)"3000", (Object)NumericConverterFactory.toIntegral((String)"3000.0"));
        Assert.assertEquals((Object)"3000", (Object)NumericConverterFactory.toIntegral((String)"3000,0"));
    }

    Object convertSafe(Object source, Class<?> target) throws Exception {
        Hints hints = new Hints();
        hints.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)Boolean.TRUE);
        return this.factory.createConverter(source.getClass(), target, hints).convert(source, target);
    }

    @Test
    public void testSafeConversion() throws Exception {
        Assert.assertEquals((Object)127, (Object)this.convertSafe((byte)127, Byte.class));
        Assert.assertNull((Object)this.convertSafe((short)128, Byte.class));
        Assert.assertNull((Object)this.convertSafe(128, Byte.class));
        Assert.assertNull((Object)this.convertSafe(128L, Byte.class));
        Assert.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Byte.class));
        Assert.assertNull((Object)this.convertSafe(128.1, Byte.class));
        Assert.assertNull((Object)this.convertSafe(BigDecimal.valueOf(128.1), Byte.class));
        Assert.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Byte.class));
        Assert.assertEquals((Object)127, (Object)this.convertSafe((byte)127, Short.class));
        Assert.assertEquals((Object)1111, (Object)this.convertSafe((short)1111, Short.class));
        Assert.assertNull((Object)this.convertSafe(128, Short.class));
        Assert.assertNull((Object)this.convertSafe(128L, Short.class));
        Assert.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Short.class));
        Assert.assertNull((Object)this.convertSafe(128.1, Short.class));
        Assert.assertNull((Object)this.convertSafe(BigDecimal.valueOf(128.1), Short.class));
        Assert.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Short.class));
        Assert.assertEquals((Object)127, (Object)this.convertSafe((byte)127, Integer.class));
        Assert.assertEquals((Object)1111, (Object)this.convertSafe((short)1111, Integer.class));
        Assert.assertEquals((Object)12345, (Object)this.convertSafe(12345, Integer.class));
        Assert.assertNull((Object)this.convertSafe(128L, Integer.class));
        Assert.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Integer.class));
        Assert.assertNull((Object)this.convertSafe(128.1, Integer.class));
        Assert.assertNull((Object)this.convertSafe(BigDecimal.valueOf(128.1), Integer.class));
        Assert.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Integer.class));
        Assert.assertEquals((Object)127L, (Object)this.convertSafe((byte)127, Long.class));
        Assert.assertEquals((Object)1111L, (Object)this.convertSafe((short)1111, Long.class));
        Assert.assertEquals((Object)12345L, (Object)this.convertSafe(12345, Long.class));
        Assert.assertEquals((Object)1234567L, (Object)this.convertSafe(1234567, Long.class));
        Assert.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Long.class));
        Assert.assertNull((Object)this.convertSafe(128.1, Long.class));
        Assert.assertNull((Object)this.convertSafe(BigDecimal.valueOf(128.1), Long.class));
        Assert.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Long.class));
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convertSafe((byte)127, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(1111L), (Object)this.convertSafe((short)1111, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(12345L), (Object)this.convertSafe(12345, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(1234567L), (Object)this.convertSafe(1234567, BigInteger.class));
        Assert.assertEquals((Object)BigInteger.valueOf(12345678L), (Object)this.convertSafe(BigInteger.valueOf(12345678L), BigInteger.class));
        Assert.assertNull((Object)this.convertSafe(128.1, Long.class));
        Assert.assertNull((Object)this.convertSafe(BigDecimal.valueOf(128.1), Long.class));
        Assert.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Long.class));
        Assert.assertEquals((Object)127.0, (Object)this.convertSafe((byte)127, Double.class));
        Assert.assertEquals((Object)1111.0, (Object)this.convertSafe((short)1111, Double.class));
        Assert.assertEquals((Object)12345.0, (Object)this.convertSafe(12345, Double.class));
        Assert.assertEquals((Object)1234567.0, (Object)this.convertSafe(1234567, Double.class));
        Assert.assertEquals((Object)12.123456, (Object)this.convertSafe(12.123456, Double.class));
        Assert.assertNull((Object)this.convertSafe(BigDecimal.valueOf(128.1), Long.class));
        Assert.assertEquals((Object)12.12, (Object)this.convertSafe(Float.valueOf(12.12f), Double.class));
        Assert.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convertSafe((byte)127, Float.class));
        Assert.assertEquals((Object)Float.valueOf(1111.0f), (Object)this.convertSafe((short)1111, Float.class));
        Assert.assertEquals((Object)Float.valueOf(12345.0f), (Object)this.convertSafe(12345, Float.class));
        Assert.assertEquals((Object)Float.valueOf(1234567.0f), (Object)this.convertSafe(1234567, Float.class));
        Assert.assertNull((Object)this.convertSafe(BigInteger.valueOf(12345678L), Float.class));
        Assert.assertNull((Object)this.convertSafe(128.1, Float.class));
        Assert.assertNull((Object)this.convertSafe(BigDecimal.valueOf(128.1), Float.class));
        Assert.assertEquals((Object)Float.valueOf(12.12f), (Object)this.convertSafe(Float.valueOf(12.12f), Float.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)this.convertSafe((byte)127, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(1111L), (Object)this.convertSafe((short)1111, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(12345L), (Object)this.convertSafe(12345, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(1234567L), (Object)this.convertSafe(1234567, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(12345678L), (Object)this.convertSafe(BigInteger.valueOf(12345678L), BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(12.123456), (Object)this.convertSafe(12.123456, BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(128.1), (Object)this.convertSafe(BigDecimal.valueOf(128.1), BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(12.12), (Object)this.convertSafe(Float.valueOf(12.12f), BigDecimal.class));
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)this.convertSafe("127", BigDecimal.class));
        Assert.assertNull((Object)this.convertSafe("127f", BigDecimal.class));
        Assert.assertEquals((Object)127.123, (Object)this.convertSafe("127.123", Double.class));
        Assert.assertNull((Object)this.convertSafe("123.456.456", Double.class));
        Assert.assertEquals((Object)Float.valueOf(127.123f), (Object)this.convertSafe("127.123", Float.class));
        Assert.assertNull((Object)this.convertSafe("123.456.456", Float.class));
        Assert.assertEquals((Object)BigInteger.valueOf(1234567L), (Object)this.convertSafe("1234567", BigInteger.class));
        Assert.assertNull((Object)this.convertSafe("123.456", BigInteger.class));
        Assert.assertEquals((Object)54L, (Object)this.convertSafe("54", Long.class));
        Assert.assertNull((Object)this.convertSafe("123.6", Long.class));
        Assert.assertEquals((Object)54, (Object)this.convertSafe("54", Integer.class));
        Assert.assertNull((Object)this.convertSafe("123.6", Integer.class));
        Assert.assertEquals((Object)54, (Object)this.convertSafe("54", Short.class));
        Assert.assertNull((Object)this.convertSafe("123.6", Short.class));
        Assert.assertEquals((Object)Byte.valueOf("1"), (Object)this.convertSafe("1", Byte.class));
        Assert.assertNull((Object)this.convertSafe("123.6", Byte.class));
    }

    @Test
    public void testPrimitiveTypes() throws Exception {
        Assert.assertEquals((Object)1, (Object)this.convert(1, Integer.TYPE));
        Assert.assertEquals((Object)1, (Object)this.convert(1, Integer.TYPE));
        Assert.assertEquals((Object)1, (Object)this.convert(1, Integer.class));
        Assert.assertEquals((Object)1, (Object)this.convert(1, Integer.class));
        Assert.assertEquals((Object)1, (Object)this.convert("1", Integer.TYPE));
        Assert.assertEquals((Object)1, (Object)this.convert("1", Integer.TYPE));
        Assert.assertEquals((Object)1, (Object)this.convert("1", Integer.class));
        Assert.assertEquals((Object)1, (Object)this.convert("1", Integer.class));
    }

    @Test
    public void testStringInScientificNotationToNumber() throws Exception {
        Assert.assertEquals((Object)Long.valueOf("1103442244"), (Object)this.convert("1.1034422448E9", Long.class));
        Assert.assertEquals((Object)Long.valueOf("1103442244"), (Object)this.convert("1.1034422448e9", Long.class));
        Assert.assertEquals((Object)Double.valueOf("1103442244.8"), (Object)this.convert("1.1034422448E9", Double.class));
        Assert.assertEquals((Object)Double.valueOf("1103442244.8"), (Object)this.convert("1.1034422448e9", Double.class));
    }
}

