/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.data.util.GeometryConverterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryConverterFactoryTest {
    GeometryConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new GeometryConverterFactory();
    }

    @Test
    public void testEnvelopeToGeometry() throws Exception {
        Geometry geometry = (Geometry)this.factory.createConverter(Envelope.class, Geometry.class, null).convert((Object)new Envelope(new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0)), Geometry.class);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null).equalsTopo(geometry));
    }

    @Test
    public void testGeometryToEnvelope() throws Exception {
        Envelope envelope = (Envelope)this.factory.createConverter(Geometry.class, Envelope.class, null).convert((Object)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null), Envelope.class);
        Assert.assertEquals((Object)new Envelope(new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0)), (Object)envelope);
    }

    @Test
    public void testStringToGeometry() throws Exception {
        Geometry geometry = (Geometry)this.factory.createConverter(String.class, Geometry.class, null).convert((Object)"POLYGON((0 0, 1 0, 1 1, 0 1, 0 0))", Geometry.class);
        Assert.assertNotNull((Object)geometry);
        Assert.assertTrue((boolean)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null).equalsTopo(geometry));
    }

    @Test
    public void testGeometryToString() throws Exception {
        String wkt = (String)this.factory.createConverter(Geometry.class, String.class, null).convert((Object)new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}), null), String.class);
        Assert.assertEquals((Object)"POLYGON ((0 0, 1 0, 1 1, 0 1, 0 0))", (Object)wkt);
    }
}

