/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLStreamHandler;
import org.geotools.data.util.DataUrlHandler;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;

public class DataUrlHandlerTest {
    @Test
    public void testDataUriDecoding() throws Exception {
        URL url = new URL(null, "data:,YQo=", (URLStreamHandler)new DataUrlHandler());
        this.checkDataUrlContent(url);
    }

    private void checkDataUrlContent(URL url) throws IOException {
        try (InputStreamReader in = new InputStreamReader(url.openStream());
             BufferedReader reader = new BufferedReader(in);){
            String data = reader.readLine();
            Assert.assertEquals((Object)"a", (Object)data);
        }
    }

    @Test
    public void testDataUrlConverter() throws Exception {
        String datasUrl = "data:,YQo=";
        URL url = (URL)Converters.convert((Object)datasUrl, URL.class);
        Assert.assertNotNull((Object)url);
        this.checkDataUrlContent(url);
    }

    @Test
    public void testDataUrlConverterFail() throws Exception {
        String wrongUrl = "wkt://Polygon (1 1, 1 0, 0 3)";
        URL url = (URL)Converters.convert((Object)wrongUrl, URL.class);
        Assert.assertNull((Object)url);
    }
}

