/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotools.data.util.CollectionConverterFactory;
import org.junit.Assert;
import org.junit.Test;

public class CollectionConverterFactoryTest {
    @Test
    public void testCollectionToCollection() throws Exception {
        ArrayList<Integer> source = new ArrayList<Integer>();
        source.add(1);
        source.add(2);
        Object converted = CollectionConverterFactory.CollectionToCollection.convert(source, Set.class);
        Assert.assertTrue((boolean)(converted instanceof Set));
        Set target = (Set)converted;
        Assert.assertTrue((boolean)target.contains(1));
        Assert.assertTrue((boolean)target.contains(2));
    }

    @Test
    public void testCollectionToArray() throws Exception {
        ArrayList<Integer> source = new ArrayList<Integer>();
        source.add(1);
        source.add(2);
        Object converted = CollectionConverterFactory.CollectionToArray.convert(source, Integer[].class);
        Assert.assertTrue((boolean)(converted instanceof Integer[]));
        Integer[] target = (Integer[])converted;
        Assert.assertEquals((Object)1, (Object)target[0]);
        Assert.assertEquals((Object)2, (Object)target[1]);
    }

    @Test
    public void testArrayToCollection() throws Exception {
        Integer[] source = new Integer[]{1, 2};
        Object converted = CollectionConverterFactory.ArrayToCollection.convert((Object)source, List.class);
        Assert.assertTrue((boolean)(converted instanceof List));
        List target = (List)converted;
        Assert.assertEquals((Object)1, target.get(0));
        Assert.assertEquals((Object)2, target.get(1));
    }

    @Test
    public void testArrayToArray() throws Exception {
        Integer[] source = new Integer[]{1, 2};
        Object converted = CollectionConverterFactory.ArrayToArray.convert((Object)source, Number[].class);
        Assert.assertTrue((boolean)(converted instanceof Number[]));
        Number[] target = (Number[])converted;
        Assert.assertEquals((long)1L, (long)target[0].intValue());
        Assert.assertEquals((long)2L, (long)target[1].intValue());
    }
}

