/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.geotools.data.util.CharsetConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CharsetConverterFactoryTest {
    CharsetConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new CharsetConverterFactory();
    }

    @Test
    public void testLookupStringToCharset() {
        Set s = Converters.getConverterFactories(String.class, Charset.class);
        for (ConverterFactory cf : s) {
            if (!(cf instanceof CharsetConverterFactory)) continue;
            return;
        }
        Assert.fail((String)"CharsetConverterFactory not found");
    }

    @Test
    public void testLookupCharsetToString() {
        Set s = Converters.getConverterFactories(Charset.class, String.class);
        for (ConverterFactory cf : s) {
            if (!(cf instanceof CharsetConverterFactory)) continue;
            return;
        }
        Assert.fail((String)"CharsetConverterFactory not found");
    }

    @Test
    public void testStringToCharset() throws Exception {
        Converter c = this.factory.createConverter(String.class, Charset.class, null);
        Assert.assertNotNull((Object)c);
        Charset charset = (Charset)c.convert((Object)"UTF-8", Charset.class);
        Assert.assertNotNull((Object)charset);
        Assert.assertEquals((Object)"UTF-8", (Object)charset.name());
        Assert.assertNull((Object)c.convert((Object)"FOO", Charset.class));
    }

    @Test
    public void testCharsetToString() throws Exception {
        Converter c = this.factory.createConverter(Charset.class, String.class, null);
        Assert.assertNotNull((Object)c);
        String charset = (String)c.convert((Object)StandardCharsets.UTF_8, String.class);
        Assert.assertEquals((Object)"UTF-8", (Object)charset);
    }
}

