/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.math.BigDecimal;
import org.geotools.data.util.BooleanConverterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BooleanConverterFactoryTest {
    BooleanConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new BooleanConverterFactory();
    }

    @Test
    public void testFromString() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.convert("true"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.convert("1"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.convert("false"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.convert("0"));
    }

    @Test
    public void testFromInteger() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.convert(1));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.convert(0));
    }

    @Test
    public void testFromBigDecimal() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.convert(BigDecimal.valueOf(1L)));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.convert(BigDecimal.valueOf(0L)));
    }

    Boolean convert(Object value) throws Exception {
        return (Boolean)this.factory.createConverter(value.getClass(), Boolean.class, null).convert(value, Boolean.class);
    }
}

