/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.data.util.ArrayConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArrayConverterFactoryTest {
    ArrayConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new ArrayConverterFactory();
    }

    @Test
    public void testArrayToSingle() throws Exception {
        String[] array = new String[]{"text"};
        Converter converter = this.factory.createConverter(array.getClass(), String.class, new Hints());
        Assert.assertEquals((Object)"text", (Object)converter.convert((Object)array, String.class));
    }

    @Test
    public void testArrayToSingleWrongType() throws Exception {
        String[] array = new String[]{"text"};
        Converter converter = this.factory.createConverter(array.getClass(), Integer.class, new Hints());
        Assert.assertNull((Object)converter);
    }

    @Test
    public void testArrayToSingleTooManyElements() throws Exception {
        String[] array = new String[]{"text1", "text2"};
        Converter converter = this.factory.createConverter(array.getClass(), String.class, new Hints());
        Assert.assertNull((Object)converter.convert((Object)array, String.class));
    }

    @Test
    public void testSingleToArray() throws Exception {
        String single = "text";
        Converter converter = this.factory.createConverter(single.getClass(), String[].class, new Hints());
        Assert.assertEquals((long)1L, (long)((String[])converter.convert((Object)single, String[].class)).length);
        Assert.assertEquals((Object)"text", (Object)((String[])converter.convert((Object)single, String[].class))[0]);
    }

    @Test
    public void testSingleToArrayWrongType() throws Exception {
        String single = "1";
        Converter converter = this.factory.createConverter(single.getClass(), Integer[].class, new Hints());
        Assert.assertNull((Object)converter);
    }

    @Test
    public void testArrayToArray() throws Exception {
        String[] array = new String[]{"1", "2", "3"};
        Converter converter = this.factory.createConverter(array.getClass(), Integer[].class, new Hints());
        Integer[] converted = (Integer[])converter.convert((Object)array, Integer[].class);
        Assert.assertEquals((long)3L, (long)converted.length);
        Assert.assertEquals((Object)1, (Object)converted[0]);
        Assert.assertEquals((Object)2, (Object)converted[1]);
        Assert.assertEquals((Object)3, (Object)converted[2]);
    }

    @Test
    public void testArrayToArrayWithNulls() throws Exception {
        String[] array = new String[]{"1", "2", null, "3"};
        Converter converter = this.factory.createConverter(array.getClass(), Integer[].class, new Hints());
        Integer[] converted = (Integer[])converter.convert((Object)array, Integer[].class);
        Assert.assertEquals((long)4L, (long)converted.length);
        Assert.assertEquals((Object)1, (Object)converted[0]);
        Assert.assertEquals((Object)2, (Object)converted[1]);
        Assert.assertNull((Object)converted[2]);
        Assert.assertEquals((Object)3, (Object)converted[3]);
    }

    @Test
    public void testArrayToArrayWithConversionErrors() throws Exception {
        String[] array = new String[]{"1", "2", "a", "3"};
        Converter converter = this.factory.createConverter(array.getClass(), Integer[].class, new Hints());
        Integer[] converted = (Integer[])converter.convert((Object)array, Integer[].class);
        Assert.assertNull((Object)converted);
    }

    @Test
    public void testArrayToArrayPrimitive() throws Exception {
        String[] array = new String[]{"1", "2", "3"};
        Converter converter = this.factory.createConverter(array.getClass(), Integer[].class, new Hints());
        int[] converted = (int[])converter.convert((Object)array, int[].class);
        Assert.assertEquals((long)3L, (long)converted.length);
        Assert.assertEquals((long)1L, (long)converted[0]);
        Assert.assertEquals((long)2L, (long)converted[1]);
        Assert.assertEquals((long)3L, (long)converted[2]);
    }
}

