/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.concurrent.TimeUnit;
import org.geotools.data.util.AbbreviatedTimeUnitConverterFactory;
import org.geotools.util.Converter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbbreviatedTimeUnitConverterFactoryTest {
    AbbreviatedTimeUnitConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new AbbreviatedTimeUnitConverterFactory();
    }

    @Test
    public void testAbbreviatedTimeUnitsToTimeUnitConversion() throws Exception {
        Converter converter = this.factory.createConverter(String.class, TimeUnit.class, null);
        this.assertConversion(converter, "ms", TimeUnit.MILLISECONDS);
        this.assertConversion(converter, "s", TimeUnit.SECONDS);
        this.assertConversion(converter, "m", TimeUnit.MINUTES);
        this.assertConversion(converter, "h", TimeUnit.HOURS);
        this.assertConversion(converter, "d", TimeUnit.DAYS);
        this.assertConversion(converter, "k", null);
    }

    private void assertConversion(Converter converter, String timeUnitString, TimeUnit expectedTimeUnit) throws Exception {
        TimeUnit convertedTimeUnit = (TimeUnit)((Object)converter.convert((Object)timeUnitString, TimeUnit.class));
        Assert.assertEquals((Object)((Object)convertedTimeUnit), (Object)((Object)expectedTimeUnit));
    }
}

