/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import org.easymock.EasyMock;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class ReTypingFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    @Test
    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.delegate.getSchema();
        SimpleFeatureType renamed = this.buildRenamedFeatureType(schema, schema.getTypeName() + "xxx");
        ReTypingFeatureCollection rtc = new ReTypingFeatureCollection((SimpleFeatureCollection)this.delegate, renamed);
        Assert.assertEquals((Object)renamed, (Object)rtc.getSchema());
    }

    private SimpleFeatureType buildRenamedFeatureType(SimpleFeatureType schema, String newName) {
        SimpleFeatureType original = schema;
        SimpleFeatureTypeBuilder stb = new SimpleFeatureTypeBuilder();
        stb.init(original);
        stb.setName(newName);
        return stb.buildFeatureType();
    }

    @Test
    public void testDelegateAccepts() throws Exception {
        SimpleFeatureTypeBuilder stb = new SimpleFeatureTypeBuilder();
        stb.setName("test");
        stb.add("foo", String.class);
        stb.add("bar", Integer.class);
        UniqueVisitor vis = new UniqueVisitor(new String[]{"bar"});
        SimpleFeatureCollection delegate = (SimpleFeatureCollection)EasyMock.createMock(SimpleFeatureCollection.class);
        delegate.accepts((FeatureVisitor)vis, null);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{delegate});
        ReTypingFeatureCollection rtc = new ReTypingFeatureCollection(delegate, stb.buildFeatureType());
        rtc.accepts((FeatureVisitor)vis, null);
        EasyMock.verify((Object[])new Object[]{delegate});
        vis = new UniqueVisitor(new String[]{"baz"});
        SimpleFeatureIterator it = (SimpleFeatureIterator)EasyMock.createNiceMock(SimpleFeatureIterator.class);
        EasyMock.replay((Object[])new Object[]{it});
        SimpleFeatureType ft = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.replay((Object[])new Object[]{ft});
        delegate = (SimpleFeatureCollection)EasyMock.createMock(SimpleFeatureCollection.class);
        EasyMock.expect((Object)delegate.features()).andReturn((Object)it).once();
        EasyMock.expect((Object)((SimpleFeatureType)delegate.getSchema())).andReturn((Object)ft).once();
        EasyMock.replay((Object[])new Object[]{delegate});
        rtc = new ReTypingFeatureCollection(delegate, stb.buildFeatureType());
        rtc.accepts((FeatureVisitor)vis, null);
        EasyMock.verify((Object[])new Object[]{delegate});
    }

    @Test
    public void testDelegateAcceptsNearest() throws Exception {
        SimpleFeatureTypeBuilder stb = new SimpleFeatureTypeBuilder();
        stb.setName("test");
        stb.add("foo", String.class);
        stb.add("bar", Integer.class);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        NearestVisitor vis = new NearestVisitor((Expression)ff.property("bar"), (Object)0);
        SimpleFeatureCollection delegate = (SimpleFeatureCollection)EasyMock.createMock(SimpleFeatureCollection.class);
        delegate.accepts((FeatureVisitor)vis, null);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{delegate});
        ReTypingFeatureCollection rtc = new ReTypingFeatureCollection(delegate, stb.buildFeatureType());
        rtc.accepts((FeatureVisitor)vis, null);
        EasyMock.verify((Object[])new Object[]{delegate});
        vis = new NearestVisitor((Expression)ff.property("baz"), (Object)"abc");
        SimpleFeatureIterator it = (SimpleFeatureIterator)EasyMock.createNiceMock(SimpleFeatureIterator.class);
        EasyMock.replay((Object[])new Object[]{it});
        SimpleFeatureType ft = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.replay((Object[])new Object[]{ft});
        delegate = (SimpleFeatureCollection)EasyMock.createMock(SimpleFeatureCollection.class);
        EasyMock.expect((Object)delegate.features()).andReturn((Object)it).once();
        EasyMock.expect((Object)((SimpleFeatureType)delegate.getSchema())).andReturn((Object)ft).once();
        EasyMock.replay((Object[])new Object[]{delegate});
        rtc = new ReTypingFeatureCollection(delegate, stb.buildFeatureType());
        rtc.accepts((FeatureVisitor)vis, null);
        EasyMock.verify((Object[])new Object[]{delegate});
    }

    @Test
    public void testPreserveUserData() throws Exception {
        SimpleFeatureType schema = this.delegate.getSchema();
        SimpleFeatureType renamed = this.buildRenamedFeatureType(schema, schema.getTypeName() + "xxx");
        ReTypingFeatureCollection rtc = new ReTypingFeatureCollection((SimpleFeatureCollection)this.delegate, renamed);
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)rtc);
        Assert.assertEquals((Object)"test_value", first.getUserData().get("test_key"));
    }
}

