/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.junit.Assert;
import org.junit.Test;

public class MaxFeaturesFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    @Test
    public void testSize() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 2L);
        Assert.assertEquals((long)2L, (long)max.size());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() - 1), 10L);
        Assert.assertEquals((long)1L, (long)max.size());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() + 1), 10L);
        Assert.assertEquals((long)0L, (long)max.size());
    }

    @Test
    public void testIteratorMax() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 2L);
        try (SimpleFeatureIterator i = max.features();){
            for (int x = 0; x < 2; ++x) {
                Assert.assertTrue((boolean)i.hasNext());
                i.next();
            }
            Assert.assertFalse((boolean)i.hasNext());
        }
    }

    @Test
    public void testIteratorSkipMax() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() - 1), 2L);
        try (SimpleFeatureIterator i = max.features();){
            Assert.assertTrue((boolean)i.hasNext());
            i.next();
            Assert.assertFalse((boolean)i.hasNext());
        }
    }

    @Test
    public void testIteratorSkipMoreSize() throws Exception {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (long)(this.delegate.size() + 1), 2L);
        try (SimpleFeatureIterator i = max.features();){
            Assert.assertFalse((boolean)i.hasNext());
        }
    }
}

