/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.data.store.AbstractContentTest;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.type.Name;

public class ContentDataStoreTest
extends AbstractContentTest {
    protected static final Name TYPENAME2 = new NameImpl("http://www.geotools.org", "Mock2");

    @Test
    public void testRepeatedTypeListCreation() throws IOException {
        final AtomicInteger creationCounter = new AtomicInteger(0);
        AbstractContentTest.MockContentDataStore store = new AbstractContentTest.MockContentDataStore(){

            @Override
            protected List<Name> createTypeNames() throws IOException {
                creationCounter.incrementAndGet();
                return super.createTypeNames();
            }
        };
        store.getFeatureSource(TYPENAME.getLocalPart());
        Assert.assertEquals((long)1L, (long)creationCounter.get());
        store.getFeatureSource(TYPENAME.getLocalPart());
        Assert.assertEquals((long)1L, (long)creationCounter.get());
    }

    @Test
    public void testCallCreateTypeNamesOnce() throws IOException {
        final AtomicInteger creationCounter = new AtomicInteger(0);
        AbstractContentTest.MockContentDataStore store = new AbstractContentTest.MockContentDataStore(){

            @Override
            protected List<Name> createTypeNames() throws IOException {
                creationCounter.incrementAndGet();
                return Arrays.asList(AbstractContentTest.TYPENAME, TYPENAME2);
            }
        };
        store.getFeatureSource(TYPENAME.getLocalPart());
        Assert.assertEquals((long)1L, (long)creationCounter.get());
        store.getFeatureSource(TYPENAME2.getLocalPart());
        Assert.assertEquals((long)1L, (long)creationCounter.get());
    }
}

