/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import org.geotools.data.DataTestCase;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class MemoryFeatureReaderTest
extends DataTestCase {
    private MemoryDataStore memoryDataStore;
    private final Transaction transaction = new DefaultTransaction();

    public void init() throws Exception {
        super.init();
        this.memoryDataStore = new MemoryDataStore(this.roadFeatures);
    }

    @Test
    public void testReaderIsNotBrokenWhileWritingFeatureDirectly() throws IOException {
        int expectedFeatureCount = this.roadFeatures.length;
        int currentFeatureCount = 0;
        try (FeatureReader featureReader = this.memoryDataStore.getFeatureReader(new Query(this.roadType.getTypeName(), (Filter)Filter.INCLUDE), this.transaction);){
            if (featureReader.hasNext()) {
                featureReader.next();
                ++currentFeatureCount;
            }
            SimpleFeature newFeature = SimpleFeatureBuilder.template((SimpleFeatureType)this.roadType, null);
            this.memoryDataStore.addFeature(newFeature);
            this.assertReaderHasFeatureCount(expectedFeatureCount, currentFeatureCount, (FeatureReader<SimpleFeatureType, SimpleFeature>)featureReader);
        }
    }

    @Test
    public void testReaderIsNotBrokenWhileWritingWithWriterAndTransaction() throws IOException {
        int expectedFeatureCount = this.roadFeatures.length;
        int currentFeatureCount = 0;
        try (FeatureReader featureReader = this.memoryDataStore.getFeatureReader(new Query(this.roadType.getTypeName(), (Filter)Filter.INCLUDE), this.transaction);){
            if (featureReader.hasNext()) {
                featureReader.next();
                ++currentFeatureCount;
            }
            try (FeatureWriter featureWriter = this.memoryDataStore.getFeatureWriter(this.roadType.getTypeName(), this.transaction);){
                while (featureWriter.hasNext()) {
                    featureWriter.next();
                }
                SimpleFeature newFeature = (SimpleFeature)featureWriter.next();
                Assert.assertNotNull((Object)newFeature);
                this.transaction.commit();
                this.assertReaderHasFeatureCount(expectedFeatureCount, currentFeatureCount, (FeatureReader<SimpleFeatureType, SimpleFeature>)featureReader);
            }
        }
    }

    public void shutDown() throws IOException {
        this.transaction.close();
    }

    private void assertReaderHasFeatureCount(int expectedFeatureCount, int currentFeatureCount, FeatureReader<SimpleFeatureType, SimpleFeature> featureReader) throws IOException {
        while (featureReader.hasNext()) {
            featureReader.next();
            ++currentFeatureCount;
        }
        Assert.assertEquals((String)"a write in MemoryDataStore should not 'destroy' readers", (long)expectedFeatureCount, (long)currentFeatureCount);
    }
}

