/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.xml.sax.helpers.NamespaceSupport;

public class QueryTest {
    @Test
    public void testFullConstructor() {
        Query query = new Query("mytype", (Filter)Filter.INCLUDE, 10, new String[]{"foo"}, "myquery");
        Assert.assertNotNull((Object)query);
    }

    @Test
    public void testPropertyNames() {
        Query query = new Query();
        Assert.assertNull((Object)query.getPropertyNames());
        query.setPropertyNames(new String[]{"foo", "bar"});
        String[] names = query.getPropertyNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((Object)"foo", (Object)names[0]);
        List<String> list = Arrays.asList(names);
        query.setPropertyNames(list);
        names = query.getPropertyNames();
        Assert.assertEquals((Object)"bar", (Object)names[1]);
        List properties2 = query.getProperties();
        Assert.assertNotNull((Object)properties2);
        Assert.assertEquals((Object)"foo", (Object)((PropertyName)properties2.get(0)).getPropertyName());
        Assert.assertEquals((Object)"bar", (Object)((PropertyName)properties2.get(1)).getPropertyName());
        query.setPropertyNames(Query.ALL_NAMES);
        Assert.assertNull((Object)query.getPropertyNames());
        query = new Query("Test", (Filter)Filter.INCLUDE, new String[]{"foo", "wibble"});
        Assert.assertNotNull((Object)query.getPropertyNames());
    }

    @Test
    public void testProperties() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Query query = new Query();
        Assert.assertNull((Object)query.getProperties());
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        NamespaceSupport nsContext = new NamespaceSupport();
        nsContext.declarePrefix("foo", "FooNamespace");
        PropertyName fooProp = ff.property("foo", nsContext);
        PropertyName barProp = ff.property("bar", nsContext);
        properties.add(fooProp);
        properties.add(barProp);
        query.setProperties(properties);
        List properties2 = query.getProperties();
        Assert.assertNotNull(properties);
        Assert.assertEquals((Object)fooProp, properties2.get(0));
        Assert.assertEquals((Object)barProp, properties2.get(1));
        Assert.assertEquals((Object)nsContext, (Object)((PropertyName)properties2.get(0)).getNamespaceContext());
        String[] names = query.getPropertyNames();
        Assert.assertEquals((Object)"foo", (Object)names[0]);
        Assert.assertEquals((Object)"bar", (Object)names[1]);
        query.setProperties(Query.ALL_PROPERTIES);
        Assert.assertNull((Object)query.getProperties());
        query = new Query("Test", (Filter)Filter.INCLUDE, properties);
        Assert.assertNotNull((Object)query.getProperties());
    }

    @Test
    public void testRetrieveAllProperties() {
        Query query = new Query();
        Assert.assertTrue((boolean)query.retrieveAllProperties());
        query.setPropertyNames(new String[]{"foo", "bar"});
        Assert.assertFalse((boolean)query.retrieveAllProperties());
        query.setPropertyNames(Query.ALL_NAMES);
        Assert.assertTrue((boolean)query.retrieveAllProperties());
        query.setProperties(Query.ALL_PROPERTIES);
        Assert.assertTrue((boolean)query.retrieveAllProperties());
        query.setPropertyNames(new String[]{"foo", "bar"});
        query.setProperties(Query.ALL_PROPERTIES);
        Assert.assertTrue((boolean)query.retrieveAllProperties());
    }

    @Test
    public void testMaxFeatures() {
        Query query = new Query();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)query.getMaxFeatures());
        query.setMaxFeatures(5);
        Assert.assertEquals((long)5L, (long)query.getMaxFeatures());
    }

    @Test
    public void testFilter() {
        Query query = new Query();
        query.setFilter((Filter)Filter.EXCLUDE);
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)query.getFilter());
        query = new Query("test", (Filter)Filter.INCLUDE);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)query.getFilter());
    }

    @Test
    public void testTypeName() {
        Query query = new Query();
        Assert.assertNull((Object)query.getTypeName());
        query.setTypeName("foobar");
        Assert.assertEquals((Object)"foobar", (Object)query.getTypeName());
        query = new Query("mytype", (Filter)Filter.EXCLUDE);
        Assert.assertEquals((Object)"mytype", (Object)query.getTypeName());
    }

    @Test
    public void testHandle() {
        Query query = new Query();
        Assert.assertNull((Object)query.getHandle());
        query.setHandle("myquery");
        Assert.assertEquals((Object)"myquery", (Object)query.getHandle());
    }

    @Test
    public void testVersion() {
        Query query = new Query();
        Assert.assertNull((Object)query.getVersion());
    }

    @Test
    public void testToString() {
        Query query = new Query();
        Assert.assertNotNull((Object)query.toString());
        query.setHandle("myquery");
        Assert.assertNotNull((Object)query.toString());
        query.setFilter((Filter)Filter.EXCLUDE);
        Assert.assertNotNull((Object)query.toString());
        query.setPropertyNames(new String[]{"foo", "bar"});
        Assert.assertNotNull((Object)query.toString());
        query = new Query();
        query.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        Assert.assertTrue((boolean)query.toString().contains("[sort by: NATURAL]"));
        query.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        Assert.assertTrue((boolean)query.toString().contains("[sort by: REVERSE]"));
    }

    @Test
    public void testSortByEquality() {
        Query q1 = new Query();
        Query q2 = new Query();
        q2.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        MatcherAssert.assertThat((Object)q1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)q2)));
        Query q3 = new Query();
        q3.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        MatcherAssert.assertThat((Object)q2, (Matcher)CoreMatchers.equalTo((Object)q3));
    }
}

