/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class FilteringFeatureReaderTest
extends DataTestCase {
    FeatureReader<SimpleFeatureType, SimpleFeature> roadReader;
    FeatureReader<SimpleFeatureType, SimpleFeature> riverReader;

    public void init() throws Exception {
        super.init();
        this.roadReader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);
        this.riverReader = DataUtilities.reader((SimpleFeature[])this.riverFeatures);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.roadReader.close();
        this.roadReader = null;
        this.riverReader.close();
        this.riverReader = null;
    }

    @Test
    public void testFilteringFeatureReaderALL() throws IOException {
        try (FilteringFeatureReader reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.EXCLUDE);){
            Assert.assertFalse((boolean)reader.hasNext());
        }
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.EXCLUDE);
        try {
            Assert.assertEquals((long)0L, (long)this.count((FeatureReader)reader));
        }
        finally {
            reader.close();
        }
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.EXCLUDE);
        try {
            this.assertContents(new SimpleFeature[0], (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testFilteringFeatureReaderNONE() throws IOException {
        try (FilteringFeatureReader reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.INCLUDE);){
            Assert.assertTrue((boolean)reader.hasNext());
        }
        reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);
        try {
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count((FeatureReader)reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.INCLUDE);
        try {
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count((FeatureReader)reader));
        }
        finally {
            reader.close();
        }
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.INCLUDE);
        try {
            this.assertContents(this.roadFeatures, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
        }
        finally {
            reader.close();
        }
    }

    void assertContents(SimpleFeature[] expected, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        Assert.assertNotNull(reader);
        Assert.assertNotNull((Object)expected);
        int count = 0;
        try {
            for (SimpleFeature simpleFeature : expected) {
                Assert.assertTrue((boolean)reader.hasNext());
                SimpleFeature feature = (SimpleFeature)reader.next();
                Assert.assertNotNull((Object)feature);
                Assert.assertEquals((Object)simpleFeature, (Object)feature);
                ++count;
            }
            Assert.assertFalse((boolean)reader.hasNext());
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("hasNext() lied to me at:" + count, (Throwable)e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("next() could not understand feature at:" + count, (Throwable)e);
        }
        finally {
            reader.close();
        }
    }
}

