/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.CollectionFeatureReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ArrayFeatureReaderTest {
    private CollectionFeatureReader arrayReader;
    private CollectionFeatureReader collectionReader;
    private CollectionFeatureReader featureCollectionReader;
    private SimpleFeatureType type;
    private SimpleFeature[] features;

    @Before
    public void setUp() throws Exception {
        this.type = DataUtilities.createType((String)"TestType", (String)"geom:Geometry");
        this.features = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f1"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f2"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f3"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f4"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f5"), SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{null}, (String)"f6")};
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        List<SimpleFeature> list = Arrays.asList(this.features);
        collection.addAll(list);
        this.arrayReader = new CollectionFeatureReader(this.features);
        this.collectionReader = new CollectionFeatureReader(list, this.type);
        this.featureCollectionReader = new CollectionFeatureReader((SimpleFeatureCollection)collection, this.type);
    }

    @Test
    public void testGetFeatureType() {
        Assert.assertEquals((Object)this.type, (Object)this.arrayReader.getFeatureType());
        Assert.assertEquals((Object)this.type, (Object)this.collectionReader.getFeatureType());
        Assert.assertEquals((Object)this.type, (Object)this.featureCollectionReader.getFeatureType());
    }

    @Test
    public void testNext() throws Exception {
        Assert.assertEquals((Object)this.features[0], (Object)this.arrayReader.next());
        Assert.assertEquals((Object)this.features[1], (Object)this.arrayReader.next());
        Assert.assertEquals((Object)this.features[2], (Object)this.arrayReader.next());
        Assert.assertEquals((Object)this.features[3], (Object)this.arrayReader.next());
        Assert.assertEquals((Object)this.features[4], (Object)this.arrayReader.next());
        Assert.assertEquals((Object)this.features[5], (Object)this.arrayReader.next());
        Assert.assertEquals((Object)this.features[0], (Object)this.collectionReader.next());
        Assert.assertEquals((Object)this.features[1], (Object)this.collectionReader.next());
        Assert.assertEquals((Object)this.features[2], (Object)this.collectionReader.next());
        Assert.assertEquals((Object)this.features[3], (Object)this.collectionReader.next());
        Assert.assertEquals((Object)this.features[4], (Object)this.collectionReader.next());
        Assert.assertEquals((Object)this.features[5], (Object)this.collectionReader.next());
        Assert.assertEquals((Object)this.features[0], (Object)this.featureCollectionReader.next());
        Assert.assertEquals((Object)this.features[1], (Object)this.featureCollectionReader.next());
        Assert.assertEquals((Object)this.features[2], (Object)this.featureCollectionReader.next());
        Assert.assertEquals((Object)this.features[3], (Object)this.featureCollectionReader.next());
        Assert.assertEquals((Object)this.features[4], (Object)this.featureCollectionReader.next());
        Assert.assertEquals((Object)this.features[5], (Object)this.featureCollectionReader.next());
    }

    @Test
    public void testHasNext() throws Exception {
        this.testHasNext((FeatureReader<SimpleFeatureType, SimpleFeature>)this.arrayReader);
        this.testHasNext((FeatureReader<SimpleFeatureType, SimpleFeature>)this.collectionReader);
        this.testHasNext((FeatureReader<SimpleFeatureType, SimpleFeature>)this.featureCollectionReader);
    }

    private void testHasNext(FeatureReader<SimpleFeatureType, SimpleFeature> arrayReader) throws IOException, IllegalAttributeException {
        Assert.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        Assert.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        Assert.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        Assert.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        Assert.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        Assert.assertTrue((boolean)arrayReader.hasNext());
        arrayReader.next();
        Assert.assertFalse((boolean)arrayReader.hasNext());
    }

    @Test
    public void testClose() throws Exception {
        this.arrayReader.close();
        Assert.assertFalse((boolean)this.arrayReader.hasNext());
        try {
            this.arrayReader.next();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.collectionReader.close();
        Assert.assertFalse((boolean)this.collectionReader.hasNext());
        try {
            this.collectionReader.next();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.featureCollectionReader.close();
        Assert.assertFalse((boolean)this.featureCollectionReader.hasNext());
        try {
            this.featureCollectionReader.next();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

