/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.GeocentricTransform;
import org.geotools.renderer.crs.GeographicOffsetWrapper;
import org.geotools.renderer.crs.GeometryDimensionCollector;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.precision.EnhancedPrecisionOp;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ProjectionHandler {
    public static final String ADVANCED_PROJECTION_DENSIFY = "advancedProjectionDensify";
    protected static final double EPS = 1.0E-6;
    protected static final Logger LOGGER = Logging.getLogger(ProjectionHandler.class);
    protected ReferencedEnvelope renderingEnvelope;
    protected final ReferencedEnvelope validAreaBounds;
    protected final Geometry validArea;
    protected final PreparedGeometry validaAreaTester;
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    protected double datelineX = Double.NaN;
    protected double targetHalfCircle = Double.NaN;
    protected boolean queryAcrossDateline;
    protected SingleCRS geometryCRS;
    protected boolean noReprojection;
    protected double densify = 0.0;
    Map<String, Object> projectionParameters;

    public ProjectionHandler(CoordinateReferenceSystem sourceCRS, Envelope validAreaBounds, ReferencedEnvelope renderingEnvelope) throws FactoryException {
        this.renderingEnvelope = renderingEnvelope;
        this.sourceCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)sourceCRS);
        this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
        this.validAreaBounds = validAreaBounds != null ? new ReferencedEnvelope(validAreaBounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84) : null;
        this.validArea = null;
        this.validaAreaTester = null;
        this.checkReprojection();
    }

    public ProjectionHandler(CoordinateReferenceSystem sourceCRS, Geometry validArea, ReferencedEnvelope renderingEnvelope) throws FactoryException {
        this(sourceCRS, validArea, renderingEnvelope, false);
    }

    public ProjectionHandler(CoordinateReferenceSystem sourceCRS, Geometry validArea, ReferencedEnvelope renderingEnvelope, boolean keepGeometry) throws FactoryException {
        if (validArea.isRectangle() && !keepGeometry) {
            this.renderingEnvelope = renderingEnvelope;
            this.sourceCRS = sourceCRS;
            this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            this.validAreaBounds = new ReferencedEnvelope(validArea.getEnvelopeInternal(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            this.validArea = null;
            this.validaAreaTester = null;
        } else {
            this.renderingEnvelope = renderingEnvelope;
            this.sourceCRS = sourceCRS;
            this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            this.validAreaBounds = new ReferencedEnvelope(validArea.getEnvelopeInternal(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            this.validArea = validArea;
            this.validaAreaTester = PreparedGeometryFactory.prepare((Geometry)validArea);
        }
        this.checkReprojection();
    }

    public void setProjectionParameters(Map<String, Object> projectionParameters) {
        if (projectionParameters.containsKey(ADVANCED_PROJECTION_DENSIFY)) {
            this.densify = (Double)projectionParameters.get(ADVANCED_PROJECTION_DENSIFY);
        }
        this.projectionParameters = projectionParameters;
    }

    private void checkReprojection() throws FactoryException {
        this.geometryCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.sourceCRS);
        CoordinateReferenceSystem renderingCRS = this.renderingEnvelope.getCoordinateReferenceSystem();
        try {
            this.noReprojection = !CRS.isTransformationRequired((CoordinateReferenceSystem)this.geometryCRS, (CoordinateReferenceSystem)renderingCRS);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine is reprojection is required, assumming it is", e);
            this.noReprojection = false;
        }
        this.queryAcrossDateline = !CRS.equalsIgnoreMetadata((Object)this.sourceCRS, (Object)this.renderingEnvelope.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope getRenderingEnvelope() {
        return this.renderingEnvelope;
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
        CoordinateReferenceSystem renderingCRS = this.renderingEnvelope.getCoordinateReferenceSystem();
        if (!this.queryAcrossDateline) {
            ReferencedEnvelope envelope = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS);
            if (envelope == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(envelope);
        }
        if (renderingCRS instanceof GeographicCRS && !CRS.equalsIgnoreMetadata((Object)renderingCRS, (Object)DefaultGeographicCRS.WGS84)) {
            ReferencedEnvelope re = this.renderingEnvelope;
            ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
            this.addTransformedEnvelope(re, envelopes);
            if (CRS.getAxisOrder((CoordinateReferenceSystem)renderingCRS) == CRS.AxisOrder.NORTH_EAST) {
                if (re.getMinY() >= -180.0 && re.getMaxY() <= 180.0) {
                    return envelopes;
                }
                this.adjustEnvelope(re, envelopes, true);
            } else {
                if (re.getMinX() >= -180.0 && re.getMaxX() <= 180.0) {
                    ReferencedEnvelope envelope = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS);
                    if (envelope == null) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(envelope);
                }
                this.adjustEnvelope(re, envelopes, true);
            }
            this.mergeEnvelopes(envelopes);
            return envelopes;
        }
        if (!Double.isNaN(this.datelineX) && this.renderingEnvelope.getMinX() < this.datelineX && this.renderingEnvelope.getMaxX() > this.datelineX && this.renderingEnvelope.getWidth() < this.targetHalfCircle) {
            ReferencedEnvelope re2;
            ReferencedEnvelope tx2;
            double minX = this.renderingEnvelope.getMinX();
            double minY = this.renderingEnvelope.getMinY();
            double maxX = this.renderingEnvelope.getMaxX();
            double maxY = this.renderingEnvelope.getMaxY();
            ReferencedEnvelope re1 = new ReferencedEnvelope(minX, this.datelineX - 1.0E-6, minY, maxY, renderingCRS);
            ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
            ReferencedEnvelope tx1 = this.transformEnvelope(re1, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (tx1 != null) {
                tx1.expandToInclude(180.0, tx1.getMinY());
                this.addTransformedEnvelope(tx1, result);
            }
            if ((tx2 = this.transformEnvelope(re2 = new ReferencedEnvelope(this.datelineX + 1.0E-6, maxX, minY, maxY, renderingCRS), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84)) != null) {
                if (tx2.getMinX() > 180.0) {
                    tx2.translate(-360.0, 0.0);
                }
                tx2.expandToInclude(-180.0, tx1.getMinY());
                this.addTransformedEnvelope(tx2, result);
            }
            this.mergeEnvelopes(result);
            return result;
        }
        return this.getSourceEnvelopes(this.renderingEnvelope);
    }

    private void addTransformedEnvelope(ReferencedEnvelope re, List<ReferencedEnvelope> envelopes) throws TransformException, FactoryException {
        ReferencedEnvelope transformed = this.transformEnvelope(re, this.sourceCRS);
        if (transformed != null) {
            envelopes.add(transformed);
        }
    }

    protected List<ReferencedEnvelope> getSourceEnvelopes(ReferencedEnvelope renderingEnvelope) throws TransformException, FactoryException {
        ReferencedEnvelope re = this.transformEnvelope(renderingEnvelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        if (re == null) {
            return Collections.emptyList();
        }
        if (re.getMinX() >= -180.0 && re.getMaxX() <= 180.0) {
            ReferencedEnvelope result = this.transformEnvelope(renderingEnvelope, this.sourceCRS);
            if (result != null) {
                return Collections.singletonList(result);
            }
            return Collections.emptyList();
        }
        ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
        envelopes.add(re);
        this.adjustEnvelope(re, envelopes, false);
        this.mergeEnvelopes(envelopes);
        this.reprojectEnvelopes(this.sourceCRS, envelopes);
        return envelopes.stream().filter(e -> e != null).collect(Collectors.toList());
    }

    private void adjustEnvelope(ReferencedEnvelope re, List<ReferencedEnvelope> envelopes, boolean transform) throws TransformException, FactoryException {
        CoordinateReferenceSystem crs = re.getCoordinateReferenceSystem();
        boolean isLatLon = CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST;
        double minX = isLatLon ? re.getMinY() : re.getMinX();
        double maxX = isLatLon ? re.getMaxY() : re.getMaxX();
        double minY = isLatLon ? re.getMinX() : re.getMinY();
        double maxY = isLatLon ? re.getMaxX() : re.getMaxY();
        double extent = maxX - minX;
        ArrayList<ReferencedEnvelope> envelopesToBeAdded = new ArrayList<ReferencedEnvelope>();
        if (extent > 360.0) {
            minX = -180.0;
            maxX = 180.0;
            ReferencedEnvelope envelope = new ReferencedEnvelope(isLatLon ? minY : minX, isLatLon ? maxY : maxX, isLatLon ? minX : minY, isLatLon ? maxX : maxY, crs);
            envelopesToBeAdded.add(envelope);
        } else {
            int halfCircles = 0;
            if (minX < -180.0) {
                halfCircles = (int)(Math.abs(minX) / 180.0);
                maxX = (minX += (double)(360 * (halfCircles / 2 + halfCircles % 2))) + extent;
            } else if (minX > 180.0) {
                halfCircles = (int)(minX / 180.0);
                maxX = (minX -= (double)(360 * (halfCircles / 2 + halfCircles % 2))) + extent;
            } else if (maxX < -180.0) {
                halfCircles = (int)(Math.abs(maxX) / 180.0);
                minX = (maxX += (double)(360 * (halfCircles / 2 + halfCircles % 2))) - extent;
            } else if (maxX > 180.0) {
                halfCircles = (int)(Math.abs(maxX) / 180.0);
                minX = (maxX -= (double)(360 * (halfCircles / 2 + halfCircles % 2))) - extent;
            }
            if ((int)(minX / 180.0) < (int)(maxX / 180.0)) {
                double coord4R;
                double coord3R;
                double coord2R;
                double coord1R;
                double coord4L;
                double coord3L;
                double coord2L;
                double coord1L;
                if (minX < -180.0) {
                    coord1L = isLatLon ? minY : -180.0;
                    coord2L = isLatLon ? maxY : Math.min(maxX, 180.0);
                    coord3L = isLatLon ? -180.0 : minY;
                    coord4L = isLatLon ? Math.min(maxX, 180.0) : maxY;
                    coord1R = isLatLon ? minY : minX + 360.0;
                    coord2R = isLatLon ? maxY : 180.0;
                    coord3R = isLatLon ? minX + 360.0 : minY;
                    coord4R = isLatLon ? 180.0 : maxY;
                } else {
                    coord1L = isLatLon ? minY : -180.0;
                    coord2L = isLatLon ? maxY : maxX - 360.0;
                    coord3L = isLatLon ? -180.0 : minY;
                    coord4L = isLatLon ? maxX - 360.0 : maxY;
                    coord1R = isLatLon ? minY : minX;
                    coord2R = isLatLon ? maxY : 180.0;
                    coord3R = isLatLon ? minX : minY;
                    coord4R = isLatLon ? 180.0 : maxY;
                }
                envelopesToBeAdded.add(new ReferencedEnvelope(coord1L, coord2L, coord3L, coord4L, crs));
                envelopesToBeAdded.add(new ReferencedEnvelope(coord1R, coord2R, coord3R, coord4R, crs));
            } else {
                envelopesToBeAdded.add(new ReferencedEnvelope(isLatLon ? minY : minX, isLatLon ? maxY : maxX, isLatLon ? minX : minY, isLatLon ? maxX : maxY, crs));
            }
        }
        for (ReferencedEnvelope env : envelopesToBeAdded) {
            if (transform) {
                this.addTransformedEnvelope(env, envelopes);
                continue;
            }
            envelopes.add(env);
        }
    }

    public ReferencedEnvelope getProjectedEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
        return this.transformEnvelope(envelope, targetCRS);
    }

    protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
        if (CRS.equalsIgnoreMetadata((Object)envelope.getCoordinateReferenceSystem(), (Object)targetCRS)) {
            return envelope;
        }
        try {
            ReferencedEnvelope validAreaInTargetCRS;
            if (this.validAreaBounds != null && (envelope = envelope.intersection(validAreaInTargetCRS = this.validAreaBounds.transform(envelope.getCoordinateReferenceSystem(), true))).isEmpty()) {
                return null;
            }
            ReferencedEnvelope transformed = envelope.transform(targetCRS, true, 10);
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler(new ReferencedEnvelope(targetCRS), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true, this.projectionParameters);
            if (handler == null || handler instanceof WrappingProjectionHandler) {
                return transformed;
            }
            ReferencedEnvelope validAreaBounds = handler.getValidAreaBounds();
            ReferencedEnvelope validArea = validAreaBounds.transform(targetCRS, true);
            ReferencedEnvelope reduced = transformed.intersection(validArea);
            if (reduced.isNull()) {
                return null;
            }
            return reduced;
        }
        catch (Exception e) {
            ReferencedEnvelope validAreaBounds;
            LOGGER.fine("Failed to reproject the envelope " + String.valueOf((Object)envelope) + " to " + String.valueOf(targetCRS) + " trying an area restriction");
            ReferencedEnvelope envWGS84 = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler(new ReferencedEnvelope(targetCRS), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, false);
            if (handler != null && handler.validAreaBounds != null) {
                validAreaBounds = handler.validAreaBounds;
                envWGS84 = envWGS84.intersection(validAreaBounds);
            }
            if ((handler = ProjectionHandlerFinder.getHandler(envelope, envelope.getCoordinateReferenceSystem(), false)) != null && handler.validAreaBounds != null) {
                validAreaBounds = handler.validAreaBounds;
                envWGS84 = envWGS84.intersection(validAreaBounds);
            }
            if (envWGS84.isNull()) {
                return null;
            }
            try {
                return ReferencedEnvelope.reference(envWGS84).transform(targetCRS, true);
            }
            catch (Exception e2) {
                LOGGER.fine("Failed to reproject the restricted envelope " + String.valueOf((Object)envWGS84) + " to " + String.valueOf(targetCRS));
                GeographicBoundingBox bbox = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)targetCRS);
                if (bbox != null) {
                    ReferencedEnvelope restriction = new ReferencedEnvelope(bbox.getEastBoundLongitude(), bbox.getWestBoundLongitude(), bbox.getSouthBoundLatitude(), bbox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    ReferencedEnvelope intersection = envWGS84.intersection(restriction);
                    if (intersection.isNull()) {
                        return null;
                    }
                    try {
                        return ReferencedEnvelope.reference((Envelope)intersection).transform(targetCRS, true);
                    }
                    catch (Exception e22) {
                        LOGGER.fine("Failed to reproject the restricted envelope " + String.valueOf((Object)intersection) + " to " + String.valueOf(targetCRS));
                    }
                }
                throw new TransformException("All attemptsto reproject the envelope " + String.valueOf((Object)envelope) + " to " + String.valueOf(targetCRS) + " failed");
            }
        }
    }

    protected void reprojectEnvelopes(CoordinateReferenceSystem queryCRS, List<ReferencedEnvelope> envelopes) throws TransformException, FactoryException {
        for (int i = 0; i < envelopes.size(); ++i) {
            ReferencedEnvelope envelope = this.transformEnvelope(envelopes.get(i), queryCRS);
            if (envelope == null) continue;
            envelopes.set(i, envelope);
        }
    }

    protected void mergeEnvelopes(List<ReferencedEnvelope> envelopes) {
        boolean merged = true;
        while (merged && envelopes.size() > 1) {
            merged = false;
            for (int i = 0; i < envelopes.size() - 1; ++i) {
                ReferencedEnvelope curr = envelopes.get(i);
                int j = i + 1;
                while (j < envelopes.size()) {
                    ReferencedEnvelope next = envelopes.get(j);
                    if (curr.intersects(next)) {
                        curr.expandToInclude(next);
                        envelopes.remove(j);
                        merged = true;
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    public boolean requiresProcessing(Geometry geometry) {
        if (this.validAreaBounds == null) {
            return false;
        }
        return !this.noReprojection;
    }

    public Geometry preProcess(Geometry geometry) throws TransformException, FactoryException {
        Polygon mask;
        if (this.validAreaBounds == null && this.validArea == null) {
            return this.densify(geometry, true);
        }
        if (this.noReprojection) {
            return this.densify(geometry, false);
        }
        ReferencedEnvelope ge = new ReferencedEnvelope(geometry.getEnvelopeInternal(), (CoordinateReferenceSystem)this.geometryCRS);
        ReferencedEnvelope geWGS84 = ge.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        geWGS84.expandBy(1.0E-6);
        if (this.validArea == null) {
            if (this.validAreaBounds.contains(geWGS84)) {
                return this.densify(geometry, true);
            }
            ReferencedEnvelope envIntWgs84 = new ReferencedEnvelope(this.validAreaBounds.intersection(geWGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (envIntWgs84.getHeight() <= 0.0 || envIntWgs84.getWidth() <= 0.0) {
                ReferencedEnvelope translated;
                if (this.validAreaBounds.contains(180.0, (this.validAreaBounds.getMinY() + this.validAreaBounds.getMaxY()) / 2.0)) {
                    translated = new ReferencedEnvelope(this.validAreaBounds);
                    translated.translate(-360.0, 0.0);
                    if (translated.contains(geWGS84)) {
                        return this.densify(geometry, false);
                    }
                    envIntWgs84 = translated.intersection(geWGS84);
                } else if (this.validAreaBounds.contains(-180.0, (this.validAreaBounds.getMinY() + this.validAreaBounds.getMaxY()) / 2.0)) {
                    translated = new ReferencedEnvelope(this.validAreaBounds);
                    translated.translate(360.0, 0.0);
                    if (translated.contains(geWGS84)) {
                        return this.densify(geometry, false);
                    }
                    envIntWgs84 = translated.intersection(geWGS84);
                }
                if (envIntWgs84.getHeight() <= 0.0 || envIntWgs84.getWidth() <= 0.0) {
                    return null;
                }
            }
            ReferencedEnvelope envInt = envIntWgs84.transform((CoordinateReferenceSystem)this.geometryCRS, true);
            mask = JTS.toGeometry((Envelope)envInt);
        } else {
            if (this.validaAreaTester.contains((Geometry)JTS.toGeometry(geWGS84))) {
                return this.densify(geometry, false);
            }
            ReferencedEnvelope envIntWgs84 = new ReferencedEnvelope(this.validAreaBounds.intersection(geWGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (envIntWgs84.isEmpty()) {
                return null;
            }
            Polygon polyIntWgs84 = JTS.toGeometry(envIntWgs84);
            Geometry maskWgs84 = this.intersect(this.validArea, (Geometry)polyIntWgs84, (CoordinateReferenceSystem)this.geometryCRS);
            if (maskWgs84 == null || maskWgs84.isEmpty()) {
                return null;
            }
            mask = JTS.transform(maskWgs84, CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.geometryCRS));
        }
        return this.densify(this.intersect(geometry, (Geometry)mask, (CoordinateReferenceSystem)this.geometryCRS), false);
    }

    protected Geometry densify(Geometry geometry, boolean validate) {
        if (geometry != null && this.densify > 0.0) {
            try {
                Densifier densifier = new Densifier(geometry);
                densifier.setDistanceTolerance(this.densify);
                densifier.setValidate(validate);
                return densifier.getResultGeometry();
            }
            catch (Throwable t) {
                LOGGER.warning("Cannot densify geometry");
            }
        }
        return geometry;
    }

    protected Geometry intersect(Geometry geometry, Geometry mask, CoordinateReferenceSystem geometryCRS) {
        Geometry result;
        block16: {
            if (geometry instanceof GeometryCollection) {
                int numGeometries = geometry.getNumGeometries();
                if (numGeometries == 1) {
                    geometry = geometry.getGeometryN(0);
                } else {
                    ArrayList<Geometry> elements = new ArrayList<Geometry>();
                    String geometryType = numGeometries > 0 ? geometry.getGeometryN(0).getGeometryType() : null;
                    for (int i = 0; i < numGeometries; ++i) {
                        Geometry intersected;
                        Geometry g = geometry.getGeometryN(i);
                        if (!g.getEnvelopeInternal().intersects(mask.getEnvelopeInternal()) || (intersected = this.intersect(g, mask, geometryCRS)) == null) continue;
                        if (intersected.getGeometryType().equals(geometryType)) {
                            elements.add(intersected);
                            continue;
                        }
                        if (!(intersected instanceof GeometryCollection)) continue;
                        this.addGeometries(elements, (GeometryCollection)intersected, geometryType);
                    }
                    if (elements.isEmpty()) {
                        return null;
                    }
                    if (geometry instanceof MultiPoint) {
                        Point[] array = elements.toArray(new Point[elements.size()]);
                        return geometry.getFactory().createMultiPoint(array);
                    }
                    if (geometry instanceof MultiLineString) {
                        LineString[] array = elements.toArray(new LineString[elements.size()]);
                        return geometry.getFactory().createMultiLineString(array);
                    }
                    if (geometry instanceof MultiPolygon) {
                        Polygon[] array = elements.toArray(new Polygon[elements.size()]);
                        return geometry.getFactory().createMultiPolygon(array);
                    }
                    Geometry[] array = elements.toArray(new Geometry[elements.size()]);
                    return geometry.getFactory().createGeometryCollection(array);
                }
            }
            result = null;
            try {
                result = this.intersection(geometry, mask);
            }
            catch (Exception e1) {
                geometry = geometry.buffer(0.0);
                double precision = CRS.getProjectedCRS((CoordinateReferenceSystem)geometryCRS) != null ? 0.001 : 1.0E-8;
                for (int i = 0; i < 6; ++i) {
                    GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(new PrecisionModel(1.0 / precision));
                    Geometry reduced = reducer.reduce(geometry);
                    try {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Failed to intersect the geometry with the projection area of validity mask, trying a precision reduction approach with a precision of " + precision);
                        }
                        result = this.intersection(reduced, mask);
                        break;
                    }
                    catch (Exception e3) {
                        precision *= 10.0;
                        continue;
                    }
                }
                if (result != null) break block16;
                LOGGER.log(Level.WARNING, "Failed to intersect the geometry with the projection area of validity mask, returning the original geometry: " + String.valueOf(geometry));
                result = geometry;
            }
        }
        GeometryDimensionCollector collector = new GeometryDimensionCollector(geometry.getDimension());
        result.apply((GeometryComponentFilter)collector);
        result = collector.collect();
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    private Geometry intersection(Geometry geometry, Geometry mask) {
        Geometry result = geometry.intersection(mask);
        if (result.isEmpty() && geometry.intersects(mask)) {
            try {
                result = EnhancedPrecisionOp.intersection((Geometry)geometry, (Geometry)mask);
            }
            catch (Exception e2) {
                result = geometry;
            }
        }
        return result;
    }

    public MathTransform getRenderingTransform(MathTransform mt) throws FactoryException {
        ArrayList<MathTransform> elements = new ArrayList<MathTransform>();
        this.accumulateTransforms(mt, elements);
        ArrayList<MathTransform> wrapped = new ArrayList<MathTransform>();
        ArrayList<MathTransform> datumShiftChain = null;
        boolean datumShiftDetected = false;
        for (MathTransform element : elements) {
            if (datumShiftChain != null) {
                datumShiftChain.add(element);
                if (!element.getClass().getName().equals(GeocentricTransform.class.getName() + "$Inverse")) continue;
                datumShiftDetected = true;
                MathTransform combined = this.concatenateTransforms(datumShiftChain);
                GeographicOffsetWrapper wrapper = new GeographicOffsetWrapper(combined);
                wrapped.add(wrapper);
                datumShiftChain = null;
                continue;
            }
            if (element instanceof GeocentricTransform) {
                datumShiftChain = new ArrayList<MathTransform>();
                datumShiftChain.add(element);
                continue;
            }
            wrapped.add(element);
        }
        if (datumShiftDetected) {
            if (datumShiftChain != null) {
                wrapped.addAll(datumShiftChain);
            }
            return this.concatenateTransforms(wrapped);
        }
        return mt;
    }

    protected MathTransform concatenateTransforms(List<MathTransform> datumShiftChain) {
        if (datumShiftChain.size() == 1) {
            return datumShiftChain.get(0);
        }
        MathTransform mt = ConcatenatedTransform.create((MathTransform)datumShiftChain.get(0), (MathTransform)datumShiftChain.get(1));
        for (int i = 2; i < datumShiftChain.size(); ++i) {
            MathTransform curr = datumShiftChain.get(i);
            mt = ConcatenatedTransform.create((MathTransform)mt, (MathTransform)curr);
        }
        return mt;
    }

    protected void accumulateTransforms(MathTransform mt, List<MathTransform> elements) {
        if (mt instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)mt;
            this.accumulateTransforms(ct.transform1, elements);
            this.accumulateTransforms(ct.transform2, elements);
        } else {
            elements.add(mt);
        }
    }

    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        return geometry;
    }

    public ReferencedEnvelope getValidAreaBounds() {
        return this.validAreaBounds;
    }

    public Geometry getValidArea() {
        return this.validArea;
    }

    protected void setCentralMeridian(double centralMeridian) {
        try {
            CoordinateReferenceSystem targetCRS = this.renderingEnvelope.getCoordinateReferenceSystem();
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            double[] src = new double[]{centralMeridian, 0.0, 180.0 + centralMeridian, 0.0};
            double[] dst = new double[4];
            mt.transform(src, 0, dst, 0, 2);
            this.targetHalfCircle = CRS.getAxisOrder((CoordinateReferenceSystem)targetCRS) == CRS.AxisOrder.NORTH_EAST ? Math.abs(dst[3] - dst[1]) : Math.abs(dst[2] - dst[0]);
            if (this.targetHalfCircle <= 0.0) {
                throw new RuntimeException("Computed Earth half circle is 0, what is going on?");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error computing the Earth half circle in the current projection", e);
        }
        this.computeDatelineX();
    }

    protected void computeDatelineX() {
        try {
            double[] ordinates = new double[]{180.0, -80.0, 180.0, 80.0};
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.renderingEnvelope.getCoordinateReferenceSystem());
            mt.transform(ordinates, 0, ordinates, 0, 2);
            this.datelineX = ordinates[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void addGeometries(List<Geometry> geoms, GeometryCollection collection, String geometryType) {
        if (geoms == null) {
            return;
        }
        if (geometryType == null || geometryType.isEmpty()) {
            return;
        }
        if (collection == null || collection.getNumGeometries() <= 0) {
            return;
        }
        int numGeometries = collection.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geo = collection.getGeometryN(i);
            if (geo.getGeometryType().equals(geometryType)) {
                geoms.add(geo);
                continue;
            }
            if (!(geo instanceof GeometryCollection)) continue;
            this.addGeometries(geoms, (GeometryCollection)geo, geometryType);
        }
    }
}

