/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

final class FeatureWriterIterator
implements Iterator<SimpleFeature> {
    FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

    public FeatureWriterIterator(FeatureWriter<SimpleFeatureType, SimpleFeature> writer) {
        this.writer = writer;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.writer == null) {
                return false;
            }
            this.writer.write();
            if (this.writer.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (IOException e) {
            this.close();
            return false;
        }
    }

    @Override
    public SimpleFeature next() {
        if (this.writer == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        try {
            return this.writer.next();
        }
        catch (IOException io) {
            NoSuchElementException problem = new NoSuchElementException("Could not obtain the next feature:" + String.valueOf(io));
            problem.initCause(io);
            throw problem;
        }
    }

    @Override
    public void remove() {
        try {
            this.writer.remove();
        }
        catch (IOException problem) {
            throw (IllegalStateException)new IllegalStateException("Could not remove feature").initCause(problem);
        }
    }

    void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
    }
}

