/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.RenderingHints;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.geotools.data.ALLQuery;
import org.geotools.data.FIDSQuery;
import org.geotools.data.Join;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.factory.Hints;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.ResourceId;
import org.opengis.filter.identity.Version;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Query {
    public static Hints.Key INCLUDE_MANDATORY_PROPS = new Hints.Key(Boolean.class);
    public static final URI NO_NAMESPACE = null;
    public static final int DEFAULT_MAX = Integer.MAX_VALUE;
    public static final Query ALL = new ALLQuery();
    public static final Query FIDS = new FIDSQuery();
    public static final String[] NO_NAMES = new String[0];
    public static final String[] ALL_NAMES = null;
    public static final List<PropertyName> NO_PROPERTIES = Collections.emptyList();
    public static final List<PropertyName> ALL_PROPERTIES = null;
    protected List<PropertyName> properties;
    protected int maxFeatures = Integer.MAX_VALUE;
    protected Integer startIndex = null;
    protected Filter filter = Filter.INCLUDE;
    protected String typeName;
    protected String alias;
    protected URI namespace = NO_NAMESPACE;
    protected String handle;
    protected CoordinateReferenceSystem coordinateSystem;
    protected CoordinateReferenceSystem coordinateSystemReproject;
    protected SortBy[] sortBy;
    protected String version;
    protected Hints hints;
    protected List<Join> joins = new ArrayList<Join>();

    public Query() {
    }

    public Query(String typeName) {
        this(typeName, (Filter)Filter.INCLUDE);
    }

    public Query(String typeName, Filter filter) {
        this(typeName, filter, ALL_NAMES);
    }

    public Query(String typeName, Filter filter, String ... properties) {
        this(typeName, null, filter, Integer.MAX_VALUE, properties, null);
    }

    public Query(String typeName, Filter filter, List<PropertyName> properties) {
        this(typeName, null, filter, Integer.MAX_VALUE, properties, null);
    }

    public Query(String typeName, Filter filter, int maxFeatures, String[] propNames, String handle) {
        this(typeName, null, filter, maxFeatures, propNames, handle);
    }

    public Query(String typeName, Filter filter, int maxFeatures, List<PropertyName> properties, String handle) {
        this(typeName, null, filter, maxFeatures, properties, handle);
    }

    public Query(String typeName, URI namespace, Filter filter, int maxFeatures, String[] propNames, String handle) {
        this.typeName = typeName;
        this.filter = filter;
        this.namespace = namespace;
        this.maxFeatures = maxFeatures;
        this.handle = handle;
        this.setPropertyNames(propNames);
    }

    public Query(String typeName, URI namespace, Filter filter, int maxFeatures, List<PropertyName> properties, String handle) {
        this.typeName = typeName;
        this.filter = filter;
        this.namespace = namespace;
        this.maxFeatures = maxFeatures;
        this.handle = handle;
        this.properties = properties == null ? null : new ArrayList<PropertyName>(properties);
    }

    public Query(Query query) {
        this(query.getTypeName(), query.getNamespace(), query.getFilter(), query.getMaxFeatures(), query.getProperties(), query.getHandle());
        this.sortBy = query.getSortBy();
        this.coordinateSystem = query.getCoordinateSystem();
        this.coordinateSystemReproject = query.getCoordinateSystemReproject();
        this.version = query.getVersion();
        this.hints = query.getHints() != null ? new Hints((RenderingHints)query.getHints()) : null;
        this.startIndex = query.getStartIndex();
        this.alias = query.getAlias();
        this.joins = new ArrayList<Join>();
        for (Join j : query.getJoins()) {
            this.joins.add(new Join(j));
        }
    }

    public String[] getPropertyNames() {
        if (this.properties == null) {
            return null;
        }
        String[] propertyNames = new String[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            String xpath;
            PropertyName propertyName = this.properties.get(i);
            if (propertyName == null) continue;
            propertyNames[i] = xpath = propertyName.getPropertyName();
        }
        return propertyNames;
    }

    public void setPropertyNames(String ... propNames) {
        if (propNames == null) {
            this.properties = ALL_PROPERTIES;
            return;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        this.properties = new ArrayList<PropertyName>(propNames.length);
        for (String xpath : propNames) {
            if (xpath == null) continue;
            this.properties.add(ff.property(xpath));
        }
    }

    public List<PropertyName> getProperties() {
        if (this.properties == ALL_PROPERTIES) {
            return ALL_PROPERTIES;
        }
        return Collections.unmodifiableList(this.properties);
    }

    public void setProperties(List<PropertyName> propNames) {
        this.properties = propNames == ALL_PROPERTIES ? ALL_PROPERTIES : new ArrayList<PropertyName>(propNames);
    }

    public void setPropertyNames(List<String> propNames) {
        if (propNames == null) {
            this.properties = ALL_PROPERTIES;
            return;
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        this.properties = new ArrayList<PropertyName>(propNames.size());
        for (String xpath : propNames) {
            if (xpath == null) continue;
            this.properties.add(ff.property(xpath));
        }
    }

    public boolean retrieveAllProperties() {
        return this.properties == null;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public boolean isMaxFeaturesUnlimited() {
        return this.maxFeatures < 0 || this.maxFeatures == Integer.MAX_VALUE;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        if (startIndex != null && startIndex < 0) {
            throw new IllegalArgumentException("startIndex shall be a positive integer: " + startIndex);
        }
        this.startIndex = startIndex;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public void setNamespace(URI namespace) {
        this.namespace = namespace;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(int index) {
        this.version = String.valueOf(index);
    }

    public void setVersion(Date date) {
        this.version = date == null ? null : "date:" + String.valueOf(date);
    }

    public void setVersion(Version.Action action) {
        this.version = action == null ? null : action.name();
    }

    public void setVersion(Date startTime, Date endTime) {
        this.version = startTime == null || endTime == null ? null : "start:" + String.valueOf(startTime) + " end:" + String.valueOf(endTime);
    }

    public void setVersion(ResourceId history) {
        if (history.getStartTime() != null && history.getEndTime() != null) {
            this.setVersion(history.getStartTime(), history.getEndTime());
        } else if (history.getVersion() != null) {
            Version ver = history.getVersion();
            if (ver.isVersionAction()) {
                this.setVersion(ver.getVersionAction());
            } else if (ver.isDateTime()) {
                this.setVersion(ver.getDateTime());
            } else if (ver.isIndex()) {
                this.setVersion(ver.getIndex());
            }
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public CoordinateReferenceSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(CoordinateReferenceSystem system) {
        this.coordinateSystem = system;
    }

    public CoordinateReferenceSystem getCoordinateSystemReproject() {
        return this.coordinateSystemReproject;
    }

    public void setCoordinateSystemReproject(CoordinateReferenceSystem system) {
        this.coordinateSystemReproject = system;
    }

    public SortBy[] getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortBy ... sortBy) {
        this.sortBy = sortBy;
    }

    public Hints getHints() {
        if (this.hints == null) {
            this.hints = new Hints();
        }
        return this.hints;
    }

    public void setHints(Hints hints) {
        this.hints = hints;
    }

    public int hashCode() {
        String[] n = this.getPropertyNames();
        return (n == null ? -1 : (n.length == 0 ? 0 : n.length | n[0].hashCode())) | this.getMaxFeatures() | (this.getFilter() == null ? 0 : this.getFilter().hashCode()) | (this.getTypeName() == null ? 0 : this.getTypeName().hashCode()) | (this.getVersion() == null ? 0 : this.getVersion().hashCode()) | (this.getCoordinateSystem() == null ? 0 : this.getCoordinateSystem().hashCode()) | (this.getCoordinateSystemReproject() == null ? 0 : this.getCoordinateSystemReproject().hashCode()) | (this.getStartIndex() == null ? 0 : this.getStartIndex());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Query)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Query other = (Query)obj;
        return Arrays.equals(this.getPropertyNames(), other.getPropertyNames()) && this.retrieveAllProperties() == other.retrieveAllProperties() && this.getMaxFeatures() == other.getMaxFeatures() && (this.getFilter() == null ? other.getFilter() == null : this.getFilter().equals(other.getFilter())) && (this.getTypeName() == null ? other.getTypeName() == null : this.getTypeName().equals(other.getTypeName())) && (this.getVersion() == null ? other.getVersion() == null : this.getVersion().equals(other.getVersion())) && (this.getCoordinateSystem() == null ? other.getCoordinateSystem() == null : this.getCoordinateSystem().equals(other.getCoordinateSystem())) && (this.getCoordinateSystemReproject() == null ? other.getCoordinateSystemReproject() == null : this.getCoordinateSystemReproject().equals(other.getCoordinateSystemReproject())) && this.isSortEquals(other) && Objects.equals(this.getStartIndex(), other.getStartIndex()) && (this.getHints() == null ? other.getHints() == null : this.getHints().equals((Object)other.getHints()));
    }

    private boolean isSortEquals(Query other) {
        if (this.sortBy == null || this.sortBy.length == 0) {
            return other.getSortBy() == null || other.getSortBy().length == 0;
        }
        return Arrays.equals(this.getSortBy(), other.getSortBy());
    }

    public String toString() {
        int i;
        StringBuffer returnString = new StringBuffer("Query:");
        if (this.handle != null) {
            returnString.append(" [" + this.handle + "]");
        }
        returnString.append("\n   feature type: " + this.typeName);
        if (this.filter != null) {
            returnString.append("\n   filter: " + this.filter.toString());
        }
        returnString.append("\n   [properties: ");
        if (this.properties == null || this.properties.isEmpty()) {
            returnString.append(" ALL ]");
        } else {
            for (i = 0; i < this.properties.size(); ++i) {
                returnString.append(this.properties.get(i));
                if (i >= this.properties.size() - 1) continue;
                returnString.append(", ");
            }
            returnString.append("]");
        }
        if (this.sortBy != null && this.sortBy.length > 0) {
            returnString.append("\n   [sort by: ");
            for (i = 0; i < this.sortBy.length; ++i) {
                SortBy sb = this.sortBy[i];
                if (sb == SortBy.NATURAL_ORDER) {
                    returnString.append("NATURAL");
                } else if (sb == SortBy.REVERSE_ORDER) {
                    returnString.append("REVERSE");
                } else {
                    returnString.append(sb.getPropertyName().getPropertyName());
                    returnString.append(" ");
                    returnString.append(sb.getSortOrder().name());
                }
                if (i >= this.sortBy.length - 1) continue;
                returnString.append(", ");
            }
            returnString.append("]");
        }
        return returnString.toString();
    }

    public List<Join> getJoins() {
        return this.joins;
    }
}

