/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPosition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;
import org.opengis.temporal.TemporalPrimitive;

public class DefaultInstantTest {
    private Instant instant1;
    private Instant instant2;
    private Position position1;
    private Position position2;
    private Calendar cal = Calendar.getInstance();

    @Before
    public void setUp() {
        this.cal.set(2000, 1, 1);
        this.position1 = new DefaultPosition(this.cal.getTime());
        this.cal.set(1998, 1, 1);
        this.position2 = new DefaultPosition(this.cal.getTime());
        this.instant1 = new DefaultInstant(this.position1);
        this.instant2 = new DefaultInstant(this.position2);
    }

    @After
    public void tearDown() {
        this.instant1 = null;
        this.instant2 = null;
        this.position1 = null;
        this.position2 = null;
    }

    @Test
    public void testGetPosition() {
        Position result = this.instant1.getPosition();
        Assert.assertNotEquals((Object)this.instant2.getPosition(), (Object)result);
    }

    @Test
    public void testGetBegunBy() {
        Collection result = this.instant1.getBegunBy();
        Assert.assertEquals((Object)this.instant2.getBegunBy(), (Object)result);
    }

    @Test
    public void testGetEndedBy() {
        Collection result = this.instant1.getEndedBy();
        Assert.assertEquals((Object)this.instant2.getEndedBy(), (Object)result);
    }

    @Test
    public void testSetPosition() {
        Position result = this.instant1.getPosition();
        DefaultPosition position = new DefaultPosition(new Date());
        ((DefaultInstant)this.instant1).setPosition((Position)position);
        Assert.assertNotEquals((Object)this.instant1.getPosition(), (Object)result);
    }

    @Test
    public void testSetBegunBy() {
        Collection result = this.instant1.getBegunBy();
        Collection begunby = null;
        ((DefaultInstant)this.instant1).setBegunBy(begunby);
        Assert.assertEquals((Object)this.instant1.getBegunBy(), (Object)result);
    }

    @Test
    public void testCompare() {
        Assert.assertEquals((long)1L, (long)((DefaultInstant)this.instant1).compareTo((TemporalPrimitive)this.instant2));
        Assert.assertEquals((long)0L, (long)((DefaultInstant)this.instant1).compareTo((TemporalPrimitive)this.instant1));
        Assert.assertEquals((long)0L, (long)((DefaultInstant)this.instant2).compareTo((TemporalPrimitive)this.instant2));
    }

    @Test
    public void testSetEndBy() {
        Collection result = this.instant1.getEndedBy();
        Collection endedby = null;
        ((DefaultInstant)this.instant1).setEndBy(endedby);
        Assert.assertEquals((Object)this.instant1.getEndedBy(), (Object)result);
    }

    @Test
    public void testEquals() {
        this.cal.set(2000, 1, 1);
        Assert.assertNotEquals(null, (Object)this.instant1);
        Assert.assertEquals((long)this.cal.getTime().getTime(), (long)this.instant1.getPosition().getDate().getTime());
        Assert.assertNotEquals((Object)this.instant1, (Object)this.instant2);
    }

    @Test
    public void testHashCode() {
        int result = this.instant1.hashCode();
        Assert.assertNotEquals((long)this.instant2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.instant1.toString();
        Assert.assertNotEquals((Object)this.instant2.toString(), (Object)result);
    }
}

