/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.awt.Color;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.measure.Units;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizerImpl;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.LabelPlacement;
import si.uom.SI;
import systems.uom.common.USCustomary;

public class UomRescaleStyleVisitorTest {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

    @Test
    public void testConstructorOK() {
        try {
            new UomRescaleStyleVisitor(1.0);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    @Test
    public void testConstructorFail() {
        try {
            new UomRescaleStyleVisitor(-1.0);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"Should throw IllegalArgumentException.");
    }

    protected double computeExpectedRescaleSize(double size, double scaleMetersToPixel, Unit<Length> uom) {
        double expectedRescaledSize = size;
        if (uom != null) {
            double scaleUomToMeters = 1.0;
            if (uom.equals((Object)USCustomary.FOOT)) {
                scaleUomToMeters *= 0.3048006096012;
            }
            if (!uom.equals((Object)Units.PIXEL)) {
                expectedRescaledSize *= scaleUomToMeters * scaleMetersToPixel;
            }
        }
        return expectedRescaledSize;
    }

    protected void visitPointSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            PointSymbolizerImpl pointSymb = (PointSymbolizerImpl)styleBuilder.createPointSymbolizer();
            pointSymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            pointSymb.getGraphic().setSize((Expression)filterFactory.literal(size));
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            pointSymb.accept((StyleVisitor)visitor);
            PointSymbolizer rescaledPointSymb = (PointSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledPointSymb.getGraphic().getSize().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledPointSymb, (Object)pointSymb);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    protected void visitLineSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer();
            lineSymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            lineSymb.getStroke().setWidth((Expression)filterFactory.literal(size));
            lineSymb.setPerpendicularOffset((Expression)filterFactory.literal(size));
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledLineSymb.getStroke().getWidth().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
            Assert.assertEquals((double)expectedRescaledSize, (double)((Double)rescaledLineSymb.getPerpendicularOffset().evaluate(null, Double.class)), (double)0.1);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    protected void visitPolygonSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            int expectedGraphicMargin = (int)this.computeExpectedRescaleSize(15.0, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            PolygonSymbolizerImpl polySymb = (PolygonSymbolizerImpl)styleBuilder.createPolygonSymbolizer();
            polySymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            polySymb.getStroke().setWidth((Expression)filterFactory.literal(size));
            polySymb.getOptions().put("graphic-margin", "15");
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            polySymb.accept((StyleVisitor)visitor);
            PolygonSymbolizer rescaledPolySymb = (PolygonSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledPolySymb.getStroke().getWidth().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledPolySymb, (Object)polySymb);
            String[] splitted = ((String)rescaledPolySymb.getOptions().get("graphic-margin")).split("\\s+");
            int rescaledGraphicMargin = (Integer)Converters.convert((Object)splitted[0], Integer.class);
            Assert.assertEquals((long)expectedGraphicMargin, (long)rescaledGraphicMargin);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    protected void visitTextSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            int fontSize = 100;
            double displacementX = 13.0;
            double displacementY = 17.0;
            int maxDisplacement = 10;
            double expectedRescaledFontSize = this.computeExpectedRescaleSize(fontSize, scaleMetersToPixel, uom);
            double expectedRescaledDisplacementXSize = this.computeExpectedRescaleSize(displacementX, scaleMetersToPixel, uom);
            double expectedRescaledDisplacementYSize = this.computeExpectedRescaleSize(displacementY, scaleMetersToPixel, uom);
            int expectedMaxDisplacement = (int)this.computeExpectedRescaleSize(maxDisplacement, scaleMetersToPixel, uom);
            int expectedGraphicMargin1 = (int)this.computeExpectedRescaleSize(maxDisplacement, scaleMetersToPixel, uom);
            int expectedGraphicMargin2 = (int)this.computeExpectedRescaleSize(maxDisplacement * 2, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            TextSymbolizerImpl textSymb = (TextSymbolizerImpl)styleBuilder.createTextSymbolizer();
            textSymb.setUnitOfMeasure(uom);
            Font font = styleBuilder.createFont(new java.awt.Font("Verdana", 0, fontSize));
            textSymb.setFont((org.opengis.style.Font)font);
            PointPlacement placement = styleBuilder.createPointPlacement(0.3, 0.3, displacementX, displacementY, 10.0);
            textSymb.setLabelPlacement((LabelPlacement)placement);
            textSymb.getOptions().put("maxDisplacement", String.valueOf(maxDisplacement));
            textSymb.getOptions().put("graphic-margin", maxDisplacement + " " + maxDisplacement * 2);
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            textSymb.accept((StyleVisitor)visitor);
            TextSymbolizer rescaledTextSymb = (TextSymbolizer)visitor.getCopy();
            double rescaledFontSize = (Double)rescaledTextSymb.getFont().getSize().evaluate(null, Double.class);
            PointPlacement rescaledPlacement = (PointPlacement)rescaledTextSymb.getLabelPlacement();
            double rescaledDisplacementXSize = (Double)rescaledPlacement.getDisplacement().getDisplacementX().evaluate(null, Double.class);
            double rescaledDisplacementYSize = (Double)rescaledPlacement.getDisplacement().getDisplacementY().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledFontSize), (long)Math.round(rescaledFontSize));
            Assert.assertEquals((long)Math.round(expectedRescaledDisplacementXSize), (long)Math.round(rescaledDisplacementXSize));
            Assert.assertEquals((long)Math.round(expectedRescaledDisplacementYSize), (long)Math.round(rescaledDisplacementYSize));
            Assert.assertNotSame((Object)rescaledTextSymb, (Object)textSymb);
            Map options = rescaledTextSymb.getOptions();
            int rescaledMaxDisplacement = (Integer)Converters.convert(options.get("maxDisplacement"), Integer.class);
            Assert.assertEquals((long)rescaledMaxDisplacement, (long)expectedMaxDisplacement);
            String[] splitted = ((String)options.get("graphic-margin")).split("\\s+");
            int rescaledGraphicMargin1 = (Integer)Converters.convert((Object)splitted[0], Integer.class);
            int rescaledGraphicMargin2 = (Integer)Converters.convert((Object)splitted[1], Integer.class);
            Assert.assertEquals((long)expectedGraphicMargin1, (long)rescaledGraphicMargin1);
            Assert.assertEquals((long)expectedGraphicMargin2, (long)rescaledGraphicMargin2);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    protected void visitLineSymbolizerTestDynamicDashArray(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            double size = 1.0;
            double expectedRescaledSize = Math.floor(this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom) * 10000.0) / 10000.0;
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            Function func = filterFactory.function("listMultiply", new Expression[]{filterFactory.literal(expectedRescaledSize), filterFactory.literal((Object)"5 10")});
            String expectedDashArray = (String)func.evaluate(null);
            StyleBuilder styleBuilder = new StyleBuilder();
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer();
            lineSymb.setUnitOfMeasure(uom);
            lineSymb.getStroke().setDashArray(Arrays.asList(filterFactory.literal((Object)"5.0 10.0")));
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            String rescaledDynamicDashArray = (String)((Expression)rescaledLineSymb.getStroke().dashArray().get(0)).evaluate(null);
            Assert.assertEquals((Object)expectedDashArray, (Object)rescaledDynamicDashArray);
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    @Test
    public void testVisitPointSymbolizer_ScalePixelNull() {
        this.visitPointSymbolizerTest(10.0, null);
    }

    @Test
    public void testVisitPointSymbolizer_ScalePixelExplicit() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)Units.PIXEL);
    }

    @Test
    public void testVisitPointSymbolizer_ScaleMeter1() {
        this.visitPointSymbolizerTest(1.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitPointSymbolizer_ScaleMeter10() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitPointSymbolizer_ScaleFoot1() {
        this.visitPointSymbolizerTest(1.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitPointSymbolizer_ScaleFoot10() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitLineSymbolizer_ScalePixelNull() {
        this.visitLineSymbolizerTest(10.0, null);
    }

    @Test
    public void testVisitLineSymbolizer_ScalePixelExplicit() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)Units.PIXEL);
    }

    @Test
    public void testVisitLineSymbolizer_ScaleMeter1() {
        this.visitLineSymbolizerTest(1.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitLineSymbolizer_ScaleMeter10() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitLineSymbolizer_ScaleFoot1() {
        this.visitLineSymbolizerTest(1.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitLineSymbolizer_ScaleFoot10() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitLineSymbolizerDynamicDashArray_ScalePixelNull() {
        this.visitLineSymbolizerTestDynamicDashArray(10.0, null);
    }

    @Test
    public void testVisitLineSymbolizerDynamicDashArray_ScalePixelExplicit() {
        this.visitLineSymbolizerTestDynamicDashArray(10.0, (Unit<Length>)Units.PIXEL);
    }

    @Test
    public void testVisitLineSymbolizerDynamicDashArray_ScaleMeter1() {
        this.visitLineSymbolizerTestDynamicDashArray(1.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitLineSymbolizerDynamicDashArray_ScaleMeter10() {
        this.visitLineSymbolizerTestDynamicDashArray(10.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitLineSymbolizerDynamicDashArray_ScaleFoot1() {
        this.visitLineSymbolizerTestDynamicDashArray(1.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitLineSymbolizerDynamicDashArray_ScaleFoot10() {
        this.visitLineSymbolizerTestDynamicDashArray(10.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitPolygonSymbolizer_ScalePixelNull() {
        this.visitPolygonSymbolizerTest(10.0, null);
    }

    @Test
    public void testVisitPolygonSymbolizer_ScalePixelExplicit() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)Units.PIXEL);
    }

    @Test
    public void testVisitPolygonSymbolizer_ScaleMeter1() {
        this.visitPolygonSymbolizerTest(1.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitPolygonSymbolizer_ScaleMeter10() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitPolygonSymbolizer_ScaleFoot1() {
        this.visitPolygonSymbolizerTest(1.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitPolygonSymbolizer_ScaleFoot10() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitTextSymbolizer_ScalePixelNull() {
        this.visitTextSymbolizerTest(10.0, null);
    }

    @Test
    public void testVisitTextSymbolizer_ScalePixelExplicit() {
        this.visitTextSymbolizerTest(10.0, (Unit<Length>)Units.PIXEL);
    }

    @Test
    public void testVisitTextSymbolizer_ScaleMeter1() {
        this.visitTextSymbolizerTest(1.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitTextSymbolizer_ScaleMeter10() {
        this.visitTextSymbolizerTest(10.0, (Unit<Length>)SI.METRE);
    }

    @Test
    public void testVisitTextSymbolizer_ScaleFoot1() {
        this.visitTextSymbolizerTest(1.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitTextSymbolizer_ScaleFoot10() {
        this.visitTextSymbolizerTest(10.0, (Unit<Length>)USCustomary.FOOT);
    }

    @Test
    public void testVisitLineSymbolizer_NullStroke() {
        try {
            StyleBuilder styleBuilder = new StyleBuilder();
            Stroke stroke = null;
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer(stroke);
            lineSymb.setUnitOfMeasure(SI.METRE);
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(10.0);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            Assert.assertNull((Object)rescaledLineSymb.getStroke());
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    @Test
    public void testVisitPolygonSymbolizer_NullStroke() {
        try {
            StyleBuilder styleBuilder = new StyleBuilder();
            Fill fill = styleBuilder.createFill(Color.RED);
            PolygonSymbolizerImpl polySymb = (PolygonSymbolizerImpl)styleBuilder.createPolygonSymbolizer(null, fill);
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(10.0);
            polySymb.accept((StyleVisitor)visitor);
            PolygonSymbolizer rescaledPolySymb = (PolygonSymbolizer)visitor.getCopy();
            Assert.assertEquals((Object)polySymb.getFill(), (Object)rescaledPolySymb.getFill());
            Assert.assertNull((Object)rescaledPolySymb.getStroke());
            Assert.assertNotSame((Object)rescaledPolySymb, (Object)polySymb);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    @Test
    public void testVisitTextSymbolizer_LinePlacement() {
        try {
            Unit uom = SI.METRE;
            int fontSize = 100;
            double perpOffset = 13.0;
            double gap = 7.0;
            double initialGap = 5.0;
            double scaleMetersToPixel = 17.0;
            double expectedRescaledFontSize = this.computeExpectedRescaleSize(fontSize, scaleMetersToPixel, (Unit<Length>)uom);
            double expectedRescaledPerpOffset = this.computeExpectedRescaleSize(perpOffset, scaleMetersToPixel, (Unit<Length>)uom);
            double expectedRescaledGap = this.computeExpectedRescaleSize(gap, scaleMetersToPixel, (Unit<Length>)uom);
            double expectedRescaledInitialGap = this.computeExpectedRescaleSize(initialGap, scaleMetersToPixel, (Unit<Length>)uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            TextSymbolizerImpl textSymb = (TextSymbolizerImpl)styleBuilder.createTextSymbolizer();
            textSymb.setUnitOfMeasure(uom);
            Font font = styleBuilder.createFont(new java.awt.Font("Verdana", 0, fontSize));
            textSymb.setFont((org.opengis.style.Font)font);
            LinePlacement placement = styleBuilder.createLinePlacement(perpOffset);
            placement.setGap(styleBuilder.literalExpression(gap));
            placement.setInitialGap(styleBuilder.literalExpression(initialGap));
            textSymb.setLabelPlacement((LabelPlacement)placement);
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            textSymb.accept((StyleVisitor)visitor);
            TextSymbolizer rescaledTextSymb = (TextSymbolizer)visitor.getCopy();
            double rescaledFontSize = (Double)rescaledTextSymb.getFont().getSize().evaluate(null, Double.class);
            LinePlacement rescaledPlacement = (LinePlacement)rescaledTextSymb.getLabelPlacement();
            double rescaledPerpOffset = (Double)rescaledPlacement.getPerpendicularOffset().evaluate(null, Double.class);
            double rescaledGap = (Double)rescaledPlacement.getGap().evaluate(null, Double.class);
            double rescaledInitialGap = (Double)rescaledPlacement.getInitialGap().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledFontSize), (long)Math.round(rescaledFontSize));
            Assert.assertEquals((long)Math.round(expectedRescaledPerpOffset), (long)Math.round(rescaledPerpOffset));
            Assert.assertEquals((long)Math.round(expectedRescaledGap), (long)Math.round(rescaledGap));
            Assert.assertEquals((long)Math.round(expectedRescaledInitialGap), (long)Math.round(rescaledInitialGap));
            Assert.assertNotSame((Object)rescaledTextSymb, (Object)textSymb);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    @Test
    public void testVisitLineSymbolizer_ExpressionWithFeatureAttribute() {
        try {
            double widthValue = 13.0;
            double scaleMetersToPixel = 17.0;
            Unit uom = SI.METRE;
            StyleBuilder styleBuilder = new StyleBuilder();
            SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
            featureTypeBuilder.setName("TestType");
            featureTypeBuilder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            featureTypeBuilder.add("width", Double.class);
            SimpleFeatureType featureType = featureTypeBuilder.buildFeatureType();
            GeometryFactory geomFactory = new GeometryFactory();
            LineString geom = geomFactory.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)});
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
            featureBuilder.set("geom", (Object)geom);
            featureBuilder.set("width", (Object)widthValue);
            SimpleFeature feature = featureBuilder.buildFeature("1");
            Expression color = styleBuilder.colorExpression(Color.RED);
            Expression width = styleBuilder.attributeExpression("width");
            Stroke stroke = styleBuilder.createStroke(color, width);
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer(stroke);
            lineSymb.setUnitOfMeasure(uom);
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            Stroke rescaledStroke = rescaledLineSymb.getStroke();
            Expression rescaledWidth = rescaledStroke.getWidth();
            double rescaledWidthValue = (Double)rescaledWidth.evaluate((Object)feature, Double.class);
            double expectedRescaledWidthValue = this.computeExpectedRescaleSize(widthValue, scaleMetersToPixel, (Unit<Length>)uom);
            Assert.assertEquals((Object)stroke.getColor(), (Object)rescaledStroke.getColor());
            Assert.assertEquals((double)expectedRescaledWidthValue, (double)rescaledWidthValue, (double)0.0);
            Assert.assertNotSame((Object)SI.METRE, (Object)rescaledLineSymb.getUnitOfMeasure());
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    @Test
    public void testRescaleGraphicFillStrokes() {
        StyleBuilder sb = new StyleBuilder();
        Stroke stroke = sb.createStroke();
        stroke.setColor(null);
        stroke.setGraphicStroke((org.opengis.style.Graphic)sb.createGraphic(null, sb.createMark("square", null, sb.createStroke(1.0)), null));
        Fill fill = sb.createFill();
        fill.setColor(null);
        fill.setGraphicFill((org.opengis.style.Graphic)sb.createGraphic(null, sb.createMark("square", null, sb.createStroke(2.0)), null));
        PolygonSymbolizer ps = sb.createPolygonSymbolizer(stroke, fill);
        ps.setUnitOfMeasure(SI.METRE);
        UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(10.0);
        ps.accept((StyleVisitor)visitor);
        PolygonSymbolizer rps = (PolygonSymbolizer)visitor.getCopy();
        Mark rm = (Mark)rps.getStroke().getGraphicStroke().graphicalSymbols().get(0);
        Assert.assertEquals((double)10.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
        rm = (Mark)rps.getFill().getGraphicFill().graphicalSymbols().get(0);
        Assert.assertEquals((double)20.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
        LineSymbolizer ls = sb.createLineSymbolizer(stroke);
        ls.setUnitOfMeasure(SI.METRE);
        ls.accept((StyleVisitor)visitor);
        LineSymbolizer lps = (LineSymbolizer)visitor.getCopy();
        rm = (Mark)lps.getStroke().getGraphicStroke().graphicalSymbols().get(0);
        Assert.assertEquals((double)10.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
    }

    @Test
    public void testRescaleGraphicPointSymbolizer() {
        StyleBuilder sb = new StyleBuilder();
        Mark circle = sb.createMark("circle", null, sb.createStroke(500.0));
        Graphic g = sb.createGraphic(null, circle, null);
        PointSymbolizer ps = sb.createPointSymbolizer(g);
        ps.setUnitOfMeasure(USCustomary.FOOT);
        UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(10.0);
        ps.accept((StyleVisitor)visitor);
        PointSymbolizer rps = (PointSymbolizer)visitor.getCopy();
        Mark rm = (Mark)rps.getGraphic().graphicalSymbols().get(0);
        Assert.assertEquals((double)1524.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
        ps.setUnitOfMeasure(SI.METRE);
        visitor = new UomRescaleStyleVisitor(10.0);
        ps.accept((StyleVisitor)visitor);
        rps = (PointSymbolizer)visitor.getCopy();
        rm = (Mark)rps.getGraphic().graphicalSymbols().get(0);
        Assert.assertEquals((double)5000.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
    }

    @Test
    public void visitLocalUomMeters() {
        double size = 100.0;
        double scaleMetersToPixel = 10.0;
        double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, (Unit<Length>)SI.METRE);
        StyleBuilder styleBuilder = new StyleBuilder();
        LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer();
        lineSymb.getStroke().setWidth((Expression)this.ff.literal((Object)(size + "m")));
        UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
        lineSymb.accept((StyleVisitor)visitor);
        LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
        double rescaledSize = (Double)rescaledLineSymb.getStroke().getWidth().evaluate(null, Double.class);
        Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
        Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
    }

    @Test
    public void visitLocalUomOverrideFeet() {
        double size = 100.0;
        double scaleMetersToPixel = 10.0;
        double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, (Unit<Length>)SI.METRE);
        StyleBuilder styleBuilder = new StyleBuilder();
        LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer();
        lineSymb.setUnitOfMeasure(USCustomary.FOOT);
        lineSymb.getStroke().setWidth((Expression)this.ff.literal((Object)(size + "m")));
        UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
        lineSymb.accept((StyleVisitor)visitor);
        LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
        double rescaledSize = (Double)rescaledLineSymb.getStroke().getWidth().evaluate(null, Double.class);
        Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
        Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
    }

    @Test
    public void visitLocalUomPixelOverridingMeters() {
        double size = 100.0;
        double scaleMetersToPixel = 10.0;
        StyleBuilder styleBuilder = new StyleBuilder();
        LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer();
        lineSymb.setUnitOfMeasure(SI.METRE);
        lineSymb.getStroke().setWidth((Expression)this.ff.literal((Object)(size + "px")));
        UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
        lineSymb.accept((StyleVisitor)visitor);
        LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
        double rescaledSize = (Double)rescaledLineSymb.getStroke().getWidth().evaluate(null, Double.class);
        Assert.assertEquals((long)Math.round(rescaledSize), (long)Math.round(size));
        Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
    }

    @Test
    public void visitNullExpression() {
        Style style = SLD.createPolygonStyle((Color)Color.YELLOW, null, (float)0.0f);
        UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(1.0);
        style.accept((StyleVisitor)visitor);
    }

    @Test
    public void visitNullOption() {
        try {
            Unit uom = Units.PIXEL;
            StyleBuilder styleBuilder = new StyleBuilder();
            TextSymbolizerImpl textSymb = (TextSymbolizerImpl)styleBuilder.createTextSymbolizer();
            textSymb.setUnitOfMeasure(uom);
            textSymb.getOptions().put("graphic-margin", null);
            textSymb.getOptions().put("spaceAround", null);
            UomRescaleStyleVisitor visitor = new UomRescaleStyleVisitor(10.0);
            textSymb.accept((StyleVisitor)visitor);
        }
        catch (Exception e2) {
            Logger.getGlobal().log(Level.INFO, "", e2);
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }
}

