/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Icon;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.ExternalMark;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.OtherText;
import org.geotools.styling.OtherTextImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UomOgcMapping;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.ContrastMethod;
import org.opengis.style.OverlapBehavior;
import org.opengis.style.SemanticType;
import org.opengis.util.Cloneable;

public class DuplicatingStyleVisitorTest {
    StyleBuilder sb;
    StyleFactory sf;
    FilterFactory2 ff;
    DuplicatingStyleVisitor visitor;

    @Before
    public void setUp() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory(null);
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
        this.sb = new StyleBuilder(this.sf, (FilterFactory)this.ff);
        this.visitor = new DuplicatingStyleVisitor(this.sf, this.ff);
    }

    @Test
    public void testRasterSymbolizerDuplication() {
        RasterSymbolizer original = this.sb.createRasterSymbolizer();
        original.accept((StyleVisitor)this.visitor);
        RasterSymbolizer copy = (RasterSymbolizer)this.visitor.getCopy();
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)original, (Object)copy);
    }

    @Test
    public void testStyleDuplication() throws IllegalFilterException {
        Style oldStyle = this.sb.createStyle("FTSName", (Symbolizer)this.sf.createPolygonSymbolizer());
        ((FeatureTypeStyle)oldStyle.featureTypeStyles().get(0)).semanticTypeIdentifiers().addAll(Arrays.asList(SemanticType.valueOf((String)"simple"), SemanticType.valueOf((String)"generic:geometry")));
        oldStyle.accept((StyleVisitor)this.visitor);
        Style newStyle = (Style)this.visitor.getCopy();
        Assert.assertNotNull((Object)newStyle);
        Assert.assertEquals((long)2L, (long)((FeatureTypeStyle)newStyle.featureTypeStyles().get(0)).semanticTypeIdentifiers().size());
    }

    @Test
    public void testStyle() throws Exception {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type-1"));
        FeatureTypeStyle fts2 = this.fts2();
        Style style = this.sf.getDefaultStyle();
        style.featureTypeStyles().add(fts);
        style.featureTypeStyles().add(fts2);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertEqualsContract(style, copy);
        Style notEq = this.sf.getDefaultStyle();
        fts2 = this.fts2();
        notEq.featureTypeStyles().add(fts2);
        DuplicatingStyleVisitorTest.assertEqualsContract(copy, notEq, style);
    }

    private FeatureTypeStyle fts2() {
        FeatureTypeStyle fts2 = this.sf.createFeatureTypeStyle();
        Rule rule = this.sf.createRule();
        fts2.rules().add(rule);
        fts2.featureTypeNames().add(new NameImpl("feature-type-2"));
        return fts2;
    }

    @Test
    public void testFeatureTypeStyle() throws Exception {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type"));
        fts.getOptions().put("key", "value");
        Rule rule1 = this.sf.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.ff.id(Collections.singleton(this.ff.featureId("FID"))));
        Rule rule2 = this.sf.createRule();
        rule2.setElseFilter(true);
        rule2.setName("rule2");
        fts.rules().add(rule1);
        fts.rules().add(rule2);
        fts.accept((StyleVisitor)this.visitor);
        FeatureTypeStyle clone = (FeatureTypeStyle)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertEqualsContract(fts, clone);
        rule1 = this.sf.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.ff.id(Collections.singleton(this.ff.featureId("FID"))));
        FeatureTypeStyle notEq = this.sf.createFeatureTypeStyle();
        notEq.setName("fts-not-equal");
        notEq.rules().add(rule1);
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, fts);
        fts.setTransformation((Expression)this.ff.literal((Object)"transformation"));
        fts.setOnlineResource((OnLineResource)new OnLineResourceImpl());
        fts.accept((StyleVisitor)this.visitor);
        clone = (FeatureTypeStyle)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertEqualsContract(fts, clone);
    }

    @Test
    public void testRule() throws Exception {
        LineSymbolizer symb1 = this.sf.createLineSymbolizer(this.sf.getDefaultStroke(), "geometry");
        PolygonSymbolizer symb2 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "shape");
        Rule rule = this.sf.createRule();
        rule.symbolizers().addAll(Arrays.asList(symb1, symb2));
        rule.accept((StyleVisitor)this.visitor);
        Rule clone = (Rule)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(rule, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(rule, clone);
        symb2 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "shape");
        Rule notEq = this.sf.createRule();
        notEq.symbolizers().add(symb2);
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, rule);
        symb1 = this.sf.createLineSymbolizer(this.sf.getDefaultStroke(), "geometry");
        clone.symbolizers().add(symb1);
        Assert.assertNotEquals((Object)rule, (Object)clone);
    }

    @Test
    public void testPointSymbolizer() throws Exception {
        URL urlExternal = this.getClass().getResource("/data/sld/blob.gif");
        ExternalGraphic extg = this.sb.createExternalGraphic(urlExternal, "image/svg+xml");
        Graphic graphic = this.sb.createGraphic(extg, null, null);
        PointSymbolizer pointSymb = this.sb.createPointSymbolizer(graphic);
        pointSymb.accept((StyleVisitor)this.visitor);
        PointSymbolizer clone = (PointSymbolizer)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(pointSymb, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(pointSymb, clone);
        PointSymbolizer notEq = this.sf.getDefaultPointSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, pointSymb);
    }

    @Test
    public void testRasterSymbolizerWithUOM() throws Exception {
        RasterSymbolizer rasterSymb = this.sf.createRasterSymbolizer();
        rasterSymb.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
        rasterSymb.accept((StyleVisitor)this.visitor);
        RasterSymbolizer clone = (RasterSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)clone.getUnitOfMeasure(), (Object)rasterSymb.getUnitOfMeasure());
        RasterSymbolizer notEq = this.sf.createRasterSymbolizer();
        Assert.assertNotEquals((Object)notEq.getUnitOfMeasure(), (Object)rasterSymb.getUnitOfMeasure());
    }

    @Test
    public void testRasterSymbolizerWithOverlapBehavior() throws Exception {
        RasterSymbolizer rasterSymb1 = this.sf.createRasterSymbolizer();
        rasterSymb1.setOverlapBehavior(OverlapBehavior.AVERAGE);
        rasterSymb1.accept((StyleVisitor)this.visitor);
        RasterSymbolizer clone1 = (RasterSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)clone1.getOverlapBehavior(), (Object)rasterSymb1.getOverlapBehavior());
        RasterSymbolizer rasterSymbLiteral = this.sf.createRasterSymbolizer();
        rasterSymbLiteral.setOverlap((Expression)this.ff.literal((Object)OverlapBehavior.EARLIEST_ON_TOP.toString()));
        rasterSymbLiteral.accept((StyleVisitor)this.visitor);
        RasterSymbolizer cloneLiteral = (RasterSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)cloneLiteral.getOverlapBehavior(), (Object)rasterSymbLiteral.getOverlapBehavior());
        Assert.assertEquals((Object)cloneLiteral.getOverlap(), (Object)rasterSymbLiteral.getOverlap());
        RasterSymbolizer rasterSymb3 = this.sf.createRasterSymbolizer();
        try {
            rasterSymb3.setOverlap((Expression)this.ff.literal((Object)"invalid string"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        RasterSymbolizer notEq = this.sf.createRasterSymbolizer();
        Assert.assertNotEquals((Object)notEq.getOverlapBehavior(), (Object)rasterSymb1.getOverlapBehavior());
    }

    @Test
    public void testPointSymbolizerWithUOM() throws Exception {
        PointSymbolizer pointSymb = this.sf.createPointSymbolizer();
        pointSymb.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
        pointSymb.accept((StyleVisitor)this.visitor);
        PointSymbolizer clone = (PointSymbolizer)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(pointSymb, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(pointSymb, clone);
        PointSymbolizer notEq = this.sf.getDefaultPointSymbolizer();
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, pointSymb);
    }

    @Test
    public void testTextSymbolizer() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        Literal offset = this.ff.literal(10);
        textSymb.setLabelPlacement((org.opengis.style.LabelPlacement)this.sf.createLinePlacement((Expression)offset));
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(textSymb, clone);
        TextSymbolizer notEq = this.sf.getDefaultTextSymbolizer();
        Literal ancX = this.ff.literal(10);
        Literal ancY = this.ff.literal(10);
        AnchorPoint ancPoint = this.sf.createAnchorPoint((Expression)ancX, (Expression)ancY);
        PointPlacement placement = this.sf.createPointPlacement(ancPoint, null, null);
        notEq.setLabelPlacement((org.opengis.style.LabelPlacement)placement);
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, textSymb);
    }

    @Test
    public void testTextSymbolizerVendorParams() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        textSymb.getOptions().put("autoWrap", "100");
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(textSymb, clone);
        Assert.assertEquals((long)1L, (long)clone.getOptions().size());
        Assert.assertEquals((Object)"100", clone.getOptions().get("autoWrap"));
    }

    @Test
    public void testTextSymbolizerVendorOptions() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        textSymb.getOptions().put("autoWrap", "100");
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(textSymb, clone);
    }

    @Test
    public void testTextSymbolizerWithUOM() {
        TextSymbolizer textSymb = this.sf.createTextSymbolizer();
        textSymb.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        Literal offset = this.ff.literal(10);
        textSymb.setLabelPlacement((org.opengis.style.LabelPlacement)this.sf.createLinePlacement((Expression)offset));
        textSymb.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(textSymb, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(textSymb, clone);
        TextSymbolizer notEq = this.sf.getDefaultTextSymbolizer();
        Literal ancX = this.ff.literal(10);
        Literal ancY = this.ff.literal(10);
        AnchorPoint ancPoint = this.sf.createAnchorPoint((Expression)ancX, (Expression)ancY);
        PointPlacement placement = this.sf.createPointPlacement(ancPoint, null, null);
        notEq.setLabelPlacement((org.opengis.style.LabelPlacement)placement);
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, textSymb);
    }

    @Test
    public void testFont() {
        Font font = this.sf.getDefaultFont();
        Font clone = this.visitor.copy(font);
        DuplicatingStyleVisitorTest.assertCopy(font, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(font, clone);
        Font other = this.sf.createFont((Expression)this.ff.literal((Object)"other"), (Expression)this.ff.literal((Object)"normal"), (Expression)this.ff.literal((Object)"BOLD"), (Expression)this.ff.literal(12));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, other, font);
    }

    @Test
    public void testHalo() {
        Halo halo = this.sf.createHalo(this.sf.getDefaultFill(), (Expression)this.ff.literal(10));
        halo.accept((StyleVisitor)this.visitor);
        Halo clone = (Halo)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(halo, clone);
        Halo other = this.sf.createHalo(this.sf.getDefaultFill(), (Expression)this.ff.literal(12));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, other, halo);
    }

    @Test
    public void testLinePlacement() throws Exception {
        LinePlacement linePlacement = this.sf.createLinePlacement((Expression)this.ff.literal(12));
        linePlacement.accept((StyleVisitor)this.visitor);
        LinePlacement clone = (LinePlacement)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(linePlacement, clone);
        LinePlacement other = this.sf.createLinePlacement((Expression)this.ff.property("NAME"));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, other, linePlacement);
    }

    @Test
    public void testAnchorPoint() {
        AnchorPoint anchorPoint = this.sf.createAnchorPoint((Expression)this.ff.literal(1), (Expression)this.ff.literal(2));
        anchorPoint.accept((StyleVisitor)this.visitor);
        AnchorPoint clone = (AnchorPoint)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(anchorPoint, clone);
        AnchorPoint other = this.sf.createAnchorPoint((Expression)this.ff.literal(3), (Expression)this.ff.literal(4));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, other, anchorPoint);
    }

    @Test
    public void testDisplacement() {
        Displacement displacement = this.sf.createDisplacement((Expression)this.ff.literal(1), (Expression)this.ff.literal(2));
        displacement.accept((StyleVisitor)this.visitor);
        Displacement clone = (Displacement)this.visitor.getCopy();
        DuplicatingStyleVisitorTest.assertCopy(displacement, clone);
        Displacement other = this.sf.createDisplacement((Expression)this.ff.literal(3), (Expression)this.ff.literal(4));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, other, displacement);
    }

    @Test
    public void testPointPlacement() {
        PointPlacement pointPl = this.sf.getDefaultPointPlacement();
        PointPlacement clone = (PointPlacement)this.visitor.copy((LabelPlacement)pointPl);
        DuplicatingStyleVisitorTest.assertCopy(pointPl, clone);
        PointPlacement other = (PointPlacement)((Cloneable)pointPl).clone();
        other.setRotation((Expression)this.ff.literal(274.0));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, other, pointPl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPolygonSymbolizer() {
        try {
            PolygonSymbolizer polygonSymb = this.sf.createPolygonSymbolizer();
            PolygonSymbolizer clone = (PolygonSymbolizer)this.visitor.copy((Symbolizer)polygonSymb);
            DuplicatingStyleVisitorTest.assertCopy(polygonSymb, clone);
            PolygonSymbolizer notEq = this.sf.getDefaultPolygonSymbolizer();
            notEq.setGeometryPropertyName("something_else");
            DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, polygonSymb);
        }
        finally {
            this.visitor.setStrict(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPolygonSymbolizerWithUOM() {
        try {
            PolygonSymbolizer polygonSymb = this.sf.createPolygonSymbolizer();
            polygonSymb.setUnitOfMeasure(UomOgcMapping.FOOT.getUnit());
            PolygonSymbolizer clone = (PolygonSymbolizer)this.visitor.copy((Symbolizer)polygonSymb);
            DuplicatingStyleVisitorTest.assertCopy(polygonSymb, clone);
            PolygonSymbolizer notEq = this.sf.getDefaultPolygonSymbolizer();
            notEq.setUnitOfMeasure(UomOgcMapping.PIXEL.getUnit());
            DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, polygonSymb);
        }
        finally {
            this.visitor.setStrict(false);
        }
    }

    @Test
    public void testLineSymbolizer() {
        LineSymbolizer lineSymb = this.sf.createLineSymbolizer();
        LineSymbolizer clone = (LineSymbolizer)this.visitor.copy((Symbolizer)lineSymb);
        DuplicatingStyleVisitorTest.assertCopy(lineSymb, clone);
        LineSymbolizer notEq = this.sf.getDefaultLineSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, lineSymb);
    }

    @Test
    public void testLineSymbolizerWithUOM() {
        LineSymbolizer lineSymb = this.sf.createLineSymbolizer();
        LineSymbolizer clone = (LineSymbolizer)this.visitor.copy((Symbolizer)lineSymb);
        DuplicatingStyleVisitorTest.assertCopy(lineSymb, clone);
        LineSymbolizer notEq = this.sf.getDefaultLineSymbolizer();
        notEq.setUnitOfMeasure(UomOgcMapping.METRE.getUnit());
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, lineSymb);
    }

    @Test
    public void testGraphic() {
        Graphic graphic = this.sf.getDefaultGraphic();
        graphic.graphicalSymbols().add(this.sf.getDefaultMark());
        Graphic clone = this.visitor.copy(graphic);
        DuplicatingStyleVisitorTest.assertCopy(graphic, clone);
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, graphic);
        Assert.assertEquals((long)clone.graphicalSymbols().size(), (long)graphic.graphicalSymbols().size());
        Graphic notEq = this.sf.getDefaultGraphic();
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, graphic);
    }

    @Test
    public void testExternalGraphic() {
        ExternalGraphic exGraphic = this.sf.createExternalGraphic("http://somewhere", "image/png");
        ExternalGraphic clone = this.visitor.copy(exGraphic);
        DuplicatingStyleVisitorTest.assertCopy(exGraphic, clone);
        ExternalGraphic notEq = this.sf.createExternalGraphic("http://somewhereelse", "image/jpeg");
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, exGraphic);
        ExternalGraphic notEq2 = this.visitor.copy(clone);
        notEq2.setFormat("image/jpeg");
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq2, exGraphic);
    }

    @Test
    public void testExternalGraphicWithInlineContent() {
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public int getIconHeight() {
                return 16;
            }
        };
        ExternalGraphic exGraphic = this.sf.createExternalGraphic(icon, "image/png");
        ExternalGraphic clone = this.visitor.copy(exGraphic);
        DuplicatingStyleVisitorTest.assertCopy(exGraphic, clone);
        Assert.assertSame((Object)exGraphic.getInlineContent(), (Object)clone.getInlineContent());
        ExternalGraphic notEq = this.sf.createExternalGraphic(icon, "image/jpeg");
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, exGraphic);
        ExternalGraphic notEq2 = this.visitor.copy(clone);
        notEq2.setFormat("image/jpeg");
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq2, exGraphic);
    }

    @Test
    public void testMark() {
        Mark mark = this.sf.getCircleMark();
        Mark clone = this.visitor.copy(mark);
        DuplicatingStyleVisitorTest.assertCopy(mark, clone);
        Mark notEq = this.sf.getStarMark();
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, mark);
    }

    @Test
    public void testExternalMark() throws URISyntaxException {
        OnLineResourceImpl or = new OnLineResourceImpl();
        or.setLinkage(new URI("ttf://wingdings"));
        ExternalMark externalMark = this.sf.externalMark((OnLineResource)or, "ttf", 15);
        Mark mark = this.sf.createMark();
        mark.setExternalMark((org.opengis.style.ExternalMark)externalMark);
        Mark clone = this.visitor.copy(mark);
        DuplicatingStyleVisitorTest.assertCopy(mark, clone);
        DuplicatingStyleVisitorTest.assertCopy(mark.getExternalMark(), clone.getExternalMark());
        ExternalMark emCopy = clone.getExternalMark();
        Assert.assertEquals((Object)"ttf", (Object)emCopy.getFormat());
        Assert.assertEquals((Object)"ttf://wingdings", (Object)emCopy.getOnlineResource().getLinkage().toASCIIString());
        Assert.assertEquals((long)15L, (long)emCopy.getMarkIndex());
    }

    @Test
    public void testFill() {
        Fill fill = this.sf.getDefaultFill();
        Fill clone = this.visitor.copy(fill);
        DuplicatingStyleVisitorTest.assertCopy(fill, clone);
        Fill notEq = this.sf.createFill((Expression)this.ff.literal((Object)"#FF0000"));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, fill);
    }

    @Test
    public void testStroke() {
        Stroke stroke = this.sf.getDefaultStroke();
        Stroke clone = this.visitor.copy(stroke);
        DuplicatingStyleVisitorTest.assertCopy(stroke, clone);
        Stroke notEq = this.sf.createStroke((Expression)this.ff.literal((Object)"#FF0000"), (Expression)this.ff.literal(10));
        DuplicatingStyleVisitorTest.assertEqualsContract(clone, notEq, stroke);
        Stroke dashArray = this.sf.getDefaultStroke();
        dashArray.setDashArray(new float[]{1.0f, 2.0f, 3.0f});
        Stroke dashArray2 = (Stroke)((Cloneable)dashArray).clone();
        DuplicatingStyleVisitorTest.assertEqualsContract(dashArray, dashArray2);
    }

    private static void assertCopy(Object real, Object clone) {
        Assert.assertNotNull((String)"Real was null", (Object)real);
        Assert.assertNotNull((String)"Clone was null", (Object)clone);
        Assert.assertNotSame((String)(real.getClass().getName() + " was not cloned"), (Object)real, (Object)clone);
    }

    private static void assertEqualsContract(Object controlEqual, Object controlNe, Object test) {
        Assert.assertNotNull((Object)controlEqual);
        Assert.assertNotNull((Object)controlNe);
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((String)"Reflexivity test failed", (Object)test, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)controlEqual, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)test, (Object)controlEqual);
        Assert.assertNotEquals((String)"Symmetry test failed", (Object)test, (Object)controlNe);
        Assert.assertNotEquals((String)"Symmetry test failed", (Object)controlNe, (Object)test);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)controlEqual, (Object)controlNe);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)test, (Object)controlNe);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)controlNe, (Object)controlEqual);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)controlNe, (Object)test);
        Assert.assertNotEquals((String)"Non-null test failed", null, (Object)test);
    }

    private static void assertEqualsContract(Object controlEqual, Object test) {
        Assert.assertNotNull((Object)controlEqual);
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((String)"Reflexivity test failed", (Object)test, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)controlEqual, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)test, (Object)controlEqual);
        Assert.assertNotEquals((String)"Non-null test failed", null, (Object)test);
        int controlEqHash = controlEqual.hashCode();
        int testHash = test.hashCode();
        Assert.assertEquals((String)"Equal objects should return equal hashcodes", (long)controlEqHash, (long)testHash);
    }

    @Test
    public void testContrastEnhancementDuplication() throws Exception {
        ContrastEnhancement ce = this.sf.createContrastEnhancement();
        ce.setGammaValue(this.sb.literalExpression(0.5));
        ce.setMethod(ContrastMethod.HISTOGRAM);
        ce.accept((StyleVisitor)this.visitor);
        ContrastEnhancement ce2 = (ContrastEnhancement)this.visitor.getCopy();
        Assert.assertEquals((String)"Gamma value incorrest after duplication", (Object)((Literal)ce.getGammaValue()).getValue(), (Object)((Literal)ce2.getGammaValue()).getValue());
        Assert.assertEquals((String)"ContrastMethod must be equal after duplication ", (Object)ce.getMethod(), (Object)ce2.getMethod());
    }

    @Test
    public void testColorMapEntryDuplication() throws Exception {
        ColorMapEntry cme = this.sf.createColorMapEntry();
        cme.setColor(this.sb.colorExpression(Color.YELLOW));
        cme.setLabel("thelabel");
        cme.setQuantity(this.sb.literalExpression(66.66));
        cme.setOpacity(this.sb.literalExpression(0.77));
        cme.accept((StyleVisitor)this.visitor);
        ColorMapEntry cme2 = (ColorMapEntry)this.visitor.getCopy();
        Assert.assertEquals((String)"Colormaps LABEL must be equal after duplication ", (Object)cme.getLabel(), (Object)cme2.getLabel());
        Assert.assertEquals((String)"Colormaps QUANTITY must be equal after duplication ", (Object)cme.getQuantity(), (Object)cme2.getQuantity());
        Assert.assertEquals((String)"Colormaps COLOR must be equal after duplication ", (Object)cme.getColor(), (Object)cme2.getColor());
        Assert.assertEquals((String)"Colormaps OPACITY must be equal after duplication ", (Object)cme.getOpacity(), (Object)cme2.getOpacity());
    }

    @Test
    public void testPointSymbolizerWithGeomFunction() throws Exception {
        URL urlExternal = this.getClass().getResource("/data/sld/blob.gif");
        ExternalGraphic extg = this.sb.createExternalGraphic(urlExternal, "image/svg+xml");
        Graphic graphic = this.sb.createGraphic(extg, null, null);
        PointSymbolizer pointSymb = this.sb.createPointSymbolizer(graphic);
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        pointSymb.setGeometry((Expression)geomFunc);
        pointSymb.accept((StyleVisitor)this.visitor);
        PointSymbolizer copy = (PointSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    @Test
    public void testRasterSymbolizerDuplicationWithGeometryFunction() {
        RasterSymbolizer original = this.sb.createRasterSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        original.setGeometry((Expression)geomFunc);
        original.accept((StyleVisitor)this.visitor);
        RasterSymbolizer copy = (RasterSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    @Test
    public void testLineSymbolizerWithGeometryFunction() {
        LineSymbolizer lineSymb = this.sf.createLineSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        lineSymb.setGeometry((Expression)geomFunc);
        LineSymbolizer copy = (LineSymbolizer)this.visitor.copy((Symbolizer)lineSymb);
        Assert.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    @Test
    public void testPolygonSymbolizerWithGeometryFunction() {
        PolygonSymbolizer symb = this.sf.createPolygonSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("thr_geom")});
        symb.setGeometry((Expression)geomFunc);
        PolygonSymbolizer copy = (PolygonSymbolizer)this.visitor.copy((Symbolizer)symb);
        Assert.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    @Test
    public void testTextSymbolizerWithGeometryFunction() {
        TextSymbolizer symb = this.sf.createTextSymbolizer();
        Function geomFunc = this.ff.function("centroid", new Expression[]{this.ff.property("the_geom")});
        symb.setGeometry((Expression)geomFunc);
        TextSymbolizer copy = (TextSymbolizer)this.visitor.copy((Symbolizer)symb);
        Assert.assertEquals((String)"Any Expression set as Geometry must be correctly replicated", (Object)geomFunc, (Object)copy.getGeometry());
    }

    @Test
    public void testTextSymbolizer2() {
        TextSymbolizer2 symb = (TextSymbolizer2)this.sf.createTextSymbolizer();
        GraphicImpl gr = new GraphicImpl((FilterFactory)this.ff);
        gr.setOpacity((Expression)this.ff.literal(0.77));
        gr.setSize((Expression)this.ff.literal(77));
        symb.setGraphic((Graphic)gr);
        Literal snippet = this.ff.literal((Object)"no idea what a snipet is good for");
        symb.setSnippet((Expression)snippet);
        Literal fD = this.ff.literal((Object)"some description");
        symb.setFeatureDescription((Expression)fD);
        OtherTextImpl otherText = new OtherTextImpl();
        otherText.setTarget("otherTextTarget");
        otherText.setText((Expression)this.ff.literal((Object)"otherTextText"));
        symb.setOtherText((OtherText)otherText);
        TextSymbolizer2 copy = (TextSymbolizer2)this.visitor.copy((Symbolizer)symb);
        Assert.assertEquals((String)"Graphic of TextSymbolizer2 has not been correctly duplicated", (Object)gr, (Object)copy.getGraphic());
        Assert.assertEquals((String)"Graphic of TextSymbolizer2 has not been correctly duplicated", (Object)gr.getOpacity(), (Object)copy.getGraphic().getOpacity());
        Assert.assertEquals((String)"Graphic of TextSymbolizer2 has not been correctly duplicated", (Object)gr.getSize(), (Object)copy.getGraphic().getSize());
        Assert.assertEquals((String)"Snippet of TextSymbolizer2 has not been correctly duplicated", (Object)snippet, (Object)copy.getSnippet());
        Assert.assertEquals((String)"FeatureDescription of TextSymbolizer2 has not been correctly duplicated", (Object)fD, (Object)copy.getFeatureDescription());
        Assert.assertEquals((String)"OtherText of TextSymbolizer2 has not been correctly duplicated", (Object)otherText.getTarget(), (Object)copy.getOtherText().getTarget());
        Assert.assertEquals((String)"OtherText of TextSymbolizer2 has not been correctly duplicated", (Object)otherText.getText(), (Object)copy.getOtherText().getText());
    }

    @Test
    public void testLineSymbolizerWithPerpendicularOffset() {
        LineSymbolizer ls = this.sf.createLineSymbolizer();
        ls.setPerpendicularOffset((Expression)this.ff.literal(0.88));
        LineSymbolizer copy = (LineSymbolizer)this.visitor.copy((Symbolizer)ls);
        Assert.assertEquals((String)"PerpendicularOffset of LineSymbolizer has not been correctly duplicated", (Object)ls.getPerpendicularOffset(), (Object)copy.getPerpendicularOffset());
    }

    @Test
    public void testSelectedChannelTypeDuplication() throws Exception {
        String b1 = "b1";
        SelectedChannelType sct = this.sf.createSelectedChannelType((Expression)this.ff.function("env", new Expression[]{this.ff.literal((Object)"b1"), this.ff.literal((Object)"1")}), this.sf.createContrastEnhancement());
        sct.accept((StyleVisitor)this.visitor);
        SelectedChannelType clone = (SelectedChannelType)this.visitor.getCopy();
        Assert.assertEquals((Object)sct, (Object)clone);
    }
}

