/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.StyleImpl;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.style.Graphic;

public class TextSymbolTest {
    String dataFolder = System.getProperty("dataFolder");

    public TextSymbolTest() {
        if (this.dataFolder == null) {
            this.dataFolder = System.getProperty("basedir");
            this.dataFolder = this.dataFolder + "/tests/unit/testData";
        }
    }

    @Test
    public void testRender() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setCRS(null);
        ftb.add("centre", Point.class);
        ftb.add("size", Double.class);
        ftb.add("rotation", Double.class);
        ftb.add("symbol", String.class);
        ftb.setName("test");
        SimpleFeatureType pointType = ftb.buildFeatureType();
        ListFeatureCollection data = new ListFeatureCollection(pointType);
        String[] symbol = new String[]{"\uf04a", "\uf04b", "\uf059", "\uf05a", "\uf06b", "\uf06c", "\uf06e"};
        double size = 16.0;
        double rotation = 0.0;
        int rows = 8;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < symbol.length; ++i) {
                Point point = this.makeSamplePoint(geomFac, (double)i * 5.0 + 5.0, 5.0 + (double)(j * 5));
                SimpleFeature pointFeature = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{point, size, rotation, symbol[i]}, null);
                data.add(pointFeature);
            }
            size += 2.0;
            rotation += 45.0;
        }
        MarkImpl textMark = new MarkImpl("square");
        GraphicImpl graphic = new GraphicImpl();
        graphic.graphicalSymbols().add(textMark);
        PointSymbolizerImpl pointsym = new PointSymbolizerImpl();
        pointsym.setGeometryPropertyName("centre");
        pointsym.setGraphic((Graphic)graphic);
        RuleImpl rule = new RuleImpl();
        rule.symbolizers().add(pointsym);
        FeatureTypeStyleImpl fts = new FeatureTypeStyleImpl();
        fts.rules().add(rule);
        fts.featureTypeNames().add(new NameImpl("testPoint"));
        StyleImpl style = new StyleImpl();
        style.featureTypeStyles().add(fts);
    }

    private Point makeSamplePoint(GeometryFactory geomFac, double x, double y) {
        Coordinate c = new Coordinate(x, y);
        Point point = geomFac.createPoint(c);
        return point;
    }
}

