/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class SLDTest {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    StyleBuilder sb = new StyleBuilder((FilterFactory)this.ff);

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testDefaults() {
        Stroke stroke = this.sf.getDefaultStroke();
        Assert.assertEquals((String)"default stroke width is one", (long)1L, (long)SLD.width((Stroke)stroke));
        Assert.assertEquals((String)"default stroke color is black", (Object)Color.BLACK, (Object)SLD.color((Stroke)stroke));
    }

    @Test
    public void testStroke() {
        Stroke stroke = this.sf.createStroke((Expression)this.ff.literal((Object)"#FF0000"), (Expression)this.ff.literal((Object)"3"));
        Assert.assertEquals((String)"width", (long)3L, (long)SLD.width((Stroke)stroke));
        Assert.assertEquals((String)"color", (Object)Color.RED, (Object)SLD.color((Stroke)stroke));
        stroke = this.sf.createStroke((Expression)this.ff.literal((Object)"#FF0000"), (Expression)this.ff.literal((Object)"3.0"));
        Assert.assertEquals((String)"width", (long)3L, (long)SLD.width((Stroke)stroke));
    }

    @Test
    public void testSetRasterOpacity() {
        RasterSymbolizer rs = this.sb.createRasterSymbolizer();
        Style s = this.sb.createStyle((Symbolizer)rs);
        Assert.assertEquals((double)1.0, (double)SLD.opacity((RasterSymbolizer)SLD.rasterSymbolizer((Style)s)), (double)0.0);
        SLD.setRasterOpacity((Style)s, (double)0.25);
        Assert.assertEquals((double)0.25, (double)SLD.opacity((RasterSymbolizer)SLD.rasterSymbolizer((Style)s)), (double)0.0);
        Assert.assertNotSame((Object)SLD.rasterSymbolizer((Style)s), (Object)rs);
    }

    @Test
    public void testSetRasterRGBChannels() {
        RasterSymbolizer rs = this.sb.createRasterSymbolizer();
        Style s = this.sb.createStyle((Symbolizer)rs);
        SelectedChannelType red = this.sf.createSelectedChannelType("red", this.sf.createContrastEnhancement((Expression)this.ff.literal(0.2)));
        SelectedChannelType green = this.sf.createSelectedChannelType("green", this.sf.createContrastEnhancement((Expression)this.ff.literal(0.4)));
        SelectedChannelType blue = this.sf.createSelectedChannelType("blue", this.sf.createContrastEnhancement((Expression)this.ff.literal(0.7)));
        SLD.setChannelSelection((Style)s, (SelectedChannelType[])new SelectedChannelType[]{red, green, blue}, null);
        Assert.assertNull((Object)SLD.rasterSymbolizer((Style)s).getChannelSelection().getGrayChannel());
        Assert.assertNotNull((Object)SLD.rasterSymbolizer((Style)s).getChannelSelection().getRGBChannels());
        SelectedChannelType[] selectedChannels = SLD.rasterSymbolizer((Style)s).getChannelSelection().getRGBChannels();
        Assert.assertEquals((Object)"red", (Object)selectedChannels[0].getChannelName().evaluate(null, String.class));
        Assert.assertEquals((Object)"green", (Object)selectedChannels[1].getChannelName().evaluate(null, String.class));
        Assert.assertEquals((Object)"blue", (Object)selectedChannels[2].getChannelName().evaluate(null, String.class));
        Assert.assertNotSame((Object)SLD.rasterSymbolizer((Style)s), (Object)rs);
    }
}

